/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.Database;
import io.ebean.SqlUpdate;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.IntersectionTable;
import io.ebeaninternal.server.persist.MergeNode;
import io.ebeaninternal.server.persist.MergeRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

final class MergeNodeAssocManyToMany
extends MergeNode {
    private final BeanPropertyAssocMany<?> many;

    MergeNodeAssocManyToMany(String fullPath, BeanPropertyAssocMany<?> property) {
        super(fullPath, property);
        this.many = property;
    }

    @Override
    public void merge(MergeRequest request) {
        EntityBean parentBean = request.getBean();
        Collection beans = this.many.rawCollection(parentBean);
        Collection outlines = this.many.rawCollection(request.getOutline());
        Map<Object, EntityBean> outlineIds = this.toMap(outlines);
        ArrayList<EntityBean> additions = new ArrayList<EntityBean>();
        if (beans != null) {
            for (Object bean : beans) {
                EntityBean entityBean = (EntityBean)bean;
                Object beanId = this.targetDescriptor.getId(entityBean);
                if (beanId == null || outlineIds.remove(beanId) != null) continue;
                additions.add(entityBean);
            }
        }
        ArrayList<EntityBean> deletions = new ArrayList<EntityBean>(outlineIds.values());
        SpiEbeanServer server = request.getServer();
        SpiTransaction transaction = request.getTransaction();
        IntersectionTable intersectionTable = this.many.intersectionTable();
        if (!deletions.isEmpty()) {
            transaction.flush();
            SqlUpdate delete = intersectionTable.delete((Database)server);
            for (EntityBean deletion : deletions) {
                this.many.intersectionBind(delete, parentBean, deletion);
                delete.addBatch();
            }
            delete.execute();
        }
        if (!additions.isEmpty()) {
            transaction.flush();
            SqlUpdate insert = intersectionTable.insert((Database)server);
            for (EntityBean addition : additions) {
                this.many.intersectionBind(insert, parentBean, addition);
                insert.addBatch();
            }
            insert.execute();
        }
        this.many.resetMany(parentBean);
    }
}

