/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

public final class Flags {
    public static final int INSERT = 1;
    public static final int RECURSE = 2;
    public static final int MERGE = 8;
    public static final int NORMAL = 16;
    public static final int ZERO = 0;
    private static final int MERGE_NORMAL = 24;
    private static final int INSERT_NORMAL = 17;

    public static boolean isInsert(int state) {
        return Flags.isSet(state, 1);
    }

    public static boolean isRecurse(int state) {
        return Flags.isSet(state, 2);
    }

    public static boolean isMerge(int state) {
        return Flags.isSet(state, 8);
    }

    public static boolean isMergeOrNormal(int state) {
        return (state & 0x18) != 0;
    }

    public static boolean isUpdateForce(int state) {
        return !Flags.isSet(state, 1) && !Flags.isSet(state, 16);
    }

    public static boolean isSet(int state, int flag) {
        return (state & flag) == flag;
    }

    public static int setInsert(int state) {
        return Flags.set(state, 1);
    }

    public static int setInsertNormal(int state) {
        return Flags.set(state, 17);
    }

    public static int setUpdate(int state) {
        return Flags.unset(state, 1);
    }

    public static int setUpdateNormal(int state) {
        state &= 0xFFFFFFFE;
        return state |= 0x10;
    }

    public static int setRecurse(int state) {
        return Flags.set(state, 2);
    }

    public static int unsetRecurse(int state) {
        return Flags.unset(state, 2);
    }

    public static int setMerge(int state) {
        return Flags.set(state, 8);
    }

    public static int unsetMerge(int state) {
        return Flags.unset(state, 8);
    }

    private static int set(int state, int flag) {
        return state | flag;
    }

    private static int unset(int state, int flag) {
        return state & ~flag;
    }
}

