/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiUpdate;
import io.ebeaninternal.server.core.PersistRequestOrmUpdate;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.persist.PstmtFactory;
import io.ebeaninternal.server.util.BindParamsParser;
import jakarta.persistence.PersistenceException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

final class ExeOrmUpdate {
    private final Binder binder;
    private final PstmtFactory pstmtFactory = new PstmtFactory();

    ExeOrmUpdate(Binder binder) {
        this.binder = binder;
    }

    public int execute(PersistRequestOrmUpdate request) {
        boolean batchThisRequest = request.isBatchThisRequest();
        PreparedStatement pstmt = null;
        try {
            pstmt = this.bindStmt(request, batchThisRequest);
            if (batchThisRequest) {
                pstmt.addBatch();
                int n = -1;
                return n;
            }
            SpiUpdate<?> ormUpdate = request.ormUpdate();
            if (ormUpdate.timeout() > 0) {
                pstmt.setQueryTimeout(ormUpdate.timeout());
            }
            int rowCount = pstmt.executeUpdate();
            request.checkRowCount(rowCount);
            request.postExecute();
            int n = rowCount;
            return n;
        }
        catch (SQLException ex) {
            throw new PersistenceException("Error executing: " + request.ormUpdate().getGeneratedSql(), (Throwable)ex);
        }
        finally {
            if (!batchThisRequest) {
                JdbcClose.close((Statement)pstmt);
            }
        }
    }

    private String translate(PersistRequestOrmUpdate request, String sql) {
        BeanDescriptor<?> descriptor = request.descriptor();
        return descriptor.convertOrmUpdateToSql(sql);
    }

    private PreparedStatement bindStmt(PersistRequestOrmUpdate request, boolean batchThisRequest) throws SQLException {
        PreparedStatement pstmt;
        request.startBind(batchThisRequest);
        SpiUpdate<?> ormUpdate = request.ormUpdate();
        SpiTransaction t = request.transaction();
        String sql = ormUpdate.updateStatement();
        sql = this.translate(request, sql);
        BindParams bindParams = ormUpdate.bindParams();
        sql = BindParamsParser.parse(bindParams, sql);
        ormUpdate.setGeneratedSql(sql);
        if (batchThisRequest) {
            pstmt = this.pstmtFactory.pstmtBatch(t, sql, request);
        } else {
            if (t.isLogSql()) {
                t.logSql(sql, new Object[0]);
            }
            pstmt = this.pstmtFactory.pstmt(t, sql, false);
        }
        String bindLog = null;
        if (!bindParams.isEmpty()) {
            bindLog = this.binder.bind(bindParams, pstmt, t.internalConnection());
        }
        request.setBindLog(bindLog);
        return pstmt;
    }
}

