/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiCallableSql;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.PersistRequestCallableSql;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.persist.PstmtFactory;
import io.ebeaninternal.server.persist.TrimLogSql;
import io.ebeaninternal.server.util.BindParamsParser;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;

final class ExeCallableSql {
    private final Binder binder;
    private final PstmtFactory pstmtFactory;

    ExeCallableSql(Binder binder) {
        this.binder = binder;
        this.pstmtFactory = new PstmtFactory();
    }

    public int execute(PersistRequestCallableSql request) {
        boolean batchThisRequest = request.isBatchThisRequest();
        CallableStatement cstmt = null;
        try {
            cstmt = this.bindStmt(request, batchThisRequest);
            if (batchThisRequest) {
                cstmt.addBatch();
                int n = -1;
                return n;
            }
            int rowCount = request.executeUpdate();
            request.postExecute();
            int n = rowCount;
            return n;
        }
        catch (SQLException ex) {
            throw request.translateSqlException(ex);
        }
        finally {
            if (!batchThisRequest) {
                JdbcClose.close((Statement)cstmt);
            }
        }
    }

    private CallableStatement bindStmt(PersistRequestCallableSql request, boolean batchThisRequest) throws SQLException {
        CallableStatement cstmt;
        request.startBind(batchThisRequest);
        SpiCallableSql callableSql = request.callableSql();
        SpiTransaction t = request.transaction();
        String sql = callableSql.getSql();
        BindParams bindParams = callableSql.bindParams();
        sql = BindParamsParser.parse(bindParams, sql);
        boolean logSql = request.logSql();
        if (batchThisRequest) {
            cstmt = this.pstmtFactory.cstmtBatch(t, logSql, sql, request);
        } else {
            if (logSql) {
                t.logSql(TrimLogSql.trim(sql), new Object[0]);
            }
            cstmt = this.pstmtFactory.cstmt(t, sql);
        }
        if (callableSql.getTimeout() > 0) {
            cstmt.setQueryTimeout(callableSql.getTimeout());
        }
        String bindLog = null;
        if (!bindParams.isEmpty()) {
            bindLog = this.binder.bind(bindParams, cstmt, t.internalConnection());
        }
        request.setBindLog(bindLog);
        request.setBound(bindParams, cstmt);
        return cstmt;
    }
}

