/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.logger;

import io.ebeaninternal.api.SpiLogManager;
import io.ebeaninternal.api.SpiLogger;
import io.ebeaninternal.api.SpiTxnLogger;
import io.ebeaninternal.server.logger.DTxnLogger;
import java.util.concurrent.atomic.AtomicLong;

public final class DLogManager
implements SpiLogManager {
    private final SpiLogger sql;
    private final SpiLogger summary;
    private final SpiLogger txn;
    private final boolean useIds;
    private final AtomicLong counter = new AtomicLong(1000L);
    private final DTxnLogger readOnly;

    public DLogManager(SpiLogger sql, SpiLogger summary, SpiLogger txn) {
        this.sql = sql;
        this.summary = summary;
        this.txn = txn;
        this.useIds = txn.isDebug();
        this.readOnly = new DTxnLogger(null, sql, summary, txn);
    }

    @Override
    public boolean enableBindLog() {
        return this.sql.isDebug();
    }

    @Override
    public SpiLogger sql() {
        return this.sql;
    }

    @Override
    public SpiTxnLogger logger() {
        String id = this.useIds ? Long.toString(this.counter.incrementAndGet()) : "";
        return new DTxnLogger(id, this.sql, this.summary, this.txn);
    }

    @Override
    public SpiTxnLogger readOnlyLogger() {
        return this.readOnly;
    }
}

