/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionBind;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.DeployPropertyParser;
import io.ebeaninternal.server.expression.NonPrepareExpression;
import io.ebeaninternal.server.expression.Same;
import io.ebeaninternal.server.persist.MultiValueWrapper;
import java.util.Collection;

final class RawExpression
extends NonPrepareExpression {
    final String sql;
    final Object[] values;
    private String prefixPath;

    RawExpression(String sql, Object[] values) {
        this.sql = sql;
        this.values = values;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
    }

    @Override
    public void addBindValues(SpiExpressionBind request) {
        if (this.values != null) {
            for (Object value : this.values) {
                if (value instanceof Collection) {
                    request.addBindValue(new MultiValueWrapper((Collection)value));
                    continue;
                }
                request.addBindValue(value);
            }
        }
    }

    @Override
    public void prefixProperty(String path) {
        this.prefixPath = path;
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.prefixPath == null) {
            request.parse(this.sql);
        } else {
            BeanDescriptor<?> descriptor = request.descriptor();
            BeanProperty beanProperty = descriptor.findPropertyFromPath(this.prefixPath);
            BeanPropertyAssoc bpa = (BeanPropertyAssoc)beanProperty;
            DeployPropertyParser parser = bpa.targetDescriptor().parser();
            request.append(RawExpression.filterManyPaths(this.prefixPath, parser.parse(this.sql)));
        }
    }

    static String filterManyPaths(String prefix, String raw) {
        StringBuilder sb = new StringBuilder(raw.length() + 50);
        int lastPos = 0;
        int nextPos = raw.indexOf("${");
        while (nextPos > -1) {
            sb.append(raw.substring(lastPos, nextPos)).append("${").append(prefix);
            if (raw.charAt(nextPos + 2) != '}') {
                sb.append('.');
            }
            lastPos = nextPos + 2;
            nextPos = raw.indexOf("${", nextPos + 2);
        }
        sb.append(raw.substring(lastPos));
        return sb.toString();
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("Raw[").append(this.sql);
        if (this.values != null) {
            builder.append(" ?").append(this.values.length);
        }
        builder.append(']');
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.values.length);
        for (Object value : this.values) {
            key.add(value);
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        if (!(other instanceof RawExpression)) {
            return false;
        }
        RawExpression that = (RawExpression)other;
        if (this.values.length != that.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (Same.sameByValue(this.values[i], that.values[i])) continue;
            return false;
        }
        return true;
    }
}

