/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.bean.EntityBean;
import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionBind;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.IdInCommon;
import io.ebeaninternal.server.expression.NamedParamHelp;
import io.ebeaninternal.server.persist.MultiValueWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class InExpression
extends AbstractExpression
implements IdInCommon {
    private final boolean empty;
    private final boolean not;
    private final Collection<?> sourceValues;
    private List<Object> bindValues;
    private boolean multiValueSupported;

    InExpression(String propertyName, Collection<?> sourceValues, boolean not) {
        this(propertyName, sourceValues, not, false);
    }

    InExpression(String propertyName, Collection<?> sourceValues, boolean not, boolean orEmpty) {
        super(propertyName);
        this.sourceValues = sourceValues;
        this.not = not;
        this.empty = orEmpty && (sourceValues == null || sourceValues.isEmpty());
    }

    InExpression(String propertyName, Object[] array, boolean not) {
        super(propertyName);
        this.sourceValues = Arrays.asList(array);
        this.not = not;
        this.empty = false;
    }

    public String property() {
        return this.propName;
    }

    @Override
    public Collection<?> idValues() {
        if (this.bindValues == null) {
            this.bindValues = new ArrayList(this.sourceValues);
        }
        return this.bindValues;
    }

    @Override
    public int removeIds(Set<Object> hitIds) {
        this.bindValues.removeAll(hitIds);
        return this.bindValues.size();
    }

    private List<Object> values() {
        if (this.empty || this.sourceValues == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> vals = new ArrayList<Object>(this.sourceValues.size());
        for (Object sourceValue : this.sourceValues) {
            assert (sourceValue != null) : "null is not allowed in in-queries";
            NamedParamHelp.valueAdd(vals, sourceValue);
        }
        return vals;
    }

    private List<Object> initBindValues() {
        if (this.bindValues == null) {
            this.bindValues = this.values();
        }
        return this.bindValues;
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        if (this.not || this.empty) {
            return false;
        }
        return data.matchIn(this.propName, this.initBindValues());
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        this.initBindValues();
        if (this.bindValues.size() > 0) {
            this.multiValueSupported = request.isMultiValueSupported(this.bindValues.get(0).getClass());
        }
    }

    @Override
    public void addBindValues(SpiExpressionBind request) {
        if (this.empty) {
            return;
        }
        for (Object value : this.bindValues) {
            if (value != null) continue;
            throw new NullPointerException("null values in 'in(...)' queries must be handled separately!");
        }
        ElPropertyValue prop = this.getElProp(request);
        List<Object> values = this.bindValues;
        if (prop != null && prop.isAssocId()) {
            values = new ArrayList<Object>();
            for (Object bindValue : this.bindValues) {
                Object[] ids = prop.assocIdValues((EntityBean)bindValue);
                if (ids == null) continue;
                Collections.addAll(values, ids);
            }
        }
        if (values.isEmpty()) {
            return;
        }
        if (prop != null) {
            if (prop.isDbEncrypted()) {
                request.addBindEncryptKey(prop.beanProperty().encryptKey().getStringValue());
            } else if (prop.isLocalEncrypted()) {
                ArrayList<Object> encValues = new ArrayList<Object>(values.size());
                for (Object value : values) {
                    encValues.add(prop.localEncrypt(value));
                }
                request.addBindEncryptKey(new MultiValueWrapper(encValues));
                return;
            }
        }
        request.addBindValue(new MultiValueWrapper(values));
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.empty) {
            request.append("1=1");
            return;
        }
        if (this.bindValues.isEmpty()) {
            request.append(this.not ? "1=1" : "1=0");
            return;
        }
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                request.parse(prop.assocIdInExpr(this.propName));
                request.append(prop.assocIdInValueExpr(this.not, this.bindValues.size()));
                return;
            }
            if (prop.isDbEncrypted()) {
                request.parse(prop.beanProperty().decryptProperty(this.propName));
                request.appendInExpression(this.not, this.bindValues);
                return;
            }
        }
        request.property(this.propName);
        request.appendInExpression(this.not, this.bindValues);
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        if (this.not) {
            builder.append("NotIn[");
        } else {
            builder.append("In[");
        }
        builder.append(this.propName);
        if (this.empty) {
            builder.append("empty");
        } else {
            builder.append(" ?");
            if (!this.multiValueSupported || this.bindValues.isEmpty()) {
                builder.append(this.bindValues.size());
            }
        }
        builder.append(']');
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        key.add(this.bindValues.size());
        for (Object bindValue : this.bindValues) {
            key.add(bindValue);
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        InExpression that = (InExpression)other;
        if (this.bindValues.size() != that.bindValues.size()) {
            return false;
        }
        for (int i = 0; i < this.bindValues.size(); ++i) {
            if (this.bindValues.get(i).equals(that.bindValues.get(i))) continue;
            return false;
        }
        return true;
    }
}

