/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionBind;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.expression.UnsupportedDocStoreExpression;
import io.ebeaninternal.server.query.CQuery;
import java.util.List;

final class ExistsQueryExpression
implements SpiExpression,
UnsupportedDocStoreExpression {
    private final boolean not;
    private final SpiQuery<?> subQuery;
    private List<Object> bindParams;
    private String sql;

    ExistsQueryExpression(SpiQuery<?> subQuery, boolean not) {
        this.subQuery = subQuery;
        this.not = not;
    }

    ExistsQueryExpression(boolean not, String sql, List<Object> bindParams) {
        this.not = not;
        this.sql = sql;
        this.bindParams = bindParams;
        this.subQuery = null;
    }

    @Override
    public SpiExpression copy() {
        return this.subQuery == null ? this : new ExistsQueryExpression(this.subQuery.copy(), this.not);
    }

    @Override
    public void prefixProperty(String path) {
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        return false;
    }

    @Override
    public void simplify() {
    }

    @Override
    public Object getIdEqualTo(String idName) {
        return null;
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        CQuery<?> subQuery = this.compileSubQuery(request);
        this.bindParams = subQuery.predicates().whereExprBindValues();
        this.sql = subQuery.generatedSql().replace('\n', ' ');
    }

    @Override
    public SpiExpression copyForPlanKey() {
        return this;
    }

    CQuery<?> compileSubQuery(BeanQueryRequest<?> queryRequest) {
        SpiEbeanServer ebeanServer = (SpiEbeanServer)queryRequest.database();
        return ebeanServer.compileQuery(SpiQuery.Type.SQ_EXISTS, this.subQuery, queryRequest.transaction());
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("ExistsQuery[").append(" not:").append(this.not);
        builder.append(" sql:").append(this.sql).append(" ?:").append(this.bindParams.size()).append(']');
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        this.subQuery.queryBindKey(key);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.not) {
            request.append("not ");
        }
        request.append("exists (").parse(this.sql).append(')');
    }

    @Override
    public void addBindValues(SpiExpressionBind request) {
        for (Object bindParam : this.bindParams) {
            request.addBindValue(bindParam);
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        ExistsQueryExpression that = (ExistsQueryExpression)other;
        if (this.bindParams.size() != that.bindParams.size()) {
            return false;
        }
        for (int i = 0; i < this.bindParams.size(); ++i) {
            if (this.bindParams.get(i).equals(that.bindParams.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins whereManyJoins) {
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
    }
}

