/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebeaninternal.server.core.InternString;
import io.ebeaninternal.server.deploy.meta.DeployTableJoinColumn;

public final class TableJoinColumn {
    private final String localDbColumn;
    private final String localSqlFormula;
    private final String foreignDbColumn;
    private final String foreignSqlFormula;
    private final boolean insertable;
    private final boolean updateable;
    private final boolean nullable;
    private final int queryHash;

    public TableJoinColumn(DeployTableJoinColumn deploy) {
        this.localDbColumn = InternString.intern(deploy.getLocalDbColumn());
        this.foreignDbColumn = InternString.intern(deploy.getForeignDbColumn());
        this.localSqlFormula = InternString.intern(deploy.getLocalSqlFormula());
        this.foreignSqlFormula = InternString.intern(deploy.getForeignSqlFormula());
        this.insertable = deploy.isInsertable();
        this.updateable = deploy.isUpdatable();
        this.nullable = deploy.isNullable();
        this.queryHash = this.hash();
    }

    private TableJoinColumn(TableJoinColumn source, String overrideColumn) {
        this.localDbColumn = InternString.intern(overrideColumn);
        this.foreignDbColumn = source.foreignDbColumn;
        this.localSqlFormula = null;
        this.foreignSqlFormula = null;
        this.insertable = source.isInsertable();
        this.updateable = source.isUpdateable();
        this.nullable = source.isNullable();
        this.queryHash = this.hash();
    }

    private int hash() {
        int result = this.localDbColumn != null ? this.localDbColumn.hashCode() : 0;
        result = 92821 * result + (this.foreignDbColumn != null ? this.foreignDbColumn.hashCode() : 0);
        result = 92821 * result + (this.localSqlFormula != null ? this.localSqlFormula.hashCode() : 0);
        result = 92821 * result + (this.foreignSqlFormula != null ? this.foreignSqlFormula.hashCode() : 0);
        result = 92821 * result + (this.insertable ? 1 : 0);
        result = 92821 * result + (this.updateable ? 1 : 0);
        return result;
    }

    public int hashCode() {
        return this.queryHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableJoinColumn that = (TableJoinColumn)o;
        if (this.insertable != that.insertable) {
            return false;
        }
        if (this.updateable != that.updateable) {
            return false;
        }
        if (!this.localDbColumn.equals(that.localDbColumn)) {
            return false;
        }
        return this.foreignDbColumn.equals(that.foreignDbColumn);
    }

    public String toString() {
        return (this.localSqlFormula == null ? this.localDbColumn : this.localSqlFormula) + " = " + (this.foreignSqlFormula == null ? this.foreignDbColumn : this.foreignSqlFormula);
    }

    int queryHash() {
        return this.queryHash;
    }

    public String getForeignDbColumn() {
        return this.foreignDbColumn;
    }

    public String getLocalDbColumn() {
        return this.localDbColumn;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    boolean isUpdateable() {
        return this.updateable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getLocalSqlFormula() {
        return this.localSqlFormula;
    }

    public String getForeignSqlFormula() {
        return this.foreignSqlFormula;
    }

    TableJoinColumn withOverrideColumn(String overrideColumn) {
        return new TableJoinColumn(this, overrideColumn);
    }
}

