/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.server.core.DefaultSqlUpdate;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.expression.DefaultExpressionRequest;
import io.ebeaninternal.server.expression.IdInExpression;
import io.ebeaninternal.server.persist.DeleteMode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class IntersectionRow {
    private final String tableName;
    private final BeanDescriptor<?> targetDescriptor;
    private final LinkedHashMap<String, Object> values = new LinkedHashMap();
    private Set<Object> excludeIds;
    private BeanDescriptor<?> excludeDescriptor;

    IntersectionRow(String tableName, BeanDescriptor<?> targetDescriptor) {
        this.tableName = tableName;
        this.targetDescriptor = targetDescriptor;
    }

    IntersectionRow(String tableName) {
        this.tableName = tableName;
        this.targetDescriptor = null;
    }

    void setExcludeIds(Set<Object> excludeIds, BeanDescriptor<?> excludeDescriptor) {
        this.excludeIds = excludeIds;
        this.excludeDescriptor = excludeDescriptor;
    }

    public void put(String key, Object value) {
        this.values.put(key, value);
    }

    public SpiSqlUpdate createInsert(SpiEbeanServer server) {
        BindParams bindParams = new BindParams();
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ").append(this.tableName).append(" (");
        int count = 0;
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            if (count++ > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            bindParams.setParameter(count, entry.getValue());
        }
        sb.append(") values (");
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('?');
        }
        sb.append(')');
        return new DefaultSqlUpdate(server, sb.toString(), bindParams);
    }

    public SpiSqlUpdate createDelete(SpiEbeanServer server, DeleteMode deleteMode) {
        BindParams bindParams = new BindParams();
        StringBuilder sb = new StringBuilder();
        if (deleteMode.isHard()) {
            sb.append("delete from ").append(this.tableName);
        } else {
            sb.append("update ").append(this.tableName).append(" set ");
            sb.append(this.targetDescriptor.softDeleteDbSet());
        }
        sb.append(" where ");
        int count = this.setBindParams(bindParams, sb);
        if (this.excludeIds != null) {
            IdInExpression idIn = new IdInExpression(this.excludeIds);
            DefaultExpressionRequest er = new DefaultExpressionRequest(this.excludeDescriptor);
            idIn.addSqlNoAlias(er);
            idIn.addBindValues(er);
            sb.append(" and not ( ");
            sb.append(er.sql());
            sb.append(" ) ");
            List<Object> bindValues = er.bindValues();
            for (Object bindValue : bindValues) {
                bindParams.setParameter(++count, bindValue);
            }
        }
        return new DefaultSqlUpdate(server, sb.toString(), bindParams);
    }

    public SpiSqlUpdate createDeleteChildren(SpiEbeanServer server) {
        BindParams bindParams = new BindParams();
        StringBuilder sb = new StringBuilder();
        sb.append("delete from ").append(this.tableName).append(" where ");
        this.setBindParams(bindParams, sb);
        return new DefaultSqlUpdate(server, sb.toString(), bindParams);
    }

    private int setBindParams(BindParams bindParams, StringBuilder sb) {
        int count = 0;
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            if (count++ > 0) {
                sb.append(" and ");
            }
            sb.append(entry.getKey());
            sb.append(" = ?");
            bindParams.setParameter(count, entry.getValue());
        }
        return count;
    }
}

