/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.Transaction;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.server.core.DefaultSqlUpdate;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.ExportedProperty;
import io.ebeaninternal.server.deploy.visitor.BaseTablePropertyVisitor;
import io.ebeaninternal.server.deploy.visitor.VisitProperties;
import io.ebeaninternal.server.util.Str;
import java.util.List;
import java.util.Set;

class BeanPropertyAssocManySqlHelp<T> {
    private final BeanPropertyAssocMany<T> many;
    private final ExportedProperty[] exportedProperties;
    private final boolean hasJoinTable;
    private final BeanDescriptor<?> descriptor;
    private final String exportedPropertyBindProto;
    private final String deleteByParentIdSql;
    private final String deleteByParentIdInSql;
    private final String elementCollectionInsertSql;
    private final boolean idInExpandedForm;

    BeanPropertyAssocManySqlHelp(BeanPropertyAssocMany<T> many, ExportedProperty[] exportedProperties) {
        this.many = many;
        this.exportedProperties = exportedProperties;
        this.hasJoinTable = many.hasJoinTable();
        this.descriptor = many.descriptor();
        this.exportedPropertyBindProto = this.initExportedBindProto();
        this.idInExpandedForm = this.descriptor.idBinder().isIdInExpandedForm();
        String delStmt = this.hasJoinTable ? "delete from " + many.inverseJoin.getTable() + " where " : "delete from " + many.targetTable() + " where ";
        this.deleteByParentIdSql = delStmt + this.rawParentIdEQ("");
        this.deleteByParentIdInSql = delStmt;
        this.elementCollectionInsertSql = many.isElementCollection() ? this.elementCollectionInsert() : null;
    }

    private String elementCollectionInsert() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("insert into ").append(this.many.targetTable()).append(" (");
        this.append(sb);
        Cols cols = new Cols(sb);
        VisitProperties.visit(this.many.targetDescriptor, cols);
        sb.append(") values (");
        this.appendBind(sb, this.exportedProperties.length, true);
        this.appendBind(sb, cols.colCount, false);
        sb.append(')');
        return sb.toString();
    }

    SpiSqlUpdate insertElementCollection() {
        return new DefaultSqlUpdate(this.elementCollectionInsertSql);
    }

    String lazyFetchOrderBy(String fetchOrderBy) {
        String fkTableAlias = this.hasJoinTable ? "int_" : "t0";
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(fkTableAlias).append('.').append(this.exportedProperties[i].getForeignDbColumn());
        }
        sb.append(", ").append(fetchOrderBy);
        return sb.toString().trim();
    }

    void addWhereParentIdIn(SpiQuery<?> query, List<Object> parentIds) {
        String tableAlias;
        String string = tableAlias = this.hasJoinTable ? "int_." : "t0.";
        if (this.hasJoinTable) {
            query.setM2MIncludeJoin(this.many.inverseJoin);
        }
        String rawWhere = this.rawParentIdIN(tableAlias, parentIds.size());
        this.many.bindParentIdsIn(rawWhere, parentIds, query);
    }

    List<Object> findIdsByParentId(Object parentId, Transaction t, boolean includeSoftDeletes, Set<Object> excludeDetailIds) {
        SpiEbeanServer server = this.descriptor.ebeanServer();
        SpiQuery query = this.many.newQuery(server);
        query.usingTransaction(t);
        this.many.bindParentIdEq(this.rawParentIdEQ(""), parentId, query);
        if (includeSoftDeletes) {
            query.setIncludeSoftDeletes();
        }
        if (excludeDetailIds != null && !excludeDetailIds.isEmpty()) {
            query.where().not(query.getExpressionFactory().idIn(excludeDetailIds));
        }
        return server.findIds(query);
    }

    List<Object> findIdsByParentIdList(List<Object> parentIds, Transaction t, boolean includeSoftDeletes) {
        SpiEbeanServer server = this.descriptor.ebeanServer();
        SpiQuery query = this.many.newQuery(server);
        query.usingTransaction(t);
        this.many.bindParentIdsIn(this.rawParentIdIN("", parentIds.size()), parentIds, query);
        if (includeSoftDeletes) {
            query.setIncludeSoftDeletes();
        }
        return server.findIds(query);
    }

    SpiSqlUpdate deleteByParentId(Object parentId) {
        DefaultSqlUpdate sqlDelete = new DefaultSqlUpdate(this.deleteByParentIdSql);
        this.many.bindParentId(sqlDelete, parentId);
        return sqlDelete;
    }

    SpiSqlUpdate deleteByParentIdList(List<Object> parentIds) {
        String rawWhere = this.rawParentIdIN("", parentIds.size());
        String sql = Str.add(this.deleteByParentIdInSql, rawWhere);
        DefaultSqlUpdate delete = new DefaultSqlUpdate(sql);
        this.many.bindParentIds(delete, parentIds);
        return delete;
    }

    private void appendBind(StringBuilder sb, int count, boolean skipComma) {
        for (int i = 0; i < count; ++i) {
            if (!skipComma || i > 0) {
                sb.append(',');
            }
            sb.append('?');
        }
    }

    private void append(StringBuilder sb) {
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.exportedProperties[i].getForeignDbColumn());
        }
    }

    private String rawParentIdIN(String tableAlias, int size) {
        if (this.idInExpandedForm) {
            return this.rawParentIdExpanded(tableAlias, size);
        }
        return this.rawParentIdStandard(tableAlias, size);
    }

    private String rawParentIdStandard(String tableAlias, int size) {
        int i;
        if (this.descriptor.isSimpleId()) {
            return this.rawParentIdMultiBinder(tableAlias, size);
        }
        StringBuilder sb = new StringBuilder(100 + size * this.exportedPropertyBindProto.length());
        sb.append('(');
        for (i = 0; i < this.exportedProperties.length; ++i) {
            String fkColumn = this.exportedProperties[i].getForeignDbColumn();
            if (i > 0) {
                sb.append(',');
            }
            sb.append(tableAlias).append(fkColumn);
        }
        sb.append(") in (");
        for (i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.exportedPropertyBindProto);
        }
        sb.append(')');
        return sb.toString();
    }

    private String rawParentIdMultiBinder(String tableAlias, int size) {
        String property = "(" + tableAlias + this.exportedProperties[0].getForeignDbColumn() + ")";
        String inValueExpr = this.descriptor.idBinder().idInValueExpr(false, size);
        return property + inValueExpr;
    }

    private String rawParentIdExpanded(String tableAlias, int size) {
        String proto = this.parentIdExpandedProto(tableAlias);
        StringBuilder result = new StringBuilder(size * (proto.length() + 2) + 10).append('(');
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                result.append(" or ");
            }
            result.append(proto);
        }
        return result.append(')').toString();
    }

    private String parentIdExpandedProto(String tableAlias) {
        StringBuilder sb = new StringBuilder(60).append('(');
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(tableAlias).append(this.exportedProperties[i].getForeignDbColumn()).append("=?");
        }
        return sb.append(')').toString();
    }

    private String rawParentIdEQ(String tableAlias) {
        StringBuilder sb = new StringBuilder(80);
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(tableAlias).append(this.exportedProperties[i].getForeignDbColumn()).append("=?");
        }
        return sb.toString();
    }

    private String initExportedBindProto() {
        if (this.exportedProperties.length == 1) {
            return "?";
        }
        StringBuilder sb = new StringBuilder(this.exportedProperties.length * 2 + 2);
        sb.append('(');
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('?');
        }
        sb.append(')');
        return sb.toString();
    }

    private static class Cols
    extends BaseTablePropertyVisitor {
        int colCount;
        private final StringBuilder sb;

        private Cols(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void visitEmbeddedScalar(BeanProperty p, BeanPropertyAssocOne<?> embedded) {
            this.sb.append(',').append(p.dbColumn());
            ++this.colCount;
        }

        @Override
        public void visitOneImported(BeanPropertyAssocOne<?> p) {
        }

        @Override
        public void visitScalar(BeanProperty p, boolean allowNonNull) {
            this.sb.append(',').append(p.dbColumn());
            ++this.colCount;
        }

        @Override
        public void visitEnd() {
        }
    }
}

