/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.persist.BatchControl;
import io.ebeaninternal.server.persist.PersistExecute;
import io.ebeaninternal.server.persist.TrimLogSql;
import java.util.List;

public final class PersistRequestUpdateSql
extends PersistRequest {
    private final SpiSqlUpdate updateSql;
    private int rowCount;
    private String bindLog;
    private SqlType sqlType;
    private String tableName;
    private boolean addBatch;
    private final boolean forceNoBatch;
    private boolean batchThisRequest;
    private boolean flushQueue;

    public PersistRequestUpdateSql(SpiEbeanServer server, SpiSqlUpdate sqlUpdate, SpiTransaction t, PersistExecute persistExecute, boolean forceNoBatch) {
        super(server, t, persistExecute, sqlUpdate.getLabel());
        this.type = PersistRequest.Type.UPDATESQL;
        this.updateSql = sqlUpdate;
        this.forceNoBatch = forceNoBatch;
        this.updateSql.reset();
    }

    public PersistRequestUpdateSql(SpiEbeanServer server, SpiSqlUpdate sqlUpdate, SpiTransaction t, PersistExecute persistExecute) {
        this(server, sqlUpdate, t, persistExecute, false);
    }

    @Override
    public void profile(long offset, int flushCount) {
        this.profileBase("su", offset, "", flushCount);
    }

    public void addBatch() {
        this.addBatch = true;
        this.executeStatement(true);
    }

    public void executeAddBatch() {
        this.addBatch = true;
        this.persistExecute.executeSqlUpdate(this);
    }

    public void addToFlushQueue(int pos) {
        BatchControl control = this.transaction.batchControl();
        if (control == null) {
            control = this.persistExecute.createBatchControl(this.transaction);
        }
        this.flushQueue = true;
        control.addToFlushQueue(this, pos);
    }

    @Override
    public boolean isFlushQueue() {
        return this.flushQueue;
    }

    @Override
    public int executeNow() {
        return this.persistExecute.executeSqlUpdate(this);
    }

    @Override
    public boolean isBatchThisRequest() {
        return !this.forceNoBatch && (this.addBatch || super.isBatchThisRequest());
    }

    @Override
    public int executeOrQueue() {
        return this.executeStatement();
    }

    public SpiSqlUpdate updateSql() {
        return this.updateSql;
    }

    @Override
    public void checkRowCount(int count) {
        this.rowCount = count;
    }

    @Override
    public void setGeneratedKey(Object idValue) {
        this.updateSql.setGeneratedKey(idValue);
    }

    public boolean isGetGeneratedKeys() {
        return this.updateSql.isGetGeneratedKeys();
    }

    public void setType(SqlType sqlType, String tableName) {
        this.sqlType = sqlType;
        this.tableName = tableName;
    }

    public void setBindLog(String bindLog) {
        this.bindLog = bindLog;
    }

    @Override
    public void startBind(boolean batchThisRequest) {
        this.batchThisRequest = batchThisRequest;
        super.startBind(batchThisRequest);
    }

    public void logSqlBatchBind() {
        if (this.transaction.isLogSql()) {
            this.transaction.logSql(" -- bind({0})", this.bindLog);
        }
    }

    @Override
    public void postExecute() {
        List<BeanDescriptor<?>> descriptors;
        if (this.sqlType != SqlType.SQL_INSERT && !this.transaction.isAutoPersistUpdates() && (descriptors = this.server.descriptors(this.tableName)) != null) {
            for (BeanDescriptor<?> descriptor : descriptors) {
                descriptor.contextClear(this.transaction.persistenceContext());
            }
        }
        if (this.startNanos > 0L) {
            this.persistExecute.collectSqlUpdate(this.label, this.startNanos);
        }
        if (this.transaction.isLogSql() && !this.batchThisRequest) {
            this.transaction.logSql("{0}; -- bind({1}) rows({2})", TrimLogSql.trim(this.updateSql.getGeneratedSql()), this.bindLog, this.rowCount);
        }
        if (this.updateSql.isAutoTableMod()) {
            switch (this.sqlType.ordinal()) {
                case 2: {
                    this.transaction.event().add(this.tableName, true, false, false);
                    break;
                }
                case 0: {
                    this.transaction.event().add(this.tableName, false, true, false);
                    break;
                }
                case 1: {
                    this.transaction.event().add(this.tableName, false, false, true);
                    break;
                }
                case 3: {
                    this.transaction.markNotQueryOnly();
                }
            }
        }
    }

    public static enum SqlType {
        SQL_UPDATE,
        SQL_DELETE,
        SQL_INSERT,
        SQL_UNKNOWN;

    }
}

