/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.DatabaseBuilder;
import io.ebean.annotation.Platform;
import io.ebean.datasource.DataSourceAlertFactory;
import io.ebean.datasource.DataSourceBuilder;
import io.ebean.datasource.DataSourcePoolListener;
import io.ebeaninternal.server.core.ServiceUtil;
import jakarta.persistence.PersistenceException;
import javax.sql.DataSource;

final class InitDataSource {
    private final DatabaseBuilder.Settings config;

    static void init(DatabaseBuilder.Settings config) {
        new InitDataSource(config).initialise();
    }

    InitDataSource(DatabaseBuilder.Settings config) {
        this.config = config;
    }

    private void initialise() {
        if (this.config.getDataSource() == null) {
            this.config.setDataSource(this.initDataSource());
        }
        if (this.config.getReadOnlyDataSource() == null) {
            this.config.setReadOnlyDataSource(this.initReadOnlyDataSource());
        }
    }

    private DataSource initDataSource() {
        return this.createFromConfig(this.config.getDataSourceConfig(), this.config.readOnlyDatabase(), false);
    }

    private DataSource initReadOnlyDataSource() {
        if (this.config.readOnlyDatabase()) {
            return this.config.getDataSource();
        }
        DataSourceBuilder.Settings roConfig = this.readOnlyConfig();
        return roConfig == null ? null : this.createFromConfig(roConfig, false, true);
    }

    DataSourceBuilder.Settings readOnlyConfig() {
        DataSourceBuilder.Settings roConfig = this.config.getReadOnlyDataSourceConfig();
        if (roConfig == null) {
            return null;
        }
        if (this.urlSet(roConfig.getUrl())) {
            return roConfig;
        }
        String readOnlyUrl = this.config.getDataSourceConfig().getReadOnlyUrl();
        if (this.urlSet(readOnlyUrl)) {
            roConfig.url(readOnlyUrl);
            return roConfig;
        }
        if (this.config.isAutoReadOnlyDataSource()) {
            roConfig.url(null);
            return roConfig;
        }
        return null;
    }

    private boolean urlSet(String url) {
        return url != null && !"none".equalsIgnoreCase(url) && !url.trim().isEmpty();
    }

    private DataSource createFromConfig(DataSourceBuilder.Settings dsConfig, boolean readOnlyDB, boolean readOnly) {
        if (dsConfig == null) {
            throw new PersistenceException("No  DataSourceBuilder defined for " + this.config.getName());
        }
        if (dsConfig.isOffline() && this.config.getDatabasePlatformName() == null) {
            throw new PersistenceException("You MUST specify a DatabasePlatformName on DatabaseConfig when offline");
        }
        this.attachAlert(dsConfig);
        this.attachListener(dsConfig);
        if (readOnlyDB) {
            dsConfig.autoCommit(true);
            dsConfig.readOnly(true);
        } else if (readOnly) {
            DataSourceBuilder.Settings mainSettings = this.config.getDataSourceConfig();
            dsConfig.autoCommit(true);
            dsConfig.readOnly(true);
            dsConfig.setDefaults((DataSourceBuilder)mainSettings);
            dsConfig.isolationLevel(mainSettings.getIsolationLevel());
        } else if (this.isPostgresAllQuotedIdentifiers()) {
            dsConfig.addProperty("quoteReturningIdentifiers", false);
        }
        return this.create((DataSourceBuilder)dsConfig, readOnly);
    }

    boolean isPostgresAllQuotedIdentifiers() {
        return this.config.isAllQuotedIdentifiers() && Platform.POSTGRES == this.config.getDatabasePlatform().platform().base();
    }

    private DataSource create(DataSourceBuilder dsConfig, boolean readOnly) {
        String poolName = this.config.getName() + (readOnly ? "-ro" : "");
        return dsConfig.name(poolName).build();
    }

    private void attachAlert(DataSourceBuilder.Settings dsConfig) {
        DataSourceAlertFactory alertFactory = (DataSourceAlertFactory)this.config.getServiceObject(DataSourceAlertFactory.class);
        if (alertFactory == null) {
            alertFactory = ServiceUtil.service(DataSourceAlertFactory.class);
        }
        if (alertFactory != null) {
            dsConfig.alert(alertFactory.createAlert());
        }
    }

    private void attachListener(DataSourceBuilder.Settings dsConfig) {
        String poolListener;
        if (dsConfig.getListener() == null && (poolListener = dsConfig.getPoolListener()) != null) {
            dsConfig.listener((DataSourcePoolListener)this.config.getClassLoadConfig().newInstance(poolListener));
        }
    }
}

