/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.InterceptReadWrite;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;

public final class CachedBeanDataToBean {
    public static void load(BeanDescriptor<?> desc, EntityBean bean, CachedBeanData cacheBeanData, PersistenceContext context) {
        EntityBeanIntercept ebi = bean._ebean_getIntercept();
        ebi.setLoadedFromCache(true);
        BeanProperty idProperty = desc.idProperty();
        if (idProperty != null) {
            CachedBeanDataToBean.loadProperty(bean, cacheBeanData, ebi, idProperty, context);
        }
        for (BeanProperty prop : desc.propertiesNonMany()) {
            CachedBeanDataToBean.loadProperty(bean, cacheBeanData, ebi, prop, context);
        }
        boolean addManyReferences = ebi instanceof InterceptReadWrite;
        for (BeanPropertyAssocMany<?> prop : desc.propertiesMany()) {
            if (prop.isElementCollection()) {
                CachedBeanDataToBean.loadProperty(bean, cacheBeanData, ebi, prop, context);
                continue;
            }
            if (!addManyReferences) continue;
            prop.createReferenceIfNull(bean);
        }
        ebi.setLoadedLazy();
    }

    private static void loadProperty(EntityBean bean, CachedBeanData cacheBeanData, EntityBeanIntercept ebi, BeanProperty prop, PersistenceContext context) {
        if (cacheBeanData.isLoaded(prop.name()) && !ebi.isLoadedProperty(prop.propertyIndex())) {
            Object value = cacheBeanData.getData(prop.name());
            prop.setCacheDataValue(bean, value, context);
        }
    }
}

