/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.meta;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class QueryPlanInit {
    private final Map<String, Long> hashes = new HashMap<String, Long>();
    private boolean all;
    private long defaultThresholdMicros;

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public long thresholdMicros() {
        return this.defaultThresholdMicros;
    }

    public void thresholdMicros(long thresholdMicros) {
        this.defaultThresholdMicros = thresholdMicros;
    }

    public boolean includeHash(String hash) {
        return this.all || this.hashes.containsKey(hash);
    }

    public void add(String hash, long thresholdMicros) {
        Objects.requireNonNull(hash);
        if (!"all".equals(hash)) {
            this.hashes.put(hash, thresholdMicros);
        } else {
            this.all = true;
            if (thresholdMicros > 0L) {
                this.defaultThresholdMicros = thresholdMicros;
            }
        }
    }

    public void remove(String hash) {
        this.hashes.remove(hash);
    }

    public long thresholdMicros(String hash) {
        Long threshold = this.hashes.get(hash);
        return threshold == null || threshold < 1L ? this.defaultThresholdMicros : threshold;
    }

    public boolean isEmpty() {
        return !this.all && this.hashes.isEmpty();
    }

    public String toString() {
        return "QueryPlanInit{all=" + this.all + ", hashes=" + String.valueOf(this.hashes) + ", thresholdMicros=" + this.defaultThresholdMicros + "}";
    }
}

