/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.meta;

import io.ebean.meta.MetaCountMetric;
import io.ebean.meta.MetaMetric;
import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.ServerMetrics;
import io.ebean.meta.ServerMetricsAsJson;
import io.ebean.meta.SortMetric;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.List;

final class MetricsAsJson
implements ServerMetricsAsJson {
    private final ServerMetrics metrics;
    private Appendable writer;
    private int includeExtraAttributes = 1;
    private boolean withHeader = true;
    private boolean withHash = true;
    private String newLine = "\n";
    private Comparator<MetaTimedMetric> sortBy = SortMetric.NAME;
    private int listCounter;
    private int objKeyCounter;

    MetricsAsJson(ServerMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public ServerMetricsAsJson withHeader(boolean withHeader) {
        this.withHeader = withHeader;
        return this;
    }

    @Override
    public ServerMetricsAsJson withExtraAttributes(boolean extraAttributes) {
        this.includeExtraAttributes = extraAttributes ? 2 : 0;
        return this;
    }

    @Override
    public ServerMetricsAsJson withHash(boolean withHash) {
        this.withHash = withHash;
        return this;
    }

    @Override
    public ServerMetricsAsJson withSort(Comparator<MetaTimedMetric> sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @Override
    public ServerMetricsAsJson withNewLine(boolean withNewLine) {
        this.newLine = withNewLine ? "\n" : "";
        return this;
    }

    @Override
    public String json() {
        this.writer = new StringWriter();
        this.collect();
        return this.writer.toString();
    }

    @Override
    public void write(Appendable buffer) {
        this.writer = buffer;
        this.collect();
    }

    private void collect() {
        try {
            List<MetaQueryMetric> list;
            this.start();
            for (MetaTimedMetric metaTimedMetric : this.metrics.timedMetrics()) {
                this.logTimed(metaTimedMetric);
            }
            List<MetaCountMetric> countMetrics = this.metrics.countMetrics();
            if (!countMetrics.isEmpty()) {
                if (this.sortBy != null) {
                    countMetrics.sort(SortMetric.COUNT_NAME);
                }
                for (MetaCountMetric metric : countMetrics) {
                    this.logCount(metric);
                }
            }
            if (!(list = this.metrics.queryMetrics()).isEmpty()) {
                if (this.sortBy != null) {
                    list.sort(this.sortBy);
                }
                for (MetaQueryMetric metric : list) {
                    this.logQuery(metric);
                }
            }
            this.end();
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing metrics as JSON", e);
        }
    }

    private void start() throws IOException {
        if (this.withHeader) {
            this.objStart();
            this.key("db");
            this.val(this.metrics.name());
            this.key("metrics");
            this.listStart();
        }
    }

    private void end() throws IOException {
        if (this.withHeader) {
            this.listEnd();
            this.objEnd();
        }
    }

    private void objStart() throws IOException {
        this.objKeyCounter = 0;
        this.writer.append('{');
    }

    private void objEnd() throws IOException {
        this.writer.append('}');
    }

    private void listStart() throws IOException {
        this.listCounter = 0;
        this.writer.append('[');
        this.writer.append(this.newLine);
    }

    private void listEnd() throws IOException {
        this.writer.append(']');
    }

    private void key(String key) throws IOException {
        if (this.objKeyCounter++ > 0) {
            this.writer.append(", ");
        }
        this.writer.append('\"').append(key).append("\":");
    }

    private void val(long count) throws IOException {
        this.writer.append(Long.toString(count));
    }

    private void val(String val) throws IOException {
        this.writer.append('\"').append(val).append('\"');
    }

    private void metricStart(MetaMetric metric) throws IOException {
        if (this.listCounter++ > 0) {
            this.writer.append(',').append(this.newLine);
        }
        this.objStart();
        this.key("name");
        this.val(metric.name());
    }

    private void metricEnd() throws IOException {
        this.objEnd();
    }

    private void logCount(MetaCountMetric metric) throws IOException {
        this.metricStart(metric);
        this.key("count");
        this.val(metric.count());
        this.metricEnd();
    }

    private void logTimed(MetaTimedMetric metric) throws IOException {
        this.metricStart(metric);
        this.appendTiming(metric);
        if (this.isIncludeDetail(metric)) {
            this.append("loc", metric.location());
        }
        this.metricEnd();
    }

    private void logQuery(MetaQueryMetric metric) throws IOException {
        this.metricStart(metric);
        this.appendTiming(metric);
        if (this.withHash) {
            this.append("hash", metric.hash());
        }
        if (this.isIncludeDetail(metric)) {
            this.append("loc", metric.location());
            this.append("sql", MetricsAsJson.escape(metric.sql()));
        }
        this.metricEnd();
    }

    static String escape(String sql) {
        return sql == null ? null : sql.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private boolean isIncludeDetail(MetaTimedMetric metric) {
        return this.includeExtraAttributes == 2 || this.includeExtraAttributes == 1 && metric.initialCollection();
    }

    private void append(String key, String val) throws IOException {
        if (val != null) {
            this.key(key);
            this.val(val);
        }
    }

    private void appendTiming(MetaTimedMetric timedMetric) throws IOException {
        this.append("count", timedMetric.count());
        this.append("total", timedMetric.total());
        this.append("mean", timedMetric.mean());
        this.append("max", timedMetric.max());
    }

    private void append(String key, long value) throws IOException {
        this.key(key);
        this.val(value);
    }
}

