/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.cache;

import io.ebean.config.CurrentTenantProvider;
import java.io.Serializable;
import java.util.Objects;

public class TenantAwareKey {
    private final CurrentTenantProvider tenantProvider;

    public TenantAwareKey(CurrentTenantProvider tenantProvider) {
        this.tenantProvider = tenantProvider;
    }

    public Object key(Object key) {
        if (this.tenantProvider != null) {
            return new CacheKey(key, this.tenantProvider.currentId());
        }
        return key;
    }

    public static final class CacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Object key;
        final Object tenantId;

        public CacheKey(Object key, Object tenantId) {
            this.key = key;
            this.tenantId = tenantId;
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 92821 * result + Objects.hashCode(this.tenantId);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CacheKey) {
                CacheKey that = (CacheKey)obj;
                return Objects.equals(that.key, this.key) && Objects.equals(that.tenantId, this.tenantId);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.key.toString());
            if (this.tenantId != null) {
                sb.append(':').append(this.tenantId);
            }
            return sb.toString();
        }
    }
}

