/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.Configuration;
import io.avaje.config.CoreConfiguration;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;

final class CoreSetValue
implements Configuration.SetValue {
    private final CoreConfiguration config;

    CoreSetValue(CoreConfiguration config) {
        this.config = config;
    }

    @Override
    public Set<String> of(String key) {
        String val = this.config.value(key);
        return val == null ? Collections.emptySet() : this.split(val);
    }

    @Override
    public Set<String> of(String key, String ... defaultValues) {
        String val = this.config.value(key);
        return val == null ? CoreSetValue.stringDefaults(defaultValues) : this.split(val);
    }

    private static Set<String> stringDefaults(String[] defaultValues) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        Collections.addAll(values, defaultValues);
        return values;
    }

    @Override
    public Set<Integer> ofInt(String key) {
        return this.splitInt(this.config.value(key));
    }

    @Override
    public Set<Integer> ofInt(String key, int ... defaultValues) {
        String val = this.config.value(key);
        return val == null ? CoreSetValue.intDefaults(defaultValues) : this.splitInt(val);
    }

    private static Set<Integer> intDefaults(int[] defaultValues) {
        LinkedHashSet<Integer> ints = new LinkedHashSet<Integer>();
        for (int defaultVal : defaultValues) {
            ints.add(defaultVal);
        }
        return ints;
    }

    @Override
    public Set<Long> ofLong(String key) {
        return this.splitLong(this.config.value(key));
    }

    @Override
    public Set<Long> ofLong(String key, long ... defaultValues) {
        String val = this.config.value(key);
        return val == null ? CoreSetValue.longDefaults(defaultValues) : this.splitLong(val);
    }

    private static Set<Long> longDefaults(long[] defaultValues) {
        LinkedHashSet<Long> ints = new LinkedHashSet<Long>();
        for (long defaultVal : defaultValues) {
            ints.add(defaultVal);
        }
        return ints;
    }

    @Override
    public <T> Set<T> ofType(String key, Function<String, T> function) {
        String val = this.config.value(key);
        try {
            return this.splitAs(val, function);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to convert key: " + key + " with the provided function", e);
        }
    }

    Set<String> split(String allValues) {
        return CoreSetValue.stringDefaults(allValues.split(","));
    }

    Set<Integer> splitInt(String allValues) {
        return this.splitAs(allValues, Integer::parseInt);
    }

    Set<Long> splitLong(String allValues) {
        return this.splitAs(allValues, Long::parseLong);
    }

    <T> Set<T> splitAs(String allValues, Function<String, T> function) {
        if (allValues == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (String value : allValues.split(",")) {
            set.add(function.apply(value));
        }
        return set;
    }
}

