/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.ConfigParser;
import io.avaje.config.ConfigServiceLoader;
import io.avaje.config.Configuration;
import io.avaje.config.ConfigurationLog;
import io.avaje.config.CoreComponents;
import io.avaje.config.CoreConfiguration;
import io.avaje.config.CoreEntry;
import io.avaje.config.CoreExpressionEval;
import io.avaje.config.InitialLoader;
import io.avaje.config.ModificationEventRunner;
import io.avaje.config.Parsers;
import io.avaje.config.ResourceLoader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class CoreConfigurationBuilder
implements Configuration.Builder {
    private final CoreEntry.CoreMap sourceMap = CoreEntry.newMap();
    private final ConfigServiceLoader serviceLoader = ConfigServiceLoader.get();
    private final Parsers parsers = this.serviceLoader.parsers();
    private ConfigurationLog log = this.serviceLoader.log();
    private ResourceLoader resourceLoader = this.serviceLoader.resourceLoader();
    private ModificationEventRunner eventRunner = this.serviceLoader.eventRunner();
    private boolean includeResourceLoading;
    private InitialLoader initialLoader;

    CoreConfigurationBuilder() {
    }

    @Override
    public Configuration.Builder eventRunner(ModificationEventRunner eventRunner) {
        this.eventRunner = Objects.requireNonNull(eventRunner);
        return this;
    }

    @Override
    public Configuration.Builder log(ConfigurationLog log) {
        this.log = Objects.requireNonNull(log);
        return this;
    }

    @Override
    public Configuration.Builder resourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = Objects.requireNonNull(resourceLoader);
        return this;
    }

    @Override
    public Configuration.Builder put(String key, String value) {
        this.sourceMap.put(Objects.requireNonNull(key), Objects.requireNonNull(value), "initial");
        return this;
    }

    @Override
    public Configuration.Builder putAll(Map<String, ?> source) {
        Objects.requireNonNull(source);
        source.forEach((key, value) -> {
            if (key != null && value != null) {
                this.sourceMap.put((String)key, value.toString(), "initial");
            }
        });
        return this;
    }

    @Override
    public Configuration.Builder putAll(Properties source) {
        Objects.requireNonNull(source);
        source.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key != null && value != null) {
                this.sourceMap.put(key.toString(), value.toString(), "initial");
            }
        }));
        return this;
    }

    @Override
    public Configuration.Builder load(String resource) {
        CoreConfigurationBuilder coreConfigurationBuilder;
        block10: {
            ConfigParser configParser = this.parser(resource);
            InputStream inputStream = this.resourceLoader.getResourceAsStream(resource);
            try {
                if (inputStream == null) {
                    this.log.log(System.Logger.Level.INFO, "Configuration resource:{0} not found", resource);
                } else {
                    String source = "resource:" + resource;
                    configParser.load(inputStream).forEach((k, v) -> this.sourceMap.put((String)k, (String)v, source));
                    this.log.log(System.Logger.Level.DEBUG, "loaded {0}", source);
                }
                coreConfigurationBuilder = this;
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            inputStream.close();
        }
        return coreConfigurationBuilder;
    }

    @Override
    public Configuration.Builder load(File file) {
        CoreConfigurationBuilder coreConfigurationBuilder;
        if (!file.exists()) {
            this.log.log(System.Logger.Level.INFO, "Configuration file:{0} not found", file);
            return this;
        }
        ConfigParser configParser = this.parser(file.getName());
        FileReader reader = new FileReader(file);
        try {
            String source = "file:" + file.getName();
            configParser.load(reader).forEach((k, v) -> this.sourceMap.put((String)k, (String)v, source));
            this.log.log(System.Logger.Level.DEBUG, "loaded {0}", source);
            coreConfigurationBuilder = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        reader.close();
        return coreConfigurationBuilder;
    }

    private ConfigParser parser(String name) {
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            throw new IllegalArgumentException("Unable to determine the extension for " + name);
        }
        String extension = name.substring(pos + 1);
        ConfigParser configParser = this.parsers.get(extension);
        if (configParser == null) {
            throw new IllegalArgumentException("No parser registered for extension " + extension);
        }
        return configParser;
    }

    @Override
    public Configuration.Builder includeResourceLoading() {
        this.includeResourceLoading = true;
        return this;
    }

    @Override
    public Configuration build() {
        CoreComponents components = new CoreComponents(this.eventRunner, this.log, this.parsers, this.serviceLoader.sources(), this.serviceLoader.plugins());
        if (this.includeResourceLoading) {
            this.log.preInitialisation();
            this.initialLoader = new InitialLoader(components, this.resourceLoader);
        }
        return new CoreConfiguration(components, this.initEntries()).postLoad(this.initialLoader);
    }

    private CoreEntry.CoreMap initEntries() {
        CoreEntry.CoreMap entries = this.initEntryMap();
        entries.addAll(this.sourceMap);
        return CoreExpressionEval.evalFor(entries);
    }

    private CoreEntry.CoreMap initEntryMap() {
        return this.initialLoader == null ? CoreEntry.newMap() : this.initialLoader.load();
    }
}

