/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cells;

import com.aspose.cells.a.a.y5y;
import com.aspose.cells.a.c.h85;
import com.aspose.cells.a.c.r_w;
import com.aspose.cells.b.a.f.k9c;
import com.aspose.cells.b.a.f.p5b;
import com.aspose.cells.b.a.f.x72;
import com.aspose.cells.j0s;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class Encoding {
    private int b;
    private String c;
    private String d;
    private Charset e = null;
    private ThreadLocal<CharsetDecoder> f = new j0s(this);
    private CharsetEncoder g = null;

    public static Encoding getASCII() {
        return new Encoding(20127, "US-ASCII", "us-ascii");
    }

    public static Encoding getUTF7() {
        return new Encoding(65000, "UTF-7", "utf-7");
    }

    public static Encoding getUTF8() {
        return new k9c(true);
    }

    public static Encoding getUTF8NoBOM() {
        return new k9c(false);
    }

    public static Encoding getUnicode() {
        return new Encoding(1200, "UTF-16LE", "utf-16");
    }

    public static Encoding getBigEndianUnicode() {
        return new Encoding(1201, "UTF-16BE", "unicodeFFFE");
    }

    protected Encoding(int codePage, String charsetName, String headerName) {
        this.b = codePage;
        this.c = charsetName;
        this.d = headerName;
    }

    public static Encoding a(boolean bl, boolean bl2) {
        if (bl) {
            return Encoding.getBigEndianUnicode();
        }
        return Encoding.getUnicode();
    }

    public static Encoding getDefault() {
        return Encoding.getEncoding(Charset.defaultCharset().name());
    }

    public static Encoding b(boolean bl, boolean bl2) {
        throw new UnsupportedOperationException("UTF32 Encoding not supported in java version.");
    }

    public static Encoding getEncoding(int codePage) {
        for (x72 x722 : x72.a()) {
            if (x722.T != codePage) continue;
            return new Encoding(codePage, x722.U, x722.V);
        }
        return Encoding.getUTF8();
    }

    public static Encoding getEncoding(String charsetName) {
        Charset charset;
        r_w.b(charsetName, "charsetName");
        for (x72 x722 : x72.a()) {
            if (!charsetName.equalsIgnoreCase(x722.U)) continue;
            return new Encoding(x722.T, x722.U, x722.V);
        }
        Object var1_2 = null;
        try {
            charset = Charset.forName(charsetName);
        }
        catch (Exception exception) {
            if (y5y.a()) {
                y5y.a("GetEncoding(" + charsetName + ")-" + y5y.a(exception));
            }
            return Encoding.getUTF8();
        }
        Encoding encoding = new Encoding(0, charsetName, charsetName.toLowerCase());
        encoding.e = charset;
        return encoding;
    }

    public static Encoding getEncoding(Charset charset) {
        String string = charset.displayName();
        for (x72 x722 : x72.a()) {
            if (!string.equalsIgnoreCase(x722.U)) continue;
            return new Encoding(x722.T, x722.U, x722.V);
        }
        Encoding encoding = new Encoding(0, string, string.toLowerCase());
        encoding.e = charset;
        return encoding;
    }

    public String a() {
        return this.d;
    }

    public String b() {
        return this.c;
    }

    public com.aspose.cells.b.a.f.h85 c() {
        return new com.aspose.cells.b.a.f.h85(this.h());
    }

    CharsetDecoder d() {
        return this.f.get();
    }

    public p5b e() throws Exception {
        return new p5b(this.h());
    }

    CharsetEncoder f() throws Exception {
        if (this.g == null) {
            this.g = this.h().newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return this.g;
    }

    public int a(int n) throws Exception {
        return (int)((float)n * this.f().maxBytesPerChar());
    }

    public byte[] g() {
        switch (this.b) {
            case 65001: {
                return new byte[]{-17, -69, -65};
            }
            case 1200: {
                return new byte[]{-1, -2};
            }
            case 1201: {
                return new byte[]{-2, -1};
            }
        }
        return new byte[0];
    }

    public int a(String string, int n, int n2, byte[] byArray, int n3) {
        ByteBuffer byteBuffer = this.h().encode(CharBuffer.wrap(string, n, n + n2));
        int n4 = byteBuffer.remaining();
        byteBuffer.get(byArray, n3, n4);
        return n4;
    }

    public int a(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        ByteBuffer byteBuffer = this.h().encode(charBuffer);
        int n4 = byteBuffer.remaining();
        byteBuffer.get(byArray, n3, n4);
        return n4;
    }

    public byte[] a(String string) {
        ByteBuffer byteBuffer = this.h().encode(string);
        return this.a(byteBuffer);
    }

    public byte[] a(char[] cArray) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = this.h().encode(charBuffer);
        return this.a(byteBuffer);
    }

    public byte[] a(char[] cArray, int n, int n2) {
        CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
        ByteBuffer byteBuffer = this.h().encode(charBuffer);
        return this.a(byteBuffer);
    }

    public int b(String string) {
        byte[] byArray = this.a(string);
        if (byArray != null) {
            return byArray.length;
        }
        return 0;
    }

    private byte[] a(ByteBuffer byteBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.remaining();
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public String a(byte[] byArray, int n, int n2) {
        h85.a(byArray, n, n2);
        if (n2 == 0) {
            return "";
        }
        try {
            CharBuffer charBuffer = this.d().decode(ByteBuffer.wrap(byArray, n, n2));
            return charBuffer.toString();
        }
        catch (Exception exception) {
            this.a(exception);
            return "";
        }
    }

    private void a(Exception exception) {
        throw new IllegalStateException("Invalid encoding: " + exception.getMessage(), exception);
    }

    public String a(byte[] byArray) {
        try {
            CharBuffer charBuffer = this.d().decode(ByteBuffer.wrap(byArray));
            return charBuffer.toString();
        }
        catch (Exception exception) {
            this.a(exception);
            return "";
        }
    }

    public Charset h() {
        if (this.e != null) {
            return this.e;
        }
        try {
            this.e = Charset.forName(this.c);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(illegalArgumentException);
        }
        return this.e;
    }

    public boolean equals(Object o) {
        return o instanceof Encoding && this.equals((Encoding)o);
    }

    public boolean equals(Encoding other) {
        return this.c.equalsIgnoreCase(other.c);
    }

    public int i() {
        return this.b;
    }
}

