/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.RenderTargetsKt;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.swing.SoftwareSwingPainter;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingPainter;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\rH\u0014J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\t\u0010\u001f\u001a\u00020\rH\u0082 J\u0011\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\rH\u0082 J)\u0010\"\u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0082 J\u0011\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\rH\u0082 J\u0019\u0010&\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH\u0082 J\u0011\u0010'\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\rH\u0082 J\u0019\u0010(\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0082 J\u0011\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\rH\u0082 J\u0011\u0010+\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\rH\u0082 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/skiko/swing/LinuxOpenGLSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "<init>", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "painter", "Lorg/jetbrains/skiko/swing/SwingPainter;", "offScreenContextPtr", "", "offScreenBufferPtr", "storage", "Lorg/jetbrains/skia/Bitmap;", "bytesToDraw", "", "dispose", "", "onRender", "g", "Ljava/awt/Graphics2D;", "width", "", "height", "nanoTime", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "makeOffScreenContext", "disposeOffScreenContext", "contextPtr", "makeOffScreenBuffer", "oldBufferPtr", "disposeOffScreenBuffer", "bufferPtr", "startRendering", "finishRendering", "createAndBindTexture", "getFboId", "texturePtr", "unbindAndDisposeTexture", "skiko"})
public final class LinuxOpenGLSwingRedrawer
extends SwingRedrawerBase {
    @NotNull
    private final SkikoRenderDelegate renderDelegate;
    @NotNull
    private final SwingPainter painter;
    private final long offScreenContextPtr;
    private long offScreenBufferPtr;
    @NotNull
    private final Bitmap storage;
    @NotNull
    private byte[] bytesToDraw;

    /*
     * WARNING - void declaration
     */
    public LinuxOpenGLSwingRedrawer(@NotNull SwingLayerProperties swingLayerProperties2, @NotNull SkikoRenderDelegate renderDelegate, @NotNull SkiaLayerAnalytics analytics) {
        void it;
        long l;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        Intrinsics.checkNotNullParameter((Object)renderDelegate, (String)"renderDelegate");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        super(swingLayerProperties2, analytics, GraphicsApi.OPENGL);
        this.renderDelegate = renderDelegate;
        this.onDeviceChosen("OpenGL OffScreen");
        this.painter = new SoftwareSwingPainter(swingLayerProperties2);
        long l2 = l = this.makeOffScreenContext();
        LinuxOpenGLSwingRedrawer linuxOpenGLSwingRedrawer = this;
        boolean bl = false;
        if (it == 0L) {
            throw new RenderException("Cannot create OpenGL context", null, 2, null);
        }
        linuxOpenGLSwingRedrawer.offScreenContextPtr = l;
        this.storage = new Bitmap();
        this.bytesToDraw = new byte[0];
        this.onContextInit(null);
    }

    @Override
    public void dispose() {
        this.bytesToDraw = new byte[0];
        this.storage.close();
        this.disposeOffScreenBuffer(this.offScreenBufferPtr);
        this.disposeOffScreenContext(this.offScreenContextPtr);
        this.painter.dispose();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRender(@NotNull Graphics2D g, int width, int height, long nanoTime) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.offScreenBufferPtr = this.makeOffScreenBuffer(this.offScreenContextPtr, this.offScreenBufferPtr, width, height);
        if (this.offScreenBufferPtr == 0L) {
            throw new RenderException("Cannot create offScreen OpenGL buffer", null, 2, null);
        }
        this.startRendering(this.offScreenContextPtr, this.offScreenBufferPtr);
        try {
            ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)arg_0 -> LinuxOpenGLSwingRedrawer.onRender$lambda$1(this, width, height, nanoTime, g, arg_0)));
        }
        finally {
            this.finishRendering(this.offScreenContextPtr);
        }
    }

    private final void flush(Surface surface, Graphics2D g) {
        surface.flushAndSubmit(true);
        this.painter.paint(g, surface, 0L);
    }

    private final native long makeOffScreenContext();

    private final native long disposeOffScreenContext(long var1);

    private final native long makeOffScreenBuffer(long var1, long var3, int var5, int var6);

    private final native void disposeOffScreenBuffer(long var1);

    private final native void startRendering(long var1, long var3);

    private final native void finishRendering(long var1);

    private final native long createAndBindTexture(int var1, int var2);

    private final native int getFboId(long var1);

    private final native void unbindAndDisposeTexture(long var1);

    private static final Unit onRender$lambda$1(LinuxOpenGLSwingRedrawer this$0, int $width, int $height, long $nanoTime, Graphics2D $g, CloseScope $this$autoCloseScope) {
        Surface surface;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$g, (String)"$g");
        Intrinsics.checkNotNullParameter((Object)$this$autoCloseScope, (String)"$this$autoCloseScope");
        long texturePtr = this$0.createAndBindTexture($width, $height);
        if (texturePtr == 0L) {
            throw new RenderException("Cannot create offScreen OpenGL texture", null, 2, null);
        }
        int fbId = this$0.getFboId(texturePtr);
        BackendRenderTarget renderTarget = (BackendRenderTarget)$this$autoCloseScope.autoClose((AutoCloseable)RenderTargetsKt.makeGLRenderTarget($width, $height, 0, 8, fbId, 32856));
        DirectContext directContext = (DirectContext)$this$autoCloseScope.autoClose((AutoCloseable)SwingRedrawerBase.configureContext$default(this$0, RenderTargetsKt.makeGLContext(), 0L, 1, null));
        Surface surface2 = Surface.Companion.makeFromBackendRenderTarget(directContext, renderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
        if (surface2 == null || (surface = (Surface)$this$autoCloseScope.autoClose((AutoCloseable)surface2)) == null) {
            throw new RenderException("Cannot create surface", null, 2, null);
        }
        Surface surface3 = surface;
        Canvas canvas = surface3.getCanvas();
        canvas.clear(0);
        this$0.renderDelegate.onRender(canvas, $width, $height, $nanoTime);
        this$0.flush(surface3, $g);
        this$0.unbindAndDisposeTexture(texturePtr);
        return Unit.INSTANCE;
    }
}

