/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.LibraryLoadException;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0016\u001a\u00020\u0007J\u001c\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/skiko/LibraryLoader;", "", "name", "", "additionalFile", "init", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "loadLibraryOrCopy", "Ljava/io/File;", "library", "unpackIfNeeded", "dest", "resourceName", "deleteOnExit", "", "loadingLock", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/locks/ReentrantLock;", "kotlin.jvm.PlatformType", "loadOnce", "findAndLoadLibrary", "skiko"})
@SourceDebugExtension(value={"SMAP\nLibraryLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LibraryLoader.kt\norg/jetbrains/skiko/LibraryLoader\n+ 2 LibraryLoader.kt\norg/jetbrains/skiko/LibraryLoaderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n175#2,6:184\n1#3:190\n*S KotlinDebug\n*F\n+ 1 LibraryLoader.kt\norg/jetbrains/skiko/LibraryLoader\n*L\n56#1:184,6\n*E\n"})
public final class LibraryLoader {
    @NotNull
    private final String name;
    @Nullable
    private final String additionalFile;
    @NotNull
    private final Function0<Unit> init;
    @NotNull
    private final AtomicReference<ReentrantLock> loadingLock;

    public LibraryLoader(@NotNull String name, @Nullable String additionalFile, @NotNull Function0<Unit> init2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        this.name = name;
        this.additionalFile = additionalFile;
        this.init = init2;
        this.loadingLock = new AtomicReference<ReentrantLock>(new ReentrantLock());
    }

    public /* synthetic */ LibraryLoader(String string, String string2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            function0 = LibraryLoader::_init_$lambda$0;
        }
        this(string, string2, (Function0<Unit>)function0);
    }

    private final File loadLibraryOrCopy(File library) {
        try {
            System.load(library.getAbsolutePath());
            return null;
        }
        catch (UnsatisfiedLinkError e) {
            String string = e.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"already loaded in another classloader", (boolean)false, (int)2, null) : false;
            if (bl) {
                File copyDir = Files.createTempDirectory("skiko", new FileAttribute[0]).toFile();
                Intrinsics.checkNotNull((Object)copyDir);
                String string2 = library.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                File tempFile = FilesKt.resolve((File)copyDir, (String)string2);
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(library.toPath(), tempFile.toPath(), copyOptionArray);
                tempFile.deleteOnExit();
                System.load(tempFile.getAbsolutePath());
                return copyDir;
            }
            throw new LibraryLoadException("Failed to loade library " + library, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File unpackIfNeeded(File dest, String resourceName, boolean deleteOnExit) {
        File file = new File(dest, resourceName);
        if (!file.exists()) {
            Path path = FilesKt.resolve((File)dest, (String)".lock").toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Path path$iv = path;
            boolean $i$f$withFileLock = false;
            PathsKt.createParentDirectories((Path)path$iv, (FileAttribute[])new FileAttribute[0]);
            Object object = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
            object = FileChannel.open(path$iv, object);
            Throwable throwable = null;
            try {
                Path path2;
                FileChannel channel$iv = (FileChannel)object;
                boolean bl = false;
                FileLock lock$iv = channel$iv.lock();
                AutoCloseable autoCloseable = lock$iv;
                Throwable throwable2 = null;
                try {
                    FileLock it$iv = (FileLock)autoCloseable;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (file.exists()) {
                        File file2 = file;
                        File file3 = file2;
                        return file3;
                    }
                    File tempFile = File.createTempFile("skiko", "", dest);
                    if (deleteOnExit) {
                        file.deleteOnExit();
                    }
                    CopyOption[] copyOptionArray = (CopyOption[])Library.class.getResourceAsStream('/' + resourceName);
                    Throwable throwable3 = null;
                    try {
                        InputStream input = (InputStream)copyOptionArray;
                        boolean bl4 = false;
                        CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        long l = Files.copy(input, tempFile.toPath(), copyOptionArray2);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)copyOptionArray, (Throwable)throwable3);
                    }
                    copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
                    path2 = Files.move(tempFile.toPath(), file.toPath(), copyOptionArray);
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
                }
                Path path3 = path2;
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadOnce() {
        ReentrantLock reentrantLock = this.loadingLock.get();
        if (reentrantLock == null) {
            return;
        }
        ReentrantLock lock = reentrantLock;
        if (lock.isHeldByCurrentThread()) {
            return;
        }
        Lock lock2 = lock;
        lock2.lock();
        try {
            boolean bl = false;
            if (this.loadingLock.get() != lock) {
                return;
            }
            try {
                this.findAndLoadLibrary(this.name, this.additionalFile);
                this.init.invoke();
            }
            finally {
                this.loadingLock.compareAndSet(lock, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void findAndLoadLibrary(String name, String additionalFile) {
        String platformName = System.mapLibraryName(name);
        if (OsArch_jvmKt.getHostOs() == OS.Android) {
            System.loadLibrary(name);
            return;
        }
        String skikoLibraryPath = SkikoProperties.INSTANCE.getLibraryPath();
        if (skikoLibraryPath != null) {
            File library = new File(new File(skikoLibraryPath), platformName);
            File copyDir = this.loadLibraryOrCopy(library);
            if (additionalFile != null && copyDir != null) {
                this.unpackIfNeeded(copyDir, additionalFile, true);
            }
            return;
        }
        File jvmFiles = new File(System.getProperty("java.home"), OsArch_jvmKt.getHostOs().isWindows() ? "bin" : "lib");
        Intrinsics.checkNotNull((Object)platformName);
        File pathInJvm = FilesKt.resolve((File)jvmFiles, (String)platformName);
        if (pathInJvm.exists()) {
            boolean bl;
            String string = additionalFile;
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = !FilesKt.resolve((File)jvmFiles, (String)it).exists();
            } else {
                bl = false;
            }
            if (!bl) {
                this.loadLibraryOrCopy(pathInJvm);
                return;
            }
        }
        InputStream inputStream = Library.class.getResourceAsStream('/' + platformName + ".sha256");
        if (inputStream == null) {
            throw new LibraryLoadException("Cannot find " + platformName + ".sha256, proper native dependency missing.", null, 2, null);
        }
        InputStream hashResourceStream = inputStream;
        Closeable bl2 = hashResourceStream;
        Throwable throwable = null;
        try {
            Object it = (InputStream)bl2;
            boolean bl = false;
            InputStream inputStream2 = it;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            it = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)bl2, (Throwable)throwable);
        }
        Object hash = it;
        File dataDir = new File(new File(SkikoProperties.INSTANCE.getDataPath()), (String)hash);
        dataDir.mkdirs();
        File library = this.unpackIfNeeded(dataDir, platformName, false);
        File copyDir = this.loadLibraryOrCopy(library);
        if (additionalFile != null) {
            File file = copyDir != null ? this.unpackIfNeeded(copyDir, additionalFile, true) : this.unpackIfNeeded(dataDir, additionalFile, false);
        }
    }

    static /* synthetic */ void findAndLoadLibrary$default(LibraryLoader libraryLoader, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        libraryLoader.findAndLoadLibrary(string, string2);
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }
}

