/*
 * Decompiled with CFR 0.152.
 */
package korlibs.bignumber;

import java.math.BigInteger;
import korlibs.bignumber.BigInt;
import korlibs.bignumber.BigIntConstructor;
import korlibs.bignumber.BigIntDivisionByZeroException;
import korlibs.bignumber.BigIntInvalidFormatException;
import korlibs.bignumber.BigIntJvmKt;
import korlibs.bignumber.BigIntNegativeExponentException;
import korlibs.bignumber.ranges.BigIntRange;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0014\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nB\r\u0012\u0006\u0010\u0003\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0018\u001a\u00020\u0001H\u0016J\u0011\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0004J\u0011\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0096\u0001J\u0011\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0006H\u0096\u0001J\u0011\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\bH\u0096\u0001J\u0019\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0096\u0001J\u0011\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0002J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\u0004H\u0016J\b\u0010\"\u001a\u00020\u0001H\u0016J\u0011\u0010#\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010$\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0004J\u0011\u0010%\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u0001H\u0096\u0004J\u0011\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u0004H\u0096\u0004J\u0011\u0010(\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u0004H\u0096\u0004J\u0011\u0010+\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u0004H\u0096\u0004J\b\u0010,\u001a\u00020\u0001H\u0016J\u0011\u0010-\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0002J\b\u0010.\u001a\u00020\u0004H\u0016J\b\u0010/\u001a\u00020\bH\u0016J\u0010\u0010/\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0016J\t\u00100\u001a\u00020\u0001H\u0096\u0002J\t\u00101\u001a\u00020\u0001H\u0096\u0002J\u0011\u00102\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0096\u0004R\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0003\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0012\u001a\u00020\u000b*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0012\u001a\n \u0015*\u0004\u0018\u00010\u000b0\u000b*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0016R\u001d\u0010\u0012\u001a\n \u0015*\u0004\u0018\u00010\u000b0\u000b*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0017\u00a8\u00064"}, d2={"Lkorlibs/bignumber/JvmBigInt;", "Lkorlibs/bignumber/BigInt;", "Lkorlibs/bignumber/BigIntConstructor;", "value", "", "(I)V", "", "(J)V", "", "radix", "(Ljava/lang/String;I)V", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "signum", "getSignum", "()I", "getValue", "()Ljava/math/BigInteger;", "jvm", "getJvm", "(Lkorlibs/bignumber/BigInt;)Ljava/math/BigInteger;", "kotlin.jvm.PlatformType", "(I)Ljava/math/BigInteger;", "(J)Ljava/math/BigInteger;", "abs", "and", "other", "compareTo", "create", "div", "equals", "", "", "hashCode", "inv", "minus", "or", "plus", "pow", "exponent", "rem", "shl", "count", "shr", "square", "times", "toInt", "toString", "unaryMinus", "unaryPlus", "xor", "Companion", "kbignum"})
public final class JvmBigInt
implements BigInt,
BigIntConstructor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger value;
    private final /* synthetic */ Companion $$delegate_0;

    public JvmBigInt(@NotNull BigInteger value) {
        this.value = value;
        this.$$delegate_0 = Companion;
    }

    @NotNull
    public final BigInteger getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public BigInt create(int value) {
        return this.$$delegate_0.create(value);
    }

    @Override
    @NotNull
    public BigInt create(long value) {
        return this.$$delegate_0.create(value);
    }

    @Override
    @NotNull
    public BigInt create(@NotNull String value) {
        return this.$$delegate_0.create(value);
    }

    @Override
    @NotNull
    public BigInt create(@NotNull String value, int radix) {
        return this.$$delegate_0.create(value, radix);
    }

    public JvmBigInt(int value) {
        BigInteger bigInteger = BigInteger.valueOf(value);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(bigInteger);
    }

    public JvmBigInt(long value) {
        BigInteger bigInteger = BigInteger.valueOf(value);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(bigInteger);
    }

    /*
     * WARNING - void declaration
     */
    public JvmBigInt(@NotNull String value, int radix) {
        BigInteger bigInteger;
        JvmBigInt jvmBigInt;
        JvmBigInt jvmBigInt2 = this;
        try {
            jvmBigInt = jvmBigInt2;
            bigInteger = new BigInteger(value, radix);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            JvmBigInt jvmBigInt3 = jvmBigInt2;
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            throw new BigIntInvalidFormatException(string);
        }
        jvmBigInt(bigInteger);
    }

    @NotNull
    public final BigInteger getJvm(@NotNull BigInt $this$jvm) {
        Intrinsics.checkNotNull((Object)$this$jvm, (String)"null cannot be cast to non-null type korlibs.bignumber.JvmBigInt");
        return ((JvmBigInt)$this$jvm).value;
    }

    public final BigInteger getJvm(int $this$jvm) {
        return BigInteger.valueOf($this$jvm);
    }

    public final BigInteger getJvm(long $this$jvm) {
        return BigInteger.valueOf($this$jvm);
    }

    @Override
    public int getSignum() {
        return this.value.signum();
    }

    @Override
    @NotNull
    public BigInt unaryPlus() {
        return this;
    }

    @Override
    @NotNull
    public BigInt unaryMinus() {
        BigInteger bigInteger = this.value.negate();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.negate()");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt inv() {
        BigInteger bigInteger = this.value.not();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.not()");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt abs() {
        BigInteger bigInteger = this.value.abs();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"abs(...)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt square() {
        BigInteger bigInteger = this.value.multiply(this.value);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt pow(@NotNull BigInt exponent) {
        return this.pow(exponent.toInt());
    }

    @Override
    @NotNull
    public BigInt pow(int exponent) {
        if (exponent < 0) {
            throw new BigIntNegativeExponentException();
        }
        BigInteger bigInteger = this.value.pow(exponent);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"pow(...)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt and(@NotNull BigInt other) {
        BigInteger bigInteger = this.value.and(this.getJvm(other));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"and(...)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt or(@NotNull BigInt other) {
        BigInteger bigInteger = this.value.or(this.getJvm(other));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"or(...)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt xor(@NotNull BigInt other) {
        BigInteger bigInteger = this.value.xor(this.getJvm(other));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"xor(...)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt shl(int count) {
        BigInteger bigInteger = this.value.shiftLeft(count);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.shiftLeft(n)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt shr(int count) {
        BigInteger bigInteger = this.value.shiftRight(count);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.shiftRight(n)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt plus(@NotNull BigInt other) {
        BigInteger bigInteger = this.value.add(this.getJvm(other));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.add(other)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt minus(@NotNull BigInt other) {
        BigInteger bigInteger = this.value.subtract(this.getJvm(other));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.subtract(other)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt times(@NotNull BigInt other) {
        BigInteger bigInteger = this.value.multiply(this.getJvm(other));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt div(@NotNull BigInt other) {
        if (other.isZero()) {
            throw new BigIntDivisionByZeroException();
        }
        BigInteger bigInteger = this.value.divide(this.getJvm(other));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.divide(other)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    @NotNull
    public BigInt rem(@NotNull BigInt other) {
        BigInteger bigInteger = this.value.remainder(this.getJvm(other));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.remainder(other)");
        return BigIntJvmKt.getBi(bigInteger);
    }

    @Override
    public int toInt() {
        return this.value.intValue();
    }

    @Override
    @NotNull
    public String toString(int radix) {
        String string = this.value.toString(radix);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return this.toString(10);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof JvmBigInt ? Intrinsics.areEqual((Object)this.value, (Object)((JvmBigInt)other).value) : false;
    }

    @Override
    public int compareTo(@NotNull BigInt other) {
        return this.value.compareTo(this.getJvm(other));
    }

    @Override
    @NotNull
    public BigInt plus(int other) {
        return BigInt.DefaultImpls.plus(this, other);
    }

    @Override
    @NotNull
    public BigInt minus(int other) {
        return BigInt.DefaultImpls.minus(this, other);
    }

    @Override
    @NotNull
    public BigInt times(int other) {
        return BigInt.DefaultImpls.times((BigInt)this, other);
    }

    @Override
    @NotNull
    public BigInt times(long other) {
        return BigInt.DefaultImpls.times((BigInt)this, other);
    }

    @Override
    @NotNull
    public BigInt div(int other) {
        return BigInt.DefaultImpls.div(this, other);
    }

    @Override
    @NotNull
    public BigInt rem(int other) {
        return BigInt.DefaultImpls.rem(this, other);
    }

    @Override
    public boolean isZero() {
        return BigInt.DefaultImpls.isZero(this);
    }

    @Override
    public boolean isNotZero() {
        return BigInt.DefaultImpls.isNotZero(this);
    }

    @Override
    public boolean isNegative() {
        return BigInt.DefaultImpls.isNegative(this);
    }

    @Override
    public boolean isPositive() {
        return BigInt.DefaultImpls.isPositive(this);
    }

    @Override
    public boolean isNegativeOrZero() {
        return BigInt.DefaultImpls.isNegativeOrZero(this);
    }

    @Override
    public boolean isPositiveOrZero() {
        return BigInt.DefaultImpls.isPositiveOrZero(this);
    }

    @Override
    @NotNull
    public BigIntRange rangeTo(@NotNull BigInt that) {
        return BigInt.DefaultImpls.rangeTo(this, that);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lkorlibs/bignumber/JvmBigInt$Companion;", "Lkorlibs/bignumber/BigIntConstructor;", "()V", "create", "Lkorlibs/bignumber/BigInt;", "value", "", "", "radix", "kbignum"})
    public static final class Companion
    implements BigIntConstructor {
        private Companion() {
        }

        @Override
        @NotNull
        public BigInt create(int value) {
            return new JvmBigInt(value);
        }

        @Override
        @NotNull
        public BigInt create(@NotNull String value, int radix) {
            return new JvmBigInt(value, radix);
        }

        @Override
        @NotNull
        public BigInt create(long value) {
            return BigIntConstructor.DefaultImpls.create((BigIntConstructor)this, value);
        }

        @Override
        @NotNull
        public BigInt create(@NotNull String value) {
            return BigIntConstructor.DefaultImpls.create((BigIntConstructor)this, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

