/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable.partial;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.offheapstore.storage.restartable.partial.RestartableMinimalStorageEngine;
import java.nio.ByteBuffer;
import org.ehcache.shadow.org.terracotta.offheapstore.paging.PageSource;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.PointerSize;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.portability.Portability;
import org.ehcache.shadow.org.terracotta.offheapstore.util.Factory;

public class RestartableKeysOnlyStorageEngine<I, K, V>
extends RestartableMinimalStorageEngine<I, K, V> {
    public static <I, K, V> Factory<RestartableKeysOnlyStorageEngine<I, K, V>> createKeysOnlyFactory(final I identifier, final RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, final boolean synchronous, final PointerSize width, final PageSource source, final int pageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim, final float compressThreshold) {
        return new Factory<RestartableKeysOnlyStorageEngine<I, K, V>>(){

            @Override
            public RestartableKeysOnlyStorageEngine<I, K, V> newInstance() {
                return new RestartableKeysOnlyStorageEngine(identifier, transactionSource, synchronous, width, source, pageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
            }
        };
    }

    public static <I, K, V> Factory<RestartableKeysOnlyStorageEngine<I, K, V>> createKeysOnlyFactory(final I identifier, final RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, final boolean synchronous, final PointerSize width, final PageSource source, final int initialPageSize, final int maximalPageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim, final float compressThreshold) {
        return new Factory<RestartableKeysOnlyStorageEngine<I, K, V>>(){

            @Override
            public RestartableKeysOnlyStorageEngine<I, K, V> newInstance() {
                return new RestartableKeysOnlyStorageEngine(identifier, transactionSource, synchronous, width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
            }
        };
    }

    public RestartableKeysOnlyStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, float compressThreshold) {
        super(identifier, transactionSource, synchronous, width, source, pageSize, keyPortability, valuePortability, compressThreshold);
    }

    public RestartableKeysOnlyStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, float compressThreshold) {
        super(identifier, transactionSource, synchronous, width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, compressThreshold);
    }

    public RestartableKeysOnlyStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        super(identifier, transactionSource, synchronous, width, source, pageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
    }

    public RestartableKeysOnlyStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        super(identifier, transactionSource, synchronous, width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
    }

    @Override
    protected Long writePartialEntry(int hash, ByteBuffer binaryKey, ByteBuffer binaryValue) {
        Long result = super.writePartialEntry(hash, binaryKey, binaryValue);
        if (result != null) {
            int keyOffset = this.getKeyOffset(result);
            this.metadataArea.writeInt(result + (long)keyOffset, binaryKey.remaining());
            this.metadataArea.writeBuffer(result + (long)keyOffset + 4L, binaryKey.duplicate());
        }
        return result;
    }

    @Override
    protected int getActualEntrySize(long encoding) {
        int keyOffset = this.getKeyOffset(encoding);
        int keyLength = this.metadataArea.readInt(encoding + (long)keyOffset);
        return super.getActualEntrySize(encoding) + 4 + keyLength;
    }

    @Override
    protected int getRequiredEntrySize(ByteBuffer binaryKey, ByteBuffer binaryValue) {
        return super.getRequiredEntrySize(binaryKey, binaryValue) + 4 + binaryKey.remaining();
    }

    private int getKeyOffset(long result) {
        return super.getActualEntrySize(result);
    }

    @Override
    protected RestartableMinimalStorageEngine.Entry readEntry(long encoding) {
        return new KeyBypassEntry(encoding);
    }

    class KeyBypassEntry
    implements RestartableMinimalStorageEngine.Entry {
        private final long encoding;
        private RestartableMinimalStorageEngine.Entry frsEntry;

        KeyBypassEntry(long encoding) {
            this.encoding = encoding;
        }

        @Override
        public ByteBuffer getKey() {
            int keyOffset = RestartableKeysOnlyStorageEngine.this.getKeyOffset(this.encoding);
            int keyLength = RestartableKeysOnlyStorageEngine.this.metadataArea.readInt(this.encoding + (long)keyOffset);
            return RestartableKeysOnlyStorageEngine.this.metadataArea.readBuffer(this.encoding + (long)keyOffset + 4L, keyLength);
        }

        @Override
        public ByteBuffer getValue() {
            if (this.frsEntry == null) {
                this.frsEntry = RestartableKeysOnlyStorageEngine.super.readEntry(this.encoding);
            }
            return this.frsEntry.getValue();
        }

        @Override
        public void close() {
            if (this.frsEntry != null) {
                this.frsEntry.close();
            }
        }
    }
}

