/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.api.response;

import com.xorrus.trading.ib.tws.api.Date_time_utilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00132\u0016\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u0014H\u0002J\u0011\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0013H\u0086\u0002J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010$\u001a\u00020\u001a2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR'\u0010\u0010\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012j\u0002`\u00140\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00118F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0016\u00a8\u0006)"}, d2={"Lcom/xorrus/trading/ib/tws/api/response/OpeningHours;", "", "twsOpeningHours", "", "twsTimezone", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getTwsOpeningHours", "()Ljava/lang/String;", "getTwsTimezone", "timezone", "Lkotlinx/datetime/TimeZone;", "getTimezone", "()Lkotlinx/datetime/TimeZone;", "timezone$delegate", "Lkotlin/Lazy;", "openingHours", "", "Lkotlin/Pair;", "Lkotlin/time/Instant;", "Lcom/xorrus/trading/ib/tws/api/response/OpeningInterval;", "getOpeningHours", "()Ljava/util/List;", "getInstant", "s", "contains", "", "instant", "interval", "dateTime", "closedDays", "Lkotlinx/datetime/LocalDate;", "getClosedDays", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "tws-api"})
@SourceDebugExtension(value={"SMAP\nOpeningHours.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpeningHours.kt\ncom/xorrus/trading/ib/tws/api/response/OpeningHours\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n774#2:61\n865#2,2:62\n774#2:64\n865#2,2:65\n1563#2:67\n1634#2,2:68\n1636#2:71\n1761#2,3:72\n774#2:75\n865#2,2:76\n1563#2:78\n1634#2,3:79\n1563#2:82\n1634#2,3:83\n1#3:70\n*S KotlinDebug\n*F\n+ 1 OpeningHours.kt\ncom/xorrus/trading/ib/tws/api/response/OpeningHours\n*L\n26#1:61\n26#1:62,2\n27#1:64\n27#1:65,2\n28#1:67\n28#1:68,2\n28#1:71\n51#1:72,3\n56#1:75\n56#1:76,2\n57#1:78\n57#1:79,3\n58#1:82\n58#1:83,3\n*E\n"})
public final class OpeningHours {
    @NotNull
    private final String twsOpeningHours;
    @NotNull
    private final String twsTimezone;
    @NotNull
    private final Lazy timezone$delegate;

    public OpeningHours(@NotNull String twsOpeningHours, @NotNull String twsTimezone) {
        Intrinsics.checkNotNullParameter((Object)twsOpeningHours, (String)"twsOpeningHours");
        Intrinsics.checkNotNullParameter((Object)twsTimezone, (String)"twsTimezone");
        this.twsOpeningHours = twsOpeningHours;
        this.twsTimezone = twsTimezone;
        this.timezone$delegate = LazyKt.lazy(() -> OpeningHours.timezone_delegate$lambda$0(this));
    }

    @NotNull
    public final String getTwsOpeningHours() {
        return this.twsOpeningHours;
    }

    @NotNull
    public final String getTwsTimezone() {
        return this.twsTimezone;
    }

    private final TimeZone getTimezone() {
        Lazy lazy = this.timezone$delegate;
        return (TimeZone)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<Instant, Instant>> getOpeningHours() {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        String[] stringArray = new String[]{";"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)this.twsOpeningHours, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!StringsKt.endsWith$default((String)it, (String)":CLOSED", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Instant to;
            void s;
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char[] cArray = new char[]{'-'};
            List list = StringsKt.split$default((CharSequence)((CharSequence)s), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            String sFrom = (String)list.get(0);
            String sTo = (String)list.get(1);
            Instant from = this.getInstant(sFrom);
            if (!(from.compareTo(to = this.getInstant(sTo)) < 0)) {
                boolean bl3 = false;
                String string = "OpeningHours: from (" + from + ") must be before to (" + to + ")";
                throw new IllegalArgumentException(string.toString());
            }
            collection.add(TuplesKt.to((Object)from, (Object)to));
        }
        return (List)destination$iv$iv;
    }

    private final Instant getInstant(String s) {
        char[] cArray = new char[]{':'};
        List list = StringsKt.split$default((CharSequence)s, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String sDate = (String)list.get(0);
        String sTime = (String)list.get(1);
        LocalDateTime localDateTime = new LocalDateTime(Date_time_utilsKt.fromTwsToLocalDate(sDate), Date_time_utilsKt.fromTwsToLocalTime(sTime));
        return TimeZoneKt.toInstant$default((LocalDateTime)localDateTime, (TimeZone)this.getTimezone(), null, (int)2, null);
    }

    private final boolean contains(Instant instant, Pair<Instant, Instant> interval) {
        Instant instant2 = (Instant)interval.getFirst();
        return ((Comparable)instant).compareTo(interval.getSecond()) <= 0 ? 0 <= ((Comparable)instant).compareTo(instant2) : false;
    }

    public final boolean contains(@NotNull Instant dateTime) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
            Iterable $this$any$iv = this.getOpeningHours();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair interval = (Pair)element$iv;
                    boolean bl2 = false;
                    if (!this.contains(dateTime, (Pair<Instant, Instant>)interval)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<LocalDate> getClosedDays() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        String[] stringArray = new String[]{";"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)this.twsOpeningHours, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it, (String)":CLOSED", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.substringBefore$default((String)it, (String)":", null, (int)2, null));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Date_time_utilsKt.fromTwsToLocalDate(it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String component1() {
        return this.twsOpeningHours;
    }

    @NotNull
    public final String component2() {
        return this.twsTimezone;
    }

    @NotNull
    public final OpeningHours copy(@NotNull String twsOpeningHours, @NotNull String twsTimezone) {
        Intrinsics.checkNotNullParameter((Object)twsOpeningHours, (String)"twsOpeningHours");
        Intrinsics.checkNotNullParameter((Object)twsTimezone, (String)"twsTimezone");
        return new OpeningHours(twsOpeningHours, twsTimezone);
    }

    public static /* synthetic */ OpeningHours copy$default(OpeningHours openingHours, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = openingHours.twsOpeningHours;
        }
        if ((n & 2) != 0) {
            string2 = openingHours.twsTimezone;
        }
        return openingHours.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "OpeningHours(twsOpeningHours=" + this.twsOpeningHours + ", twsTimezone=" + this.twsTimezone + ")";
    }

    public int hashCode() {
        int result = this.twsOpeningHours.hashCode();
        result = result * 31 + this.twsTimezone.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OpeningHours)) {
            return false;
        }
        OpeningHours openingHours = (OpeningHours)other;
        if (!Intrinsics.areEqual((Object)this.twsOpeningHours, (Object)openingHours.twsOpeningHours)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.twsTimezone, (Object)openingHours.twsTimezone);
    }

    private static final TimeZone timezone_delegate$lambda$0(OpeningHours this$0) {
        return TimeZone.Companion.of(this$0.twsTimezone);
    }
}

