/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.api.type;

import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003JC\u0010\u0015\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/xorrus/trading/ib/tws/api/type/FundamentalDataRatios;", "", "highestPrice", "Lcom/xorrus/trading/common/bignum/XBigNum;", "lowestPrice", "marketCapitalization", "map", "", "", "<init>", "(Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Ljava/util/Map;)V", "getHighestPrice", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "getLowestPrice", "getMarketCapitalization", "getMap", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "tws-api"})
public final class FundamentalDataRatios {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final XBigNum highestPrice;
    @Nullable
    private final XBigNum lowestPrice;
    @Nullable
    private final XBigNum marketCapitalization;
    @NotNull
    private final Map<String, String> map;

    public FundamentalDataRatios(@Nullable XBigNum highestPrice, @Nullable XBigNum lowestPrice, @Nullable XBigNum marketCapitalization, @NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.highestPrice = highestPrice;
        this.lowestPrice = lowestPrice;
        this.marketCapitalization = marketCapitalization;
        this.map = map2;
    }

    @Nullable
    public final XBigNum getHighestPrice() {
        return this.highestPrice;
    }

    @Nullable
    public final XBigNum getLowestPrice() {
        return this.lowestPrice;
    }

    @Nullable
    public final XBigNum getMarketCapitalization() {
        return this.marketCapitalization;
    }

    @NotNull
    public final Map<String, String> getMap() {
        return this.map;
    }

    @Nullable
    public final XBigNum component1() {
        return this.highestPrice;
    }

    @Nullable
    public final XBigNum component2() {
        return this.lowestPrice;
    }

    @Nullable
    public final XBigNum component3() {
        return this.marketCapitalization;
    }

    @NotNull
    public final Map<String, String> component4() {
        return this.map;
    }

    @NotNull
    public final FundamentalDataRatios copy(@Nullable XBigNum highestPrice, @Nullable XBigNum lowestPrice, @Nullable XBigNum marketCapitalization, @NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        return new FundamentalDataRatios(highestPrice, lowestPrice, marketCapitalization, map2);
    }

    public static /* synthetic */ FundamentalDataRatios copy$default(FundamentalDataRatios fundamentalDataRatios, XBigNum xBigNum, XBigNum xBigNum2, XBigNum xBigNum3, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            xBigNum = fundamentalDataRatios.highestPrice;
        }
        if ((n & 2) != 0) {
            xBigNum2 = fundamentalDataRatios.lowestPrice;
        }
        if ((n & 4) != 0) {
            xBigNum3 = fundamentalDataRatios.marketCapitalization;
        }
        if ((n & 8) != 0) {
            map2 = fundamentalDataRatios.map;
        }
        return fundamentalDataRatios.copy(xBigNum, xBigNum2, xBigNum3, map2);
    }

    @NotNull
    public String toString() {
        return "FundamentalDataRatios(highestPrice=" + this.highestPrice + ", lowestPrice=" + this.lowestPrice + ", marketCapitalization=" + this.marketCapitalization + ", map=" + this.map + ")";
    }

    public int hashCode() {
        int result = this.highestPrice == null ? 0 : this.highestPrice.hashCode();
        result = result * 31 + (this.lowestPrice == null ? 0 : this.lowestPrice.hashCode());
        result = result * 31 + (this.marketCapitalization == null ? 0 : this.marketCapitalization.hashCode());
        result = result * 31 + ((Object)this.map).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FundamentalDataRatios)) {
            return false;
        }
        FundamentalDataRatios fundamentalDataRatios = (FundamentalDataRatios)other;
        if (!Intrinsics.areEqual((Object)this.highestPrice, (Object)fundamentalDataRatios.highestPrice)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lowestPrice, (Object)fundamentalDataRatios.lowestPrice)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.marketCapitalization, (Object)fundamentalDataRatios.marketCapitalization)) {
            return false;
        }
        return Intrinsics.areEqual(this.map, fundamentalDataRatios.map);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/xorrus/trading/ib/tws/api/type/FundamentalDataRatios$Companion;", "", "<init>", "()V", "parse", "Lcom/xorrus/trading/ib/tws/api/type/FundamentalDataRatios;", "tickValue", "", "tws-api"})
    @SourceDebugExtension(value={"SMAP\nFundamentalDataRatios.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FundamentalDataRatios.kt\ncom/xorrus/trading/ib/tws/api/type/FundamentalDataRatios$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n774#2:38\n865#2,2:39\n1563#2:41\n1634#2,3:42\n1193#2,2:45\n1267#2,4:47\n*S KotlinDebug\n*F\n+ 1 FundamentalDataRatios.kt\ncom/xorrus/trading/ib/tws/api/type/FundamentalDataRatios$Companion\n*L\n18#1:38\n18#1:39,2\n19#1:41\n19#1:42,3\n20#1:45,2\n20#1:47,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FundamentalDataRatios parse(@NotNull String tickValue) {
            void $this$associateTo$iv$iv;
            Object object;
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)tickValue, (String)"tickValue");
            String[] stringArray = new String[]{";"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)tickValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                object = new String[]{"="};
                collection.add(StringsKt.split$default((CharSequence)it, (String[])object, (boolean)false, (int)0, (int)6, null));
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                object = (List)element$iv$iv;
                boolean bl = false;
                String key = (String)object.get(0);
                String value = (String)object.get(1);
                object = TuplesKt.to((Object)key, (Object)value);
                map2.put(object.getFirst(), object.getSecond());
            }
            Map map3 = MapsKt.toMutableMap((Map)destination$iv$iv2);
            String string = (String)map3.remove("NHIG");
            XBigNum highestPrice = string != null ? XbignumKt.toXBigNum((String)string) : null;
            String string2 = (String)map3.remove("NLOW");
            XBigNum lowestPrice = string2 != null ? XbignumKt.toXBigNum((String)string2) : null;
            String string3 = (String)map3.remove("MKTCAP");
            XBigNum marketCapitalization = string3 != null ? XbignumKt.toXBigNum((String)string3) : null;
            return new FundamentalDataRatios(highestPrice, lowestPrice, marketCapitalization, map3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

