/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.api.type;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.ib.tws.api.Date_time_utilsKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J[\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020-H\u00d6\u0001J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006/"}, d2={"Lcom/xorrus/trading/ib/tws/api/type/Bar;", "", "date", "", "open", "Lcom/xorrus/trading/common/bignum/XBigNum;", "close", "high", "low", "wap", "volume", "<init>", "(Ljava/lang/String;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;)V", "getDate", "()Ljava/lang/String;", "getOpen", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "getClose", "getHigh", "getLow", "getWap", "getVolume", "asInstant", "Lkotlin/time/Instant;", "getAsInstant", "()Lkotlin/time/Instant;", "asDate", "Lkotlinx/datetime/LocalDate;", "getAsDate", "()Lkotlinx/datetime/LocalDate;", "getTimestamp", "timeZone", "Lkotlinx/datetime/TimeZone;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "tws-api"})
@SourceDebugExtension(value={"SMAP\nBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bar.kt\ncom/xorrus/trading/ib/tws/api/type/Bar\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,28:1\n1#2:29\n*E\n"})
public final class Bar {
    @NotNull
    private final String date;
    @Nullable
    private final XBigNum open;
    @Nullable
    private final XBigNum close;
    @Nullable
    private final XBigNum high;
    @Nullable
    private final XBigNum low;
    @Nullable
    private final XBigNum wap;
    @Nullable
    private final XBigNum volume;

    public Bar(@NotNull String date, @Nullable XBigNum open2, @Nullable XBigNum close2, @Nullable XBigNum high, @Nullable XBigNum low, @Nullable XBigNum wap, @Nullable XBigNum volume) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.date = date;
        this.open = open2;
        this.close = close2;
        this.high = high;
        this.low = low;
        this.wap = wap;
        this.volume = volume;
    }

    @NotNull
    public final String getDate() {
        return this.date;
    }

    @Nullable
    public final XBigNum getOpen() {
        return this.open;
    }

    @Nullable
    public final XBigNum getClose() {
        return this.close;
    }

    @Nullable
    public final XBigNum getHigh() {
        return this.high;
    }

    @Nullable
    public final XBigNum getLow() {
        return this.low;
    }

    @Nullable
    public final XBigNum getWap() {
        return this.wap;
    }

    @Nullable
    public final XBigNum getVolume() {
        return this.volume;
    }

    @NotNull
    public final Instant getAsInstant() {
        return Date_time_utilsKt.fromTwsToInstant(this.date);
    }

    @NotNull
    public final LocalDate getAsDate() {
        return Date_time_utilsKt.fromTwsToLocalDate(this.date);
    }

    @NotNull
    public final Instant getTimestamp(@NotNull TimeZone timeZone) {
        Object object;
        Object $this$getTimestamp_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        Object object2 = this;
        try {
            $this$getTimestamp_u24lambda_u240 = object2;
            boolean bl = false;
            $this$getTimestamp_u24lambda_u240 = Result.constructor-impl((Object)((Bar)$this$getTimestamp_u24lambda_u240).getAsInstant());
        }
        catch (Throwable bl) {
            $this$getTimestamp_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$getTimestamp_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = TimeZoneKt.atStartOfDayIn$default((LocalDate)this.getAsDate(), (TimeZone)timeZone, null, (int)2, null);
        }
        return (Instant)object;
    }

    @NotNull
    public final String component1() {
        return this.date;
    }

    @Nullable
    public final XBigNum component2() {
        return this.open;
    }

    @Nullable
    public final XBigNum component3() {
        return this.close;
    }

    @Nullable
    public final XBigNum component4() {
        return this.high;
    }

    @Nullable
    public final XBigNum component5() {
        return this.low;
    }

    @Nullable
    public final XBigNum component6() {
        return this.wap;
    }

    @Nullable
    public final XBigNum component7() {
        return this.volume;
    }

    @NotNull
    public final Bar copy(@NotNull String date, @Nullable XBigNum open2, @Nullable XBigNum close2, @Nullable XBigNum high, @Nullable XBigNum low, @Nullable XBigNum wap, @Nullable XBigNum volume) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return new Bar(date, open2, close2, high, low, wap, volume);
    }

    public static /* synthetic */ Bar copy$default(Bar bar, String string, XBigNum xBigNum, XBigNum xBigNum2, XBigNum xBigNum3, XBigNum xBigNum4, XBigNum xBigNum5, XBigNum xBigNum6, int n, Object object) {
        if ((n & 1) != 0) {
            string = bar.date;
        }
        if ((n & 2) != 0) {
            xBigNum = bar.open;
        }
        if ((n & 4) != 0) {
            xBigNum2 = bar.close;
        }
        if ((n & 8) != 0) {
            xBigNum3 = bar.high;
        }
        if ((n & 0x10) != 0) {
            xBigNum4 = bar.low;
        }
        if ((n & 0x20) != 0) {
            xBigNum5 = bar.wap;
        }
        if ((n & 0x40) != 0) {
            xBigNum6 = bar.volume;
        }
        return bar.copy(string, xBigNum, xBigNum2, xBigNum3, xBigNum4, xBigNum5, xBigNum6);
    }

    @NotNull
    public String toString() {
        return "Bar(date=" + this.date + ", open=" + this.open + ", close=" + this.close + ", high=" + this.high + ", low=" + this.low + ", wap=" + this.wap + ", volume=" + this.volume + ")";
    }

    public int hashCode() {
        int result = this.date.hashCode();
        result = result * 31 + (this.open == null ? 0 : this.open.hashCode());
        result = result * 31 + (this.close == null ? 0 : this.close.hashCode());
        result = result * 31 + (this.high == null ? 0 : this.high.hashCode());
        result = result * 31 + (this.low == null ? 0 : this.low.hashCode());
        result = result * 31 + (this.wap == null ? 0 : this.wap.hashCode());
        result = result * 31 + (this.volume == null ? 0 : this.volume.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Bar)) {
            return false;
        }
        Bar bar = (Bar)other;
        if (!Intrinsics.areEqual((Object)this.date, (Object)bar.date)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.open, (Object)bar.open)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.close, (Object)bar.close)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.high, (Object)bar.high)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.low, (Object)bar.low)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.wap, (Object)bar.wap)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.volume, (Object)bar.volume);
    }
}

