/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.api.stream;

import com.xorrus.trading.ib.tws.api.stream.SnifferDirection;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/xorrus/trading/ib/tws/api/stream/SnifferWriter;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "file", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "writer", "Ljava/io/BufferedWriter;", "buffer", "", "", "currentDirection", "Lcom/xorrus/trading/ib/tws/api/stream/SnifferDirection;", "writeRawByte", "", "b", "readRawByte", "switchDirection", "newDirection", "flush", "close", "tws-api"})
public final class SnifferWriter
implements AutoCloseable {
    @NotNull
    private final BufferedWriter writer;
    @NotNull
    private final List<Byte> buffer;
    @Nullable
    private SnifferDirection currentDirection;

    public SnifferWriter(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = file;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object object = file2;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset);
        this.writer = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        this.buffer = new ArrayList();
    }

    public final void writeRawByte(byte b) {
        this.switchDirection(SnifferDirection.WRITE);
        this.buffer.add(b);
    }

    public final void readRawByte(byte b) {
        this.switchDirection(SnifferDirection.READ);
        this.buffer.add(b);
    }

    private final void switchDirection(SnifferDirection newDirection) {
        if (this.currentDirection != null && this.currentDirection != newDirection) {
            this.flush();
        }
        this.currentDirection = newDirection;
    }

    private final void flush() {
        if (!((Collection)this.buffer).isEmpty() && this.currentDirection != null) {
            SnifferDirection snifferDirection = this.currentDirection;
            Intrinsics.checkNotNull((Object)((Object)snifferDirection));
            this.writer.write(snifferDirection.getPrefix() + ": ");
            this.writer.write(CollectionsKt.joinToString$default((Iterable)this.buffer, (CharSequence)" ", null, null, (int)0, null, SnifferWriter::flush$lambda$0, (int)30, null));
            this.writer.newLine();
            this.buffer.clear();
        }
    }

    @Override
    public void close() {
        this.flush();
        this.writer.close();
    }

    private static final CharSequence flush$lambda$0(byte it) {
        String string = "%02X";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

