/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.contract.cache.serializer;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0010J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00018\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/xorrus/trading/ib/tws/contract/cache/serializer/JsonEhcacheSerializer;", "T", "", "Lorg/ehcache/spi/serialization/Serializer;", "kSerializer", "Lkotlinx/serialization/KSerializer;", "json", "Lkotlinx/serialization/json/Json;", "<init>", "(Lkotlinx/serialization/KSerializer;Lkotlinx/serialization/json/Json;)V", "serialize", "Ljava/nio/ByteBuffer;", "objectToSerialize", "(Ljava/lang/Object;)Ljava/nio/ByteBuffer;", "read", "binary", "(Ljava/nio/ByteBuffer;)Ljava/lang/Object;", "equals", "", "obj", "(Ljava/lang/Object;Ljava/nio/ByteBuffer;)Z", "tws-api"})
public final class JsonEhcacheSerializer<T>
implements Serializer<T> {
    @NotNull
    private final KSerializer<T> kSerializer;
    @NotNull
    private final Json json;

    public JsonEhcacheSerializer(@NotNull KSerializer<T> kSerializer, @NotNull Json json) {
        Intrinsics.checkNotNullParameter(kSerializer, (String)"kSerializer");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.kSerializer = kSerializer;
        this.json = json;
    }

    public /* synthetic */ JsonEhcacheSerializer(KSerializer kSerializer, Json json, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            json = JsonKt.Json$default(null, JsonEhcacheSerializer::_init_$lambda$0, (int)1, null);
        }
        this(kSerializer, json);
    }

    @NotNull
    public ByteBuffer serialize(@NotNull T objectToSerialize) {
        Intrinsics.checkNotNullParameter(objectToSerialize, (String)"objectToSerialize");
        try {
            byte[] byArray = this.json.encodeToString((SerializationStrategy)this.kSerializer, objectToSerialize).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] bytes = byArray;
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
            return byteBuffer;
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializerException("Unexpected error during serialization of type " + Reflection.getOrCreateKotlinClass(objectToSerialize.getClass()).getQualifiedName(), (Throwable)e);
        }
    }

    @NotNull
    public T read(@NotNull ByteBuffer binary) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        try {
            byte[] bytes = new byte[binary.remaining()];
            binary.get(bytes);
            String str = new String(bytes, Charsets.UTF_8);
            Object obj = this.json.decodeFromString((DeserializationStrategy)this.kSerializer, str);
            return (T)obj;
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new SerializerException("Invalid ByteBuffer or encoding error during deserialization", (Throwable)e);
        }
        catch (Exception e) {
            throw new SerializerException("Unexpected error during deserialization", (Throwable)e);
        }
    }

    public boolean equals(@Nullable T obj, @Nullable ByteBuffer binary) {
        if (obj == null || binary == null) {
            return false;
        }
        try {
            ByteBuffer byteBuffer = binary.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
            T deserializedObj = this.read(byteBuffer);
            boolean result = Intrinsics.areEqual(obj, deserializedObj);
            return result;
        }
        catch (SerializerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializerException("Unexpected error during equals comparison", (Throwable)e);
        }
    }

    private static final Unit _init_$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setEncodeDefaults(true);
        $this$Json.setExplicitNulls(false);
        return Unit.INSTANCE;
    }
}

