/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.order;

import com.xorrus.trading.common.bignum.XBigNum;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00132\u00020\u0001:\u0006\u000e\u000f\u0010\u0011\u0012\u0013B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u0082\u0001\u0005\u0014\u0015\u0016\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lcom/xorrus/trading/ib/tws/order/OrderType;", "", "ibValue", "", "<init>", "(Ljava/lang/String;)V", "getIbValue", "()Ljava/lang/String;", "ibLmtValue", "Lcom/xorrus/trading/common/bignum/XBigNum;", "getIbLmtValue", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "ibStopValue", "getIbStopValue", "Market", "Limit", "Stop", "StopLimit", "PegToMid", "Companion", "Lcom/xorrus/trading/ib/tws/order/OrderType$Limit;", "Lcom/xorrus/trading/ib/tws/order/OrderType$Market;", "Lcom/xorrus/trading/ib/tws/order/OrderType$PegToMid;", "Lcom/xorrus/trading/ib/tws/order/OrderType$Stop;", "Lcom/xorrus/trading/ib/tws/order/OrderType$StopLimit;", "tws-api"})
public abstract sealed class OrderType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String ibValue;

    private OrderType(String ibValue) {
        this.ibValue = ibValue;
    }

    @NotNull
    public final String getIbValue() {
        return this.ibValue;
    }

    @Nullable
    public XBigNum getIbLmtValue() {
        return null;
    }

    @Nullable
    public XBigNum getIbStopValue() {
        return null;
    }

    public /* synthetic */ OrderType(String ibValue, DefaultConstructorMarker $constructor_marker) {
        this(ibValue);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a8\u0006\u000b"}, d2={"Lcom/xorrus/trading/ib/tws/order/OrderType$Companion;", "", "<init>", "()V", "fromIb", "Lcom/xorrus/trading/ib/tws/order/OrderType;", "ibOrderType", "", "lmtPrice", "Lcom/xorrus/trading/common/bignum/XBigNum;", "auxPrice", "tws-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OrderType fromIb(@NotNull String ibOrderType, @Nullable XBigNum lmtPrice, @Nullable XBigNum auxPrice) {
            Intrinsics.checkNotNullParameter((Object)ibOrderType, (String)"ibOrderType");
            return switch (ibOrderType) {
                case "MKT" -> Market.INSTANCE;
                case "STP" -> {
                    XBigNum v1 = auxPrice;
                    Intrinsics.checkNotNull((Object)v1);
                    yield new Stop(v1);
                }
                case "STP LMT" -> {
                    XBigNum v2 = lmtPrice;
                    Intrinsics.checkNotNull((Object)v2);
                    XBigNum v3 = auxPrice;
                    Intrinsics.checkNotNull((Object)v3);
                    yield new StopLimit(v2, v3);
                }
                case "LMT" -> {
                    if (!(auxPrice == null || Intrinsics.areEqual((Object)auxPrice, (Object)XBigNum.Companion.getZERO()))) {
                        String var5_5 = "Failed requirement.";
                        throw new IllegalArgumentException(var5_5.toString());
                    }
                    XBigNum v4 = lmtPrice;
                    Intrinsics.checkNotNull((Object)v4);
                    yield new Limit(v4);
                }
                default -> throw new IllegalArgumentException("Unknown order type: " + ibOrderType);
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/xorrus/trading/ib/tws/order/OrderType$Limit;", "Lcom/xorrus/trading/ib/tws/order/OrderType;", "price", "Lcom/xorrus/trading/common/bignum/XBigNum;", "<init>", "(Lcom/xorrus/trading/common/bignum/XBigNum;)V", "getPrice", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "ibLmtValue", "getIbLmtValue", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "tws-api"})
    public static final class Limit
    extends OrderType {
        @NotNull
        private final XBigNum price;

        public Limit(@NotNull XBigNum price) {
            Intrinsics.checkNotNullParameter((Object)price, (String)"price");
            super("LMT", null);
            this.price = price;
        }

        @NotNull
        public final XBigNum getPrice() {
            return this.price;
        }

        @Override
        @NotNull
        public XBigNum getIbLmtValue() {
            return this.price;
        }

        @NotNull
        public final XBigNum component1() {
            return this.price;
        }

        @NotNull
        public final Limit copy(@NotNull XBigNum price) {
            Intrinsics.checkNotNullParameter((Object)price, (String)"price");
            return new Limit(price);
        }

        public static /* synthetic */ Limit copy$default(Limit limit, XBigNum xBigNum, int n, Object object) {
            if ((n & 1) != 0) {
                xBigNum = limit.price;
            }
            return limit.copy(xBigNum);
        }

        @NotNull
        public String toString() {
            return "Limit(price=" + this.price + ")";
        }

        public int hashCode() {
            return this.price.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Limit)) {
                return false;
            }
            Limit limit = (Limit)other;
            return Intrinsics.areEqual((Object)this.price, (Object)limit.price);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/xorrus/trading/ib/tws/order/OrderType$Market;", "Lcom/xorrus/trading/ib/tws/order/OrderType;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "tws-api"})
    public static final class Market
    extends OrderType {
        @NotNull
        public static final Market INSTANCE = new Market();

        private Market() {
            super("MKT", null);
        }

        @NotNull
        public String toString() {
            return "Market";
        }

        public int hashCode() {
            return -231192612;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Market)) {
                return false;
            }
            Market cfr_ignored_0 = (Market)other;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/xorrus/trading/ib/tws/order/OrderType$PegToMid;", "Lcom/xorrus/trading/ib/tws/order/OrderType;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "tws-api"})
    public static final class PegToMid
    extends OrderType {
        @NotNull
        public static final PegToMid INSTANCE = new PegToMid();

        private PegToMid() {
            super("PEG MID", null);
        }

        @NotNull
        public String toString() {
            return "PegToMid";
        }

        public int hashCode() {
            return 1014812539;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PegToMid)) {
                return false;
            }
            PegToMid cfr_ignored_0 = (PegToMid)other;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/xorrus/trading/ib/tws/order/OrderType$Stop;", "Lcom/xorrus/trading/ib/tws/order/OrderType;", "stopPrice", "Lcom/xorrus/trading/common/bignum/XBigNum;", "<init>", "(Lcom/xorrus/trading/common/bignum/XBigNum;)V", "getStopPrice", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "ibStopValue", "getIbStopValue", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "tws-api"})
    public static final class Stop
    extends OrderType {
        @NotNull
        private final XBigNum stopPrice;

        public Stop(@NotNull XBigNum stopPrice) {
            Intrinsics.checkNotNullParameter((Object)stopPrice, (String)"stopPrice");
            super("STP", null);
            this.stopPrice = stopPrice;
        }

        @NotNull
        public final XBigNum getStopPrice() {
            return this.stopPrice;
        }

        @Override
        @NotNull
        public XBigNum getIbStopValue() {
            return this.stopPrice;
        }

        @NotNull
        public final XBigNum component1() {
            return this.stopPrice;
        }

        @NotNull
        public final Stop copy(@NotNull XBigNum stopPrice) {
            Intrinsics.checkNotNullParameter((Object)stopPrice, (String)"stopPrice");
            return new Stop(stopPrice);
        }

        public static /* synthetic */ Stop copy$default(Stop stop2, XBigNum xBigNum, int n, Object object) {
            if ((n & 1) != 0) {
                xBigNum = stop2.stopPrice;
            }
            return stop2.copy(xBigNum);
        }

        @NotNull
        public String toString() {
            return "Stop(stopPrice=" + this.stopPrice + ")";
        }

        public int hashCode() {
            return this.stopPrice.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stop)) {
                return false;
            }
            Stop stop2 = (Stop)other;
            return Intrinsics.areEqual((Object)this.stopPrice, (Object)stop2.stopPrice);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/xorrus/trading/ib/tws/order/OrderType$StopLimit;", "Lcom/xorrus/trading/ib/tws/order/OrderType;", "stopPrice", "Lcom/xorrus/trading/common/bignum/XBigNum;", "limitPrice", "<init>", "(Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;)V", "getStopPrice", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "getLimitPrice", "ibLmtValue", "getIbLmtValue", "ibStopValue", "getIbStopValue", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "tws-api"})
    public static final class StopLimit
    extends OrderType {
        @NotNull
        private final XBigNum stopPrice;
        @NotNull
        private final XBigNum limitPrice;

        public StopLimit(@NotNull XBigNum stopPrice, @NotNull XBigNum limitPrice) {
            Intrinsics.checkNotNullParameter((Object)stopPrice, (String)"stopPrice");
            Intrinsics.checkNotNullParameter((Object)limitPrice, (String)"limitPrice");
            super("STP LMT", null);
            this.stopPrice = stopPrice;
            this.limitPrice = limitPrice;
        }

        @NotNull
        public final XBigNum getStopPrice() {
            return this.stopPrice;
        }

        @NotNull
        public final XBigNum getLimitPrice() {
            return this.limitPrice;
        }

        @Override
        @NotNull
        public XBigNum getIbLmtValue() {
            return this.limitPrice;
        }

        @Override
        @NotNull
        public XBigNum getIbStopValue() {
            return this.stopPrice;
        }

        @NotNull
        public final XBigNum component1() {
            return this.stopPrice;
        }

        @NotNull
        public final XBigNum component2() {
            return this.limitPrice;
        }

        @NotNull
        public final StopLimit copy(@NotNull XBigNum stopPrice, @NotNull XBigNum limitPrice) {
            Intrinsics.checkNotNullParameter((Object)stopPrice, (String)"stopPrice");
            Intrinsics.checkNotNullParameter((Object)limitPrice, (String)"limitPrice");
            return new StopLimit(stopPrice, limitPrice);
        }

        public static /* synthetic */ StopLimit copy$default(StopLimit stopLimit, XBigNum xBigNum, XBigNum xBigNum2, int n, Object object) {
            if ((n & 1) != 0) {
                xBigNum = stopLimit.stopPrice;
            }
            if ((n & 2) != 0) {
                xBigNum2 = stopLimit.limitPrice;
            }
            return stopLimit.copy(xBigNum, xBigNum2);
        }

        @NotNull
        public String toString() {
            return "StopLimit(stopPrice=" + this.stopPrice + ", limitPrice=" + this.limitPrice + ")";
        }

        public int hashCode() {
            int result = this.stopPrice.hashCode();
            result = result * 31 + this.limitPrice.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StopLimit)) {
                return false;
            }
            StopLimit stopLimit = (StopLimit)other;
            if (!Intrinsics.areEqual((Object)this.stopPrice, (Object)stopLimit.stopPrice)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.limitPrice, (Object)stopLimit.limitPrice);
        }
    }
}

