/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.api.type;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Right;
import com.xorrus.trading.ib.tws.api.Date_time_utilsKt;
import com.xorrus.trading.ib.tws.api.type.Contract;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\bf\u0018\u00002\u00020\u0001J\u0017\u0010)\u001a\u00020\u00002\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010*J\u0012\u0010+\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010,\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010-\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010-\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010.H\u0016J\u0012\u0010/\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u00100\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u00101\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u00102\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u00103\u001a\u00020\u00002\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u00104\u001a\u00020\u00002\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u00105\u001a\u00020\u00002\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u00106\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u0007H\u0016J&\u00107\u001a\u00020\u00002\b\u00108\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\tR\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\tR\u0014\u0010\u001a\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\tR\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\tR\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\tR\u0014\u0010 \u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\tR\u0014\u0010\"\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\tR$\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00000&0%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00069\u00c0\u0006\u0003"}, d2={"Lcom/xorrus/trading/ib/tws/api/type/IContract;", "", "conId", "", "getConId", "()Ljava/lang/Integer;", "symbol", "", "getSymbol", "()Ljava/lang/String;", "secType", "getSecType", "lastTradeDateOrContractMonth", "getLastTradeDateOrContractMonth", "strike", "Lcom/xorrus/trading/common/bignum/XBigNum;", "getStrike", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "right", "Lcom/xorrus/trading/common/contract/Right;", "getRight", "()Lcom/xorrus/trading/common/contract/Right;", "multiplier", "getMultiplier", "exchange", "getExchange", "primaryExchange", "getPrimaryExchange", "currency", "getCurrency", "localSymbol", "getLocalSymbol", "tradingClass", "getTradingClass", "description", "getDescription", "legs", "", "Lkotlin/Pair;", "getLegs", "()Ljava/util/List;", "withConId", "(Ljava/lang/Integer;)Lcom/xorrus/trading/ib/tws/api/type/IContract;", "withSymbol", "withSecType", "withLastTradeDateOrContractMonth", "Lkotlinx/datetime/LocalDate;", "withStrike", "withRight", "withMultiplier", "withExchange", "withPrimaryExchange", "withCurrency", "withLocalSymbol", "withTradingClass", "getOptionDef", "expiry", "tws-api"})
public interface IContract {
    @Nullable
    public Integer getConId();

    @Nullable
    public String getSymbol();

    @Nullable
    public String getSecType();

    @Nullable
    public String getLastTradeDateOrContractMonth();

    @Nullable
    public XBigNum getStrike();

    @Nullable
    public Right getRight();

    @Nullable
    public String getMultiplier();

    @Nullable
    public String getExchange();

    @Nullable
    public String getPrimaryExchange();

    @Nullable
    public String getCurrency();

    @Nullable
    public String getLocalSymbol();

    @Nullable
    public String getTradingClass();

    @Nullable
    public String getDescription();

    @NotNull
    public List<Pair<Integer, IContract>> getLegs();

    @NotNull
    default public IContract withConId(@Nullable Integer conId) {
        return new Contract(conId, this.getSymbol(), this.getSecType(), this.getLastTradeDateOrContractMonth(), this.getStrike(), this.getRight(), this.getMultiplier(), this.getExchange(), this.getPrimaryExchange(), this.getCurrency(), this.getLocalSymbol(), this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withSymbol(@Nullable String symbol) {
        return new Contract(this.getConId(), symbol, this.getSecType(), this.getLastTradeDateOrContractMonth(), this.getStrike(), this.getRight(), this.getMultiplier(), this.getExchange(), this.getPrimaryExchange(), this.getCurrency(), this.getLocalSymbol(), this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withSecType(@Nullable String secType) {
        return new Contract(this.getConId(), this.getSymbol(), secType, this.getLastTradeDateOrContractMonth(), this.getStrike(), this.getRight(), this.getMultiplier(), this.getExchange(), this.getPrimaryExchange(), this.getCurrency(), this.getLocalSymbol(), this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withLastTradeDateOrContractMonth(@Nullable String lastTradeDateOrContractMonth) {
        return new Contract(this.getConId(), this.getSymbol(), this.getSecType(), lastTradeDateOrContractMonth, this.getStrike(), this.getRight(), this.getMultiplier(), this.getExchange(), this.getPrimaryExchange(), this.getCurrency(), this.getLocalSymbol(), this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withLastTradeDateOrContractMonth(@Nullable LocalDate lastTradeDateOrContractMonth) {
        LocalDate localDate = lastTradeDateOrContractMonth;
        return new Contract(this.getConId(), this.getSymbol(), this.getSecType(), localDate != null ? Date_time_utilsKt.toTwsString(localDate) : null, this.getStrike(), this.getRight(), this.getMultiplier(), this.getExchange(), this.getPrimaryExchange(), this.getCurrency(), this.getLocalSymbol(), this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withStrike(@Nullable XBigNum strike) {
        return new Contract(this.getConId(), this.getSymbol(), this.getSecType(), this.getLastTradeDateOrContractMonth(), strike, this.getRight(), this.getMultiplier(), this.getExchange(), this.getPrimaryExchange(), this.getCurrency(), this.getLocalSymbol(), this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withRight(@Nullable Right right) {
        return new Contract(this.getConId(), this.getSymbol(), this.getSecType(), this.getLastTradeDateOrContractMonth(), this.getStrike(), right, this.getMultiplier(), this.getExchange(), this.getPrimaryExchange(), this.getCurrency(), this.getLocalSymbol(), this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withMultiplier(@Nullable String multiplier) {
        return new Contract(this.getConId(), this.getSymbol(), this.getSecType(), this.getLastTradeDateOrContractMonth(), this.getStrike(), this.getRight(), multiplier, this.getExchange(), this.getPrimaryExchange(), this.getCurrency(), this.getLocalSymbol(), this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withExchange(@Nullable String exchange2) {
        return new Contract(this.getConId(), this.getSymbol(), this.getSecType(), this.getLastTradeDateOrContractMonth(), this.getStrike(), this.getRight(), this.getMultiplier(), exchange2, this.getPrimaryExchange(), this.getCurrency(), this.getLocalSymbol(), this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withPrimaryExchange(@Nullable String primaryExchange) {
        return new Contract(this.getConId(), this.getSymbol(), this.getSecType(), this.getLastTradeDateOrContractMonth(), this.getStrike(), this.getRight(), this.getMultiplier(), this.getExchange(), primaryExchange, this.getCurrency(), this.getLocalSymbol(), this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withCurrency(@Nullable String currency) {
        return new Contract(this.getConId(), this.getSymbol(), this.getSecType(), this.getLastTradeDateOrContractMonth(), this.getStrike(), this.getRight(), this.getMultiplier(), this.getExchange(), this.getPrimaryExchange(), currency, this.getLocalSymbol(), this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withLocalSymbol(@Nullable String localSymbol) {
        return new Contract(this.getConId(), this.getSymbol(), this.getSecType(), this.getLastTradeDateOrContractMonth(), this.getStrike(), this.getRight(), this.getMultiplier(), this.getExchange(), this.getPrimaryExchange(), this.getCurrency(), localSymbol, this.getTradingClass(), null, null, 12288, null);
    }

    @NotNull
    default public IContract withTradingClass(@Nullable String tradingClass) {
        return new Contract(this.getConId(), this.getSymbol(), this.getSecType(), this.getLastTradeDateOrContractMonth(), this.getStrike(), this.getRight(), this.getMultiplier(), this.getExchange(), this.getPrimaryExchange(), this.getCurrency(), this.getLocalSymbol(), tradingClass, null, null, 12288, null);
    }

    @NotNull
    default public IContract getOptionDef(@Nullable String expiry, @Nullable XBigNum strike, @Nullable Right right) {
        return this.withConId(null).withSecType("OPT").withLastTradeDateOrContractMonth(expiry).withStrike(strike).withRight(right).withMultiplier(null).withExchange(null).withPrimaryExchange(null).withCurrency(null).withLocalSymbol(null).withTradingClass(null);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static IContract withConId(@NotNull IContract $this, @Nullable Integer conId) {
            return $this.withConId(conId);
        }

        @Deprecated
        @NotNull
        public static IContract withSymbol(@NotNull IContract $this, @Nullable String symbol) {
            return $this.withSymbol(symbol);
        }

        @Deprecated
        @NotNull
        public static IContract withSecType(@NotNull IContract $this, @Nullable String secType) {
            return $this.withSecType(secType);
        }

        @Deprecated
        @NotNull
        public static IContract withLastTradeDateOrContractMonth(@NotNull IContract $this, @Nullable String lastTradeDateOrContractMonth) {
            return $this.withLastTradeDateOrContractMonth(lastTradeDateOrContractMonth);
        }

        @Deprecated
        @NotNull
        public static IContract withLastTradeDateOrContractMonth(@NotNull IContract $this, @Nullable LocalDate lastTradeDateOrContractMonth) {
            return $this.withLastTradeDateOrContractMonth(lastTradeDateOrContractMonth);
        }

        @Deprecated
        @NotNull
        public static IContract withStrike(@NotNull IContract $this, @Nullable XBigNum strike) {
            return $this.withStrike(strike);
        }

        @Deprecated
        @NotNull
        public static IContract withRight(@NotNull IContract $this, @Nullable Right right) {
            return $this.withRight(right);
        }

        @Deprecated
        @NotNull
        public static IContract withMultiplier(@NotNull IContract $this, @Nullable String multiplier) {
            return $this.withMultiplier(multiplier);
        }

        @Deprecated
        @NotNull
        public static IContract withExchange(@NotNull IContract $this, @Nullable String exchange2) {
            return $this.withExchange(exchange2);
        }

        @Deprecated
        @NotNull
        public static IContract withPrimaryExchange(@NotNull IContract $this, @Nullable String primaryExchange) {
            return $this.withPrimaryExchange(primaryExchange);
        }

        @Deprecated
        @NotNull
        public static IContract withCurrency(@NotNull IContract $this, @Nullable String currency) {
            return $this.withCurrency(currency);
        }

        @Deprecated
        @NotNull
        public static IContract withLocalSymbol(@NotNull IContract $this, @Nullable String localSymbol) {
            return $this.withLocalSymbol(localSymbol);
        }

        @Deprecated
        @NotNull
        public static IContract withTradingClass(@NotNull IContract $this, @Nullable String tradingClass) {
            return $this.withTradingClass(tradingClass);
        }

        @Deprecated
        @NotNull
        public static IContract getOptionDef(@NotNull IContract $this, @Nullable String expiry, @Nullable XBigNum strike, @Nullable Right right) {
            return $this.getOptionDef(expiry, strike, right);
        }
    }
}

