/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.api.command;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.ib.tws.api.command.MktDataSnapshotCommand;
import com.xorrus.trading.ib.tws.api.type.Halted;
import com.xorrus.trading.ib.tws.api.type.MarketDataType;
import com.xorrus.trading.ib.tws.api.type.TickType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0015\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0007H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u00107\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u00108\u001a\u00020\rH\u00c6\u0003JK\u00109\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010=\u001a\u00020\rH\u00d6\u0001J\t\u0010>\u001a\u00020\u000bH\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010 \u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015R\u0013\u0010\"\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0015R\u0013\u0010$\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0015R\u0013\u0010&\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0015R\u0013\u0010(\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0015R\u0013\u0010*\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0015R\u0013\u0010,\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0015R\u0013\u0010.\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0015R\u0013\u00100\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0015R\u0013\u00102\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0015\u00a8\u0006?"}, d2={"Lcom/xorrus/trading/ib/tws/api/command/MarketDataAggregated;", "", "ticks", "", "Lcom/xorrus/trading/ib/tws/api/type/TickType;", "Lcom/xorrus/trading/ib/tws/api/command/MktDataSnapshotCommand$Tick;", "marketDataType", "Lcom/xorrus/trading/ib/tws/api/type/MarketDataType;", "minTick", "Lcom/xorrus/trading/common/bignum/XBigNum;", "bboExchange", "", "snapshotPermissions", "", "<init>", "(Ljava/util/Map;Lcom/xorrus/trading/ib/tws/api/type/MarketDataType;Lcom/xorrus/trading/common/bignum/XBigNum;Ljava/lang/String;I)V", "getTicks", "()Ljava/util/Map;", "getMarketDataType", "()Lcom/xorrus/trading/ib/tws/api/type/MarketDataType;", "getMinTick", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "getBboExchange", "()Ljava/lang/String;", "getSnapshotPermissions", "()I", "getPrice", "tickType", "halted", "Lcom/xorrus/trading/ib/tws/api/type/Halted;", "getHalted", "()Lcom/xorrus/trading/ib/tws/api/type/Halted;", "open", "getOpen", "close", "getClose", "mark", "getMark", "optionImpliedVolatility", "getOptionImpliedVolatility", "bid", "getBid", "ask", "getAsk", "last", "getLast", "volume", "getVolume", "modelOptionComputationDelta", "getModelOptionComputationDelta", "futuresOpenInterest", "getFuturesOpenInterest", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "tws-api"})
public final class MarketDataAggregated {
    @NotNull
    private final Map<TickType, MktDataSnapshotCommand.Tick> ticks;
    @NotNull
    private final MarketDataType marketDataType;
    @Nullable
    private final XBigNum minTick;
    @Nullable
    private final String bboExchange;
    private final int snapshotPermissions;

    public MarketDataAggregated(@NotNull Map<TickType, ? extends MktDataSnapshotCommand.Tick> ticks, @NotNull MarketDataType marketDataType, @Nullable XBigNum minTick, @Nullable String bboExchange, int snapshotPermissions) {
        Intrinsics.checkNotNullParameter(ticks, (String)"ticks");
        Intrinsics.checkNotNullParameter((Object)((Object)marketDataType), (String)"marketDataType");
        this.ticks = ticks;
        this.marketDataType = marketDataType;
        this.minTick = minTick;
        this.bboExchange = bboExchange;
        this.snapshotPermissions = snapshotPermissions;
    }

    @NotNull
    public final Map<TickType, MktDataSnapshotCommand.Tick> getTicks() {
        return this.ticks;
    }

    @NotNull
    public final MarketDataType getMarketDataType() {
        return this.marketDataType;
    }

    @Nullable
    public final XBigNum getMinTick() {
        return this.minTick;
    }

    @Nullable
    public final String getBboExchange() {
        return this.bboExchange;
    }

    public final int getSnapshotPermissions() {
        return this.snapshotPermissions;
    }

    private final XBigNum getPrice(TickType tickType) {
        MktDataSnapshotCommand.TickPrice tickPrice = (MktDataSnapshotCommand.TickPrice)this.ticks.get((Object)tickType);
        return tickPrice != null ? tickPrice.getPrice() : null;
    }

    @Nullable
    public final Halted getHalted() {
        return Halted.Companion.fromGenericTick((MktDataSnapshotCommand.TickGeneric)this.ticks.get((Object)TickType.HALTED));
    }

    @Nullable
    public final XBigNum getOpen() {
        return this.getPrice(TickType.OPEN);
    }

    @Nullable
    public final XBigNum getClose() {
        return this.getPrice(TickType.CLOSE);
    }

    @Nullable
    public final XBigNum getMark() {
        return this.getPrice(TickType.MARK_PRICE);
    }

    @Nullable
    public final XBigNum getOptionImpliedVolatility() {
        MktDataSnapshotCommand.TickGeneric tickGeneric = (MktDataSnapshotCommand.TickGeneric)this.ticks.get((Object)TickType.OPTION_IMPLIED_VOL);
        return tickGeneric != null ? tickGeneric.getValue() : null;
    }

    @Nullable
    public final XBigNum getBid() {
        return this.getPrice(TickType.BID);
    }

    @Nullable
    public final XBigNum getAsk() {
        return this.getPrice(TickType.ASK);
    }

    @Nullable
    public final XBigNum getLast() {
        return this.getPrice(TickType.LAST);
    }

    @Nullable
    public final XBigNum getVolume() {
        MktDataSnapshotCommand.TickSize tickSize = (MktDataSnapshotCommand.TickSize)this.ticks.get((Object)TickType.VOLUME);
        return tickSize != null ? tickSize.getValue() : null;
    }

    @Nullable
    public final XBigNum getModelOptionComputationDelta() {
        MktDataSnapshotCommand.TickOptionComputation tickOptionComputation = (MktDataSnapshotCommand.TickOptionComputation)this.ticks.get((Object)TickType.MODEL_OPTION);
        return tickOptionComputation != null ? tickOptionComputation.getDelta() : null;
    }

    @Nullable
    public final XBigNum getFuturesOpenInterest() {
        MktDataSnapshotCommand.TickSize tickSize = (MktDataSnapshotCommand.TickSize)this.ticks.get((Object)TickType.FUTURES_OPEN_INTEREST);
        return tickSize != null ? tickSize.getValue() : null;
    }

    @NotNull
    public final Map<TickType, MktDataSnapshotCommand.Tick> component1() {
        return this.ticks;
    }

    @NotNull
    public final MarketDataType component2() {
        return this.marketDataType;
    }

    @Nullable
    public final XBigNum component3() {
        return this.minTick;
    }

    @Nullable
    public final String component4() {
        return this.bboExchange;
    }

    public final int component5() {
        return this.snapshotPermissions;
    }

    @NotNull
    public final MarketDataAggregated copy(@NotNull Map<TickType, ? extends MktDataSnapshotCommand.Tick> ticks, @NotNull MarketDataType marketDataType, @Nullable XBigNum minTick, @Nullable String bboExchange, int snapshotPermissions) {
        Intrinsics.checkNotNullParameter(ticks, (String)"ticks");
        Intrinsics.checkNotNullParameter((Object)((Object)marketDataType), (String)"marketDataType");
        return new MarketDataAggregated(ticks, marketDataType, minTick, bboExchange, snapshotPermissions);
    }

    public static /* synthetic */ MarketDataAggregated copy$default(MarketDataAggregated marketDataAggregated, Map map2, MarketDataType marketDataType, XBigNum xBigNum, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            map2 = marketDataAggregated.ticks;
        }
        if ((n2 & 2) != 0) {
            marketDataType = marketDataAggregated.marketDataType;
        }
        if ((n2 & 4) != 0) {
            xBigNum = marketDataAggregated.minTick;
        }
        if ((n2 & 8) != 0) {
            string = marketDataAggregated.bboExchange;
        }
        if ((n2 & 0x10) != 0) {
            n = marketDataAggregated.snapshotPermissions;
        }
        return marketDataAggregated.copy(map2, marketDataType, xBigNum, string, n);
    }

    @NotNull
    public String toString() {
        return "MarketDataAggregated(ticks=" + this.ticks + ", marketDataType=" + this.marketDataType + ", minTick=" + this.minTick + ", bboExchange=" + this.bboExchange + ", snapshotPermissions=" + this.snapshotPermissions + ")";
    }

    public int hashCode() {
        int result = ((Object)this.ticks).hashCode();
        result = result * 31 + this.marketDataType.hashCode();
        result = result * 31 + (this.minTick == null ? 0 : this.minTick.hashCode());
        result = result * 31 + (this.bboExchange == null ? 0 : this.bboExchange.hashCode());
        result = result * 31 + Integer.hashCode(this.snapshotPermissions);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MarketDataAggregated)) {
            return false;
        }
        MarketDataAggregated marketDataAggregated = (MarketDataAggregated)other;
        if (!Intrinsics.areEqual(this.ticks, marketDataAggregated.ticks)) {
            return false;
        }
        if (this.marketDataType != marketDataAggregated.marketDataType) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.minTick, (Object)marketDataAggregated.minTick)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bboExchange, (Object)marketDataAggregated.bboExchange)) {
            return false;
        }
        return this.snapshotPermissions == marketDataAggregated.snapshotPermissions;
    }
}

