/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.input;

import com.github.ajalt.mordant.input.InputEvent;
import com.github.ajalt.mordant.input.InputReceiver;
import com.github.ajalt.mordant.input.InputReceiverAnimation;
import com.github.ajalt.mordant.input.SelectInputAnimation;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/github/ajalt/mordant/input/SingleSelectInputAnimation;", "Lcom/github/ajalt/mordant/input/InputReceiverAnimation;", "", "animation", "Lcom/github/ajalt/mordant/input/SelectInputAnimation;", "<init>", "(Lcom/github/ajalt/mordant/input/SelectInputAnimation;)V", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "getTerminal", "()Lcom/github/ajalt/mordant/terminal/Terminal;", "stop", "", "clear", "receiveEvent", "Lcom/github/ajalt/mordant/input/InputReceiver$Status;", "event", "Lcom/github/ajalt/mordant/input/InputEvent;", "mordant"})
final class SingleSelectInputAnimation
implements InputReceiverAnimation<String> {
    @NotNull
    private final SelectInputAnimation animation;

    public SingleSelectInputAnimation(@NotNull SelectInputAnimation animation2) {
        Intrinsics.checkNotNullParameter((Object)animation2, (String)"animation");
        this.animation = animation2;
    }

    @Override
    @NotNull
    public Terminal getTerminal() {
        return this.animation.getTerminal();
    }

    @Override
    public void stop() {
        this.animation.stop();
    }

    @Override
    public void clear() {
        this.animation.clear();
    }

    @Override
    @NotNull
    public InputReceiver.Status<String> receiveEvent(@NotNull InputEvent event) {
        InputReceiver.Status status;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InputReceiver.Status<List<String>> status2 = this.animation.receiveEvent(event);
        if (status2 instanceof InputReceiver.Status.Finished) {
            List list = (List)((InputReceiver.Status.Finished)status2).getResult();
            status = new InputReceiver.Status.Finished<String>(list != null ? (String)CollectionsKt.firstOrNull((List)list) : null);
        } else if (status2 instanceof InputReceiver.Status.Continue) {
            status = InputReceiver.Status.Continue.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return status;
    }
}

