/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.ib.flex.tradeconfirmation;

import com.xorrus.common.kotlin.stax.CompoundHandler;
import com.xorrus.common.kotlin.stax.CurrentAttrHandler;
import com.xorrus.common.kotlin.stax.CustomTypeHandler;
import com.xorrus.common.kotlin.stax.InstantWithFlexDefaultTimeZoneHandler;
import com.xorrus.common.kotlin.stax.IntHandler;
import com.xorrus.common.kotlin.stax.IntOrNullHandler;
import com.xorrus.common.kotlin.stax.ListHandler;
import com.xorrus.common.kotlin.stax.LocalDateHandler;
import com.xorrus.common.kotlin.stax.LocalDateOrNullHandler;
import com.xorrus.common.kotlin.stax.LocalDateTimeHandler;
import com.xorrus.common.kotlin.stax.OptionalHandler;
import com.xorrus.common.kotlin.stax.SingleHandler;
import com.xorrus.common.kotlin.stax.StaksBuilderKt;
import com.xorrus.common.kotlin.stax.StartDocumentHandler;
import com.xorrus.common.kotlin.stax.StaxBuilder;
import com.xorrus.common.kotlin.stax.XBigNumHandler;
import com.xorrus.common.kotlin.stax.XBigNumOrNullHandler;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Right;
import com.xorrus.trading.lot.ib.flex.tradeconfirmation.xml.FlexQueryResponse;
import com.xorrus.trading.lot.ib.flex.tradeconfirmation.xml.FlexStatement;
import com.xorrus.trading.lot.ib.flex.tradeconfirmation.xml.FlexStatements;
import com.xorrus.trading.lot.ib.flex.tradeconfirmation.xml.Order;
import com.xorrus.trading.lot.ib.flex.tradeconfirmation.xml.SymbolSummary;
import com.xorrus.trading.lot.ib.flex.tradeconfirmation.xml.TradeConfirm;
import com.xorrus.trading.lot.ib.flex.tradeconfirmation.xml.TradeConfirms;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000b*\u0006\u0012\u0002\b\u00030\fH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/TradeConfirmationXmlParser;", "", "<init>", "()V", "parse", "Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/xml/FlexQueryResponse;", "inputStream", "Ljava/io/InputStream;", "strict", "", "defDocument", "Lkotlin/Function0;", "Lcom/xorrus/common/kotlin/stax/CompoundHandler;", "defFlexQueryResponse", "defFlexStatements", "Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/xml/FlexStatements;", "defFlexStatement", "Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/xml/FlexStatement;", "defTradeConfirms", "Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/xml/TradeConfirms;", "defOrder", "Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/xml/Order;", "defSymbolSummary", "Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/xml/SymbolSummary;", "defTradeConfirm", "Lcom/xorrus/trading/lot/ib/flex/tradeconfirmation/xml/TradeConfirm;", "laboftrades-ib"})
@SourceDebugExtension(value={"SMAP\nTradeConfirmationXmlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeConfirmationXmlParser.kt\ncom/xorrus/trading/lot/ib/flex/tradeconfirmation/TradeConfirmationXmlParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,523:1\n1#2:524\n*E\n"})
public final class TradeConfirmationXmlParser {
    @NotNull
    public static final TradeConfirmationXmlParser INSTANCE = new TradeConfirmationXmlParser();

    private TradeConfirmationXmlParser() {
    }

    @NotNull
    public final FlexQueryResponse parse(@NotNull InputStream inputStream, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return (FlexQueryResponse)StaksBuilderKt.staks(inputStream, strict, TradeConfirmationXmlParser::parse$lambda$0);
    }

    private final Function0<FlexQueryResponse> defDocument(CompoundHandler<?> $this$defDocument) {
        StartDocumentHandler flexQueryResponse = StaksBuilderKt.startDocument($this$defDocument, TradeConfirmationXmlParser::defDocument$lambda$0);
        return () -> TradeConfirmationXmlParser.defDocument$lambda$1(flexQueryResponse);
    }

    private final Function0<FlexQueryResponse> defFlexQueryResponse(CompoundHandler<?> $this$defFlexQueryResponse) {
        CurrentAttrHandler queryName = StaksBuilderKt.attribute($this$defFlexQueryResponse, "queryName");
        CurrentAttrHandler type = StaksBuilderKt.attribute($this$defFlexQueryResponse, "type");
        SingleHandler flexStatements = StaksBuilderKt.single($this$defFlexQueryResponse, "FlexStatements", TradeConfirmationXmlParser::defFlexQueryResponse$lambda$0);
        return () -> TradeConfirmationXmlParser.defFlexQueryResponse$lambda$1(queryName, type, flexStatements);
    }

    private final Function0<FlexStatements> defFlexStatements(CompoundHandler<?> $this$defFlexStatements) {
        IntHandler count = $this$defFlexStatements.toInt(StaksBuilderKt.attribute($this$defFlexStatements, "count"));
        ListHandler flexStatements = StaksBuilderKt.list($this$defFlexStatements, "FlexStatement", TradeConfirmationXmlParser::defFlexStatements$lambda$0);
        return () -> TradeConfirmationXmlParser.defFlexStatements$lambda$1(count, flexStatements);
    }

    private final Function0<FlexStatement> defFlexStatement(CompoundHandler<?> $this$defFlexStatement) {
        CurrentAttrHandler accountId = StaksBuilderKt.attribute($this$defFlexStatement, "accountId");
        LocalDateHandler fromDate = $this$defFlexStatement.toLocalDate(StaksBuilderKt.attribute($this$defFlexStatement, "fromDate"));
        LocalDateHandler toDate = $this$defFlexStatement.toLocalDate(StaksBuilderKt.attribute($this$defFlexStatement, "toDate"));
        CurrentAttrHandler period = StaksBuilderKt.attribute($this$defFlexStatement, "period");
        LocalDateTimeHandler whenGenerated = $this$defFlexStatement.toLocalDateTime(StaksBuilderKt.attribute($this$defFlexStatement, "whenGenerated"));
        OptionalHandler defTradeConfirms = $this$defFlexStatement.optional(StaksBuilderKt.single($this$defFlexStatement, "TradeConfirms", TradeConfirmationXmlParser::defFlexStatement$lambda$0));
        return () -> TradeConfirmationXmlParser.defFlexStatement$lambda$1(accountId, fromDate, toDate, period, whenGenerated, defTradeConfirms);
    }

    private final Function0<TradeConfirms> defTradeConfirms(CompoundHandler<?> $this$defTradeConfirms) {
        OptionalHandler orders = $this$defTradeConfirms.optional(StaksBuilderKt.list($this$defTradeConfirms, "Order", TradeConfirmationXmlParser::defTradeConfirms$lambda$0));
        OptionalHandler symbolSummaries = $this$defTradeConfirms.optional(StaksBuilderKt.list($this$defTradeConfirms, "SymbolSummary", TradeConfirmationXmlParser::defTradeConfirms$lambda$1));
        OptionalHandler tradeConfirms = $this$defTradeConfirms.optional(StaksBuilderKt.list($this$defTradeConfirms, "TradeConfirm", TradeConfirmationXmlParser::defTradeConfirms$lambda$2));
        return () -> TradeConfirmationXmlParser.defTradeConfirms$lambda$3(orders, symbolSummaries, tradeConfirms);
    }

    private final Function0<Order> defOrder(CompoundHandler<?> $this$defOrder) {
        CurrentAttrHandler accountId = StaksBuilderKt.attribute($this$defOrder, "accountId");
        CurrentAttrHandler acctAlias = StaksBuilderKt.attribute($this$defOrder, "acctAlias");
        CurrentAttrHandler model = StaksBuilderKt.attribute($this$defOrder, "model");
        CurrentAttrHandler currency = StaksBuilderKt.attribute($this$defOrder, "currency");
        CurrentAttrHandler assetCategory = StaksBuilderKt.attribute($this$defOrder, "assetCategory");
        CurrentAttrHandler subCategory = StaksBuilderKt.attribute($this$defOrder, "subCategory");
        CurrentAttrHandler symbol = StaksBuilderKt.attribute($this$defOrder, "symbol");
        CurrentAttrHandler description = StaksBuilderKt.attribute($this$defOrder, "description");
        CurrentAttrHandler conid = StaksBuilderKt.attribute($this$defOrder, "conid");
        CurrentAttrHandler securityID = StaksBuilderKt.attribute($this$defOrder, "securityID");
        CurrentAttrHandler securityIDType = StaksBuilderKt.attribute($this$defOrder, "securityIDType");
        CurrentAttrHandler cusip = StaksBuilderKt.attribute($this$defOrder, "cusip");
        CurrentAttrHandler isin = StaksBuilderKt.attribute($this$defOrder, "isin");
        CurrentAttrHandler figi = StaksBuilderKt.attribute($this$defOrder, "figi");
        CurrentAttrHandler listingExchange = StaksBuilderKt.attribute($this$defOrder, "listingExchange");
        CurrentAttrHandler underlyingConid = StaksBuilderKt.attribute($this$defOrder, "underlyingConid");
        CurrentAttrHandler underlyingSymbol = StaksBuilderKt.attribute($this$defOrder, "underlyingSymbol");
        CurrentAttrHandler underlyingSecurityID = StaksBuilderKt.attribute($this$defOrder, "underlyingSecurityID");
        CurrentAttrHandler underlyingListingExchange = StaksBuilderKt.attribute($this$defOrder, "underlyingListingExchange");
        CurrentAttrHandler issuer = StaksBuilderKt.attribute($this$defOrder, "issuer");
        CurrentAttrHandler issuerCountryCode = StaksBuilderKt.attribute($this$defOrder, "issuerCountryCode");
        CurrentAttrHandler multiplier = StaksBuilderKt.attribute($this$defOrder, "multiplier");
        CurrentAttrHandler strike = StaksBuilderKt.attribute($this$defOrder, "strike");
        CurrentAttrHandler expiry = StaksBuilderKt.attribute($this$defOrder, "expiry");
        CurrentAttrHandler putCall = StaksBuilderKt.attribute($this$defOrder, "putCall");
        CurrentAttrHandler principalAdjustFactor = StaksBuilderKt.attribute($this$defOrder, "principalAdjustFactor");
        CurrentAttrHandler transactionType = StaksBuilderKt.attribute($this$defOrder, "transactionType");
        CurrentAttrHandler tradeID = StaksBuilderKt.attribute($this$defOrder, "tradeID");
        CurrentAttrHandler orderID = StaksBuilderKt.attribute($this$defOrder, "orderID");
        CurrentAttrHandler execID = StaksBuilderKt.attribute($this$defOrder, "execID");
        CurrentAttrHandler brokerageOrderID = StaksBuilderKt.attribute($this$defOrder, "brokerageOrderID");
        CurrentAttrHandler orderReference = StaksBuilderKt.attribute($this$defOrder, "orderReference");
        CurrentAttrHandler volatilityOrderLink = StaksBuilderKt.attribute($this$defOrder, "volatilityOrderLink");
        CurrentAttrHandler clearingFirmID = StaksBuilderKt.attribute($this$defOrder, "clearingFirmID");
        CurrentAttrHandler origTradePrice = StaksBuilderKt.attribute($this$defOrder, "origTradePrice");
        CurrentAttrHandler origTradeDate = StaksBuilderKt.attribute($this$defOrder, "origTradeDate");
        CurrentAttrHandler origTradeID = StaksBuilderKt.attribute($this$defOrder, "origTradeID");
        CurrentAttrHandler extExecID = StaksBuilderKt.attribute($this$defOrder, "extExecID");
        CurrentAttrHandler blockID = StaksBuilderKt.attribute($this$defOrder, "blockID");
        CurrentAttrHandler orderTime = StaksBuilderKt.attribute($this$defOrder, "orderTime");
        CurrentAttrHandler dateTime = StaksBuilderKt.attribute($this$defOrder, "dateTime");
        CurrentAttrHandler reportDate = StaksBuilderKt.attribute($this$defOrder, "reportDate");
        CurrentAttrHandler settleDate = StaksBuilderKt.attribute($this$defOrder, "settleDate");
        CurrentAttrHandler tradeDate = StaksBuilderKt.attribute($this$defOrder, "tradeDate");
        CurrentAttrHandler exchange = StaksBuilderKt.attribute($this$defOrder, "exchange");
        CurrentAttrHandler buySell = StaksBuilderKt.attribute($this$defOrder, "buySell");
        CurrentAttrHandler quantity = StaksBuilderKt.attribute($this$defOrder, "quantity");
        CurrentAttrHandler price = StaksBuilderKt.attribute($this$defOrder, "price");
        CurrentAttrHandler amount = StaksBuilderKt.attribute($this$defOrder, "amount");
        CurrentAttrHandler proceeds = StaksBuilderKt.attribute($this$defOrder, "proceeds");
        CurrentAttrHandler netCash = StaksBuilderKt.attribute($this$defOrder, "netCash");
        CurrentAttrHandler netCashWithBillable = StaksBuilderKt.attribute($this$defOrder, "netCashWithBillable");
        CurrentAttrHandler commission = StaksBuilderKt.attribute($this$defOrder, "commission");
        CurrentAttrHandler brokerExecutionCommission = StaksBuilderKt.attribute($this$defOrder, "brokerExecutionCommission");
        CurrentAttrHandler brokerClearingCommission = StaksBuilderKt.attribute($this$defOrder, "brokerClearingCommission");
        CurrentAttrHandler thirdPartyExecutionCommission = StaksBuilderKt.attribute($this$defOrder, "thirdPartyExecutionCommission");
        CurrentAttrHandler thirdPartyClearingCommission = StaksBuilderKt.attribute($this$defOrder, "thirdPartyClearingCommission");
        CurrentAttrHandler thirdPartyRegulatoryCommission = StaksBuilderKt.attribute($this$defOrder, "thirdPartyRegulatoryCommission");
        CurrentAttrHandler otherCommission = StaksBuilderKt.attribute($this$defOrder, "otherCommission");
        CurrentAttrHandler commissionCurrency = StaksBuilderKt.attribute($this$defOrder, "commissionCurrency");
        CurrentAttrHandler tax = StaksBuilderKt.attribute($this$defOrder, "tax");
        CurrentAttrHandler code = StaksBuilderKt.attribute($this$defOrder, "code");
        CurrentAttrHandler orderType = StaksBuilderKt.attribute($this$defOrder, "orderType");
        CurrentAttrHandler levelOfDetail = StaksBuilderKt.attribute($this$defOrder, "levelOfDetail");
        CurrentAttrHandler traderID = StaksBuilderKt.attribute($this$defOrder, "traderID");
        CurrentAttrHandler isAPIOrder = StaksBuilderKt.attribute($this$defOrder, "isAPIOrder");
        CurrentAttrHandler allocatedTo = StaksBuilderKt.attribute($this$defOrder, "allocatedTo");
        CurrentAttrHandler accruedInt = StaksBuilderKt.attribute($this$defOrder, "accruedInt");
        CurrentAttrHandler rfqID = StaksBuilderKt.attribute($this$defOrder, "rfqID");
        CurrentAttrHandler serialNumber = StaksBuilderKt.attribute($this$defOrder, "serialNumber");
        CurrentAttrHandler deliveryType = StaksBuilderKt.attribute($this$defOrder, "deliveryType");
        CurrentAttrHandler commodityType = StaksBuilderKt.attribute($this$defOrder, "commodityType");
        CurrentAttrHandler fineness = StaksBuilderKt.attribute($this$defOrder, "fineness");
        CurrentAttrHandler weight = StaksBuilderKt.attribute($this$defOrder, "weight");
        return () -> TradeConfirmationXmlParser.defOrder$lambda$0(accountId, acctAlias, model, currency, assetCategory, subCategory, symbol, description, conid, securityID, securityIDType, cusip, isin, figi, listingExchange, underlyingConid, underlyingSymbol, underlyingSecurityID, underlyingListingExchange, issuer, issuerCountryCode, multiplier, strike, expiry, putCall, principalAdjustFactor, transactionType, tradeID, orderID, execID, brokerageOrderID, orderReference, volatilityOrderLink, clearingFirmID, origTradePrice, origTradeDate, origTradeID, extExecID, blockID, orderTime, dateTime, reportDate, settleDate, tradeDate, exchange, buySell, quantity, price, amount, proceeds, netCash, netCashWithBillable, commission, brokerExecutionCommission, brokerClearingCommission, thirdPartyExecutionCommission, thirdPartyClearingCommission, thirdPartyRegulatoryCommission, otherCommission, commissionCurrency, tax, code, orderType, levelOfDetail, traderID, isAPIOrder, allocatedTo, accruedInt, rfqID, serialNumber, deliveryType, commodityType, fineness, weight);
    }

    private final Function0<SymbolSummary> defSymbolSummary(CompoundHandler<?> $this$defSymbolSummary) {
        CurrentAttrHandler accountId = StaksBuilderKt.attribute($this$defSymbolSummary, "accountId");
        CurrentAttrHandler acctAlias = StaksBuilderKt.attribute($this$defSymbolSummary, "acctAlias");
        CurrentAttrHandler model = StaksBuilderKt.attribute($this$defSymbolSummary, "model");
        CurrentAttrHandler currency = StaksBuilderKt.attribute($this$defSymbolSummary, "currency");
        CurrentAttrHandler assetCategory = StaksBuilderKt.attribute($this$defSymbolSummary, "assetCategory");
        CurrentAttrHandler subCategory = StaksBuilderKt.attribute($this$defSymbolSummary, "subCategory");
        CurrentAttrHandler symbol = StaksBuilderKt.attribute($this$defSymbolSummary, "symbol");
        CurrentAttrHandler description = StaksBuilderKt.attribute($this$defSymbolSummary, "description");
        IntHandler conid = $this$defSymbolSummary.toInt(StaksBuilderKt.attribute($this$defSymbolSummary, "conid"));
        CurrentAttrHandler securityID = StaksBuilderKt.attribute($this$defSymbolSummary, "securityID");
        CurrentAttrHandler securityIDType = StaksBuilderKt.attribute($this$defSymbolSummary, "securityIDType");
        CurrentAttrHandler cusip = StaksBuilderKt.attribute($this$defSymbolSummary, "cusip");
        CurrentAttrHandler isin = StaksBuilderKt.attribute($this$defSymbolSummary, "isin");
        CurrentAttrHandler figi = StaksBuilderKt.attribute($this$defSymbolSummary, "figi");
        CurrentAttrHandler listingExchange = StaksBuilderKt.attribute($this$defSymbolSummary, "listingExchange");
        IntOrNullHandler underlyingConid = $this$defSymbolSummary.toIntOrNull(StaksBuilderKt.attribute($this$defSymbolSummary, "underlyingConid"));
        CurrentAttrHandler underlyingSymbol = StaksBuilderKt.attribute($this$defSymbolSummary, "underlyingSymbol");
        CurrentAttrHandler underlyingSecurityID = StaksBuilderKt.attribute($this$defSymbolSummary, "underlyingSecurityID");
        CurrentAttrHandler underlyingListingExchange = StaksBuilderKt.attribute($this$defSymbolSummary, "underlyingListingExchange");
        CurrentAttrHandler issuer = StaksBuilderKt.attribute($this$defSymbolSummary, "issuer");
        CurrentAttrHandler issuerCountryCode = StaksBuilderKt.attribute($this$defSymbolSummary, "issuerCountryCode");
        XBigNumHandler multiplier = $this$defSymbolSummary.toXBigNum(StaksBuilderKt.attribute($this$defSymbolSummary, "multiplier"));
        XBigNumOrNullHandler strike = $this$defSymbolSummary.toXBigNumOrNull(StaksBuilderKt.attribute($this$defSymbolSummary, "strike"));
        LocalDateOrNullHandler expiry = $this$defSymbolSummary.toLocalDateOrNull(StaksBuilderKt.attribute($this$defSymbolSummary, "expiry"));
        CustomTypeHandler<Right> putCall = $this$defSymbolSummary.toRight(StaksBuilderKt.attribute($this$defSymbolSummary, "putCall"));
        CurrentAttrHandler principalAdjustFactor = StaksBuilderKt.attribute($this$defSymbolSummary, "principalAdjustFactor");
        CurrentAttrHandler transactionType = StaksBuilderKt.attribute($this$defSymbolSummary, "transactionType");
        CurrentAttrHandler tradeID = StaksBuilderKt.attribute($this$defSymbolSummary, "tradeID");
        CurrentAttrHandler orderID = StaksBuilderKt.attribute($this$defSymbolSummary, "orderID");
        CurrentAttrHandler execID = StaksBuilderKt.attribute($this$defSymbolSummary, "execID");
        CurrentAttrHandler brokerageOrderID = StaksBuilderKt.attribute($this$defSymbolSummary, "brokerageOrderID");
        CurrentAttrHandler orderReference = StaksBuilderKt.attribute($this$defSymbolSummary, "orderReference");
        CurrentAttrHandler volatilityOrderLink = StaksBuilderKt.attribute($this$defSymbolSummary, "volatilityOrderLink");
        CurrentAttrHandler clearingFirmID = StaksBuilderKt.attribute($this$defSymbolSummary, "clearingFirmID");
        CurrentAttrHandler origTradePrice = StaksBuilderKt.attribute($this$defSymbolSummary, "origTradePrice");
        CurrentAttrHandler origTradeDate = StaksBuilderKt.attribute($this$defSymbolSummary, "origTradeDate");
        CurrentAttrHandler origTradeID = StaksBuilderKt.attribute($this$defSymbolSummary, "origTradeID");
        CurrentAttrHandler extExecID = StaksBuilderKt.attribute($this$defSymbolSummary, "extExecID");
        CurrentAttrHandler blockID = StaksBuilderKt.attribute($this$defSymbolSummary, "blockID");
        CurrentAttrHandler orderTime = StaksBuilderKt.attribute($this$defSymbolSummary, "orderTime");
        CurrentAttrHandler dateTime = StaksBuilderKt.attribute($this$defSymbolSummary, "dateTime");
        CurrentAttrHandler reportDate = StaksBuilderKt.attribute($this$defSymbolSummary, "reportDate");
        CurrentAttrHandler settleDate = StaksBuilderKt.attribute($this$defSymbolSummary, "settleDate");
        CurrentAttrHandler tradeDate = StaksBuilderKt.attribute($this$defSymbolSummary, "tradeDate");
        CurrentAttrHandler exchange = StaksBuilderKt.attribute($this$defSymbolSummary, "exchange");
        CurrentAttrHandler buySell = StaksBuilderKt.attribute($this$defSymbolSummary, "buySell");
        CurrentAttrHandler quantity = StaksBuilderKt.attribute($this$defSymbolSummary, "quantity");
        CurrentAttrHandler price = StaksBuilderKt.attribute($this$defSymbolSummary, "price");
        CurrentAttrHandler amount = StaksBuilderKt.attribute($this$defSymbolSummary, "amount");
        CurrentAttrHandler proceeds = StaksBuilderKt.attribute($this$defSymbolSummary, "proceeds");
        CurrentAttrHandler netCash = StaksBuilderKt.attribute($this$defSymbolSummary, "netCash");
        CurrentAttrHandler netCashWithBillable = StaksBuilderKt.attribute($this$defSymbolSummary, "netCashWithBillable");
        CurrentAttrHandler commission = StaksBuilderKt.attribute($this$defSymbolSummary, "commission");
        CurrentAttrHandler brokerExecutionCommission = StaksBuilderKt.attribute($this$defSymbolSummary, "brokerExecutionCommission");
        CurrentAttrHandler brokerClearingCommission = StaksBuilderKt.attribute($this$defSymbolSummary, "brokerClearingCommission");
        CurrentAttrHandler thirdPartyExecutionCommission = StaksBuilderKt.attribute($this$defSymbolSummary, "thirdPartyExecutionCommission");
        CurrentAttrHandler thirdPartyClearingCommission = StaksBuilderKt.attribute($this$defSymbolSummary, "thirdPartyClearingCommission");
        CurrentAttrHandler thirdPartyRegulatoryCommission = StaksBuilderKt.attribute($this$defSymbolSummary, "thirdPartyRegulatoryCommission");
        CurrentAttrHandler otherCommission = StaksBuilderKt.attribute($this$defSymbolSummary, "otherCommission");
        CurrentAttrHandler commissionCurrency = StaksBuilderKt.attribute($this$defSymbolSummary, "commissionCurrency");
        CurrentAttrHandler tax = StaksBuilderKt.attribute($this$defSymbolSummary, "tax");
        CurrentAttrHandler code = StaksBuilderKt.attribute($this$defSymbolSummary, "code");
        CurrentAttrHandler orderType = StaksBuilderKt.attribute($this$defSymbolSummary, "orderType");
        CurrentAttrHandler levelOfDetail = StaksBuilderKt.attribute($this$defSymbolSummary, "levelOfDetail");
        CurrentAttrHandler traderID = StaksBuilderKt.attribute($this$defSymbolSummary, "traderID");
        CurrentAttrHandler isAPIOrder = StaksBuilderKt.attribute($this$defSymbolSummary, "isAPIOrder");
        CurrentAttrHandler allocatedTo = StaksBuilderKt.attribute($this$defSymbolSummary, "allocatedTo");
        CurrentAttrHandler accruedInt = StaksBuilderKt.attribute($this$defSymbolSummary, "accruedInt");
        CurrentAttrHandler rfqID = StaksBuilderKt.attribute($this$defSymbolSummary, "rfqID");
        CurrentAttrHandler serialNumber = StaksBuilderKt.attribute($this$defSymbolSummary, "serialNumber");
        CurrentAttrHandler deliveryType = StaksBuilderKt.attribute($this$defSymbolSummary, "deliveryType");
        CurrentAttrHandler commodityType = StaksBuilderKt.attribute($this$defSymbolSummary, "commodityType");
        CurrentAttrHandler fineness = StaksBuilderKt.attribute($this$defSymbolSummary, "fineness");
        CurrentAttrHandler weight = StaksBuilderKt.attribute($this$defSymbolSummary, "weight");
        return () -> TradeConfirmationXmlParser.defSymbolSummary$lambda$0(accountId, acctAlias, model, currency, assetCategory, subCategory, symbol, description, conid, securityID, securityIDType, cusip, isin, figi, listingExchange, underlyingConid, underlyingSymbol, underlyingSecurityID, underlyingListingExchange, issuer, issuerCountryCode, multiplier, strike, expiry, putCall, principalAdjustFactor, transactionType, tradeID, orderID, execID, brokerageOrderID, orderReference, volatilityOrderLink, clearingFirmID, origTradePrice, origTradeDate, origTradeID, extExecID, blockID, orderTime, dateTime, reportDate, settleDate, tradeDate, exchange, buySell, quantity, price, amount, proceeds, netCash, netCashWithBillable, commission, brokerExecutionCommission, brokerClearingCommission, thirdPartyExecutionCommission, thirdPartyClearingCommission, thirdPartyRegulatoryCommission, otherCommission, commissionCurrency, tax, code, orderType, levelOfDetail, traderID, isAPIOrder, allocatedTo, accruedInt, rfqID, serialNumber, deliveryType, commodityType, fineness, weight);
    }

    private final Function0<TradeConfirm> defTradeConfirm(CompoundHandler<?> $this$defTradeConfirm) {
        CurrentAttrHandler accountId = StaksBuilderKt.attribute($this$defTradeConfirm, "accountId");
        CurrentAttrHandler acctAlias = StaksBuilderKt.attribute($this$defTradeConfirm, "acctAlias");
        CurrentAttrHandler model = StaksBuilderKt.attribute($this$defTradeConfirm, "model");
        CurrentAttrHandler currency = StaksBuilderKt.attribute($this$defTradeConfirm, "currency");
        CurrentAttrHandler assetCategory = StaksBuilderKt.attribute($this$defTradeConfirm, "assetCategory");
        CurrentAttrHandler subCategory = StaksBuilderKt.attribute($this$defTradeConfirm, "subCategory");
        CurrentAttrHandler symbol = StaksBuilderKt.attribute($this$defTradeConfirm, "symbol");
        CurrentAttrHandler description = StaksBuilderKt.attribute($this$defTradeConfirm, "description");
        IntHandler conid = $this$defTradeConfirm.toInt(StaksBuilderKt.attribute($this$defTradeConfirm, "conid"));
        CurrentAttrHandler securityID = StaksBuilderKt.attribute($this$defTradeConfirm, "securityID");
        CurrentAttrHandler securityIDType = StaksBuilderKt.attribute($this$defTradeConfirm, "securityIDType");
        CurrentAttrHandler cusip = StaksBuilderKt.attribute($this$defTradeConfirm, "cusip");
        CurrentAttrHandler isin = StaksBuilderKt.attribute($this$defTradeConfirm, "isin");
        CurrentAttrHandler figi = StaksBuilderKt.attribute($this$defTradeConfirm, "figi");
        CurrentAttrHandler listingExchange = StaksBuilderKt.attribute($this$defTradeConfirm, "listingExchange");
        IntOrNullHandler underlyingConid = $this$defTradeConfirm.toIntOrNull(StaksBuilderKt.attribute($this$defTradeConfirm, "underlyingConid"));
        CurrentAttrHandler underlyingSymbol = StaksBuilderKt.attribute($this$defTradeConfirm, "underlyingSymbol");
        CurrentAttrHandler underlyingSecurityID = StaksBuilderKt.attribute($this$defTradeConfirm, "underlyingSecurityID");
        CurrentAttrHandler underlyingListingExchange = StaksBuilderKt.attribute($this$defTradeConfirm, "underlyingListingExchange");
        CurrentAttrHandler issuer = StaksBuilderKt.attribute($this$defTradeConfirm, "issuer");
        CurrentAttrHandler issuerCountryCode = StaksBuilderKt.attribute($this$defTradeConfirm, "issuerCountryCode");
        XBigNumHandler multiplier = $this$defTradeConfirm.toXBigNum(StaksBuilderKt.attribute($this$defTradeConfirm, "multiplier"));
        OptionalHandler strike = $this$defTradeConfirm.optional($this$defTradeConfirm.toXBigNum(StaksBuilderKt.attribute($this$defTradeConfirm, "strike")));
        CurrentAttrHandler expiry = StaksBuilderKt.attribute($this$defTradeConfirm, "expiry");
        CustomTypeHandler<?> putCall = $this$defTradeConfirm.custom(StaksBuilderKt.attribute($this$defTradeConfirm, "putCall"), TradeConfirmationXmlParser::defTradeConfirm$lambda$0);
        CurrentAttrHandler principalAdjustFactor = StaksBuilderKt.attribute($this$defTradeConfirm, "principalAdjustFactor");
        CurrentAttrHandler transactionType = StaksBuilderKt.attribute($this$defTradeConfirm, "transactionType");
        CurrentAttrHandler tradeID = StaksBuilderKt.attribute($this$defTradeConfirm, "tradeID");
        CurrentAttrHandler orderID = StaksBuilderKt.attribute($this$defTradeConfirm, "orderID");
        CurrentAttrHandler execID = StaksBuilderKt.attribute($this$defTradeConfirm, "execID");
        CurrentAttrHandler brokerageOrderID = StaksBuilderKt.attribute($this$defTradeConfirm, "brokerageOrderID");
        CurrentAttrHandler orderReference = StaksBuilderKt.attribute($this$defTradeConfirm, "orderReference");
        CurrentAttrHandler volatilityOrderLink = StaksBuilderKt.attribute($this$defTradeConfirm, "volatilityOrderLink");
        CurrentAttrHandler clearingFirmID = StaksBuilderKt.attribute($this$defTradeConfirm, "clearingFirmID");
        CurrentAttrHandler origTradePrice = StaksBuilderKt.attribute($this$defTradeConfirm, "origTradePrice");
        CurrentAttrHandler origTradeDate = StaksBuilderKt.attribute($this$defTradeConfirm, "origTradeDate");
        CurrentAttrHandler origTradeID = StaksBuilderKt.attribute($this$defTradeConfirm, "origTradeID");
        CurrentAttrHandler extExecID = StaksBuilderKt.attribute($this$defTradeConfirm, "extExecID");
        CurrentAttrHandler blockID = StaksBuilderKt.attribute($this$defTradeConfirm, "blockID");
        CurrentAttrHandler orderTime = StaksBuilderKt.attribute($this$defTradeConfirm, "orderTime");
        InstantWithFlexDefaultTimeZoneHandler dateTime = $this$defTradeConfirm.toInstantWithFlexDefaultTimeZone($this$defTradeConfirm.toLocalDateTime(StaksBuilderKt.attribute($this$defTradeConfirm, "dateTime")));
        CurrentAttrHandler reportDate = StaksBuilderKt.attribute($this$defTradeConfirm, "reportDate");
        CurrentAttrHandler settleDate = StaksBuilderKt.attribute($this$defTradeConfirm, "settleDate");
        CurrentAttrHandler tradeDate = StaksBuilderKt.attribute($this$defTradeConfirm, "tradeDate");
        CurrentAttrHandler exchange = StaksBuilderKt.attribute($this$defTradeConfirm, "exchange");
        CurrentAttrHandler buySell = StaksBuilderKt.attribute($this$defTradeConfirm, "buySell");
        XBigNumHandler quantity = $this$defTradeConfirm.toXBigNum(StaksBuilderKt.attribute($this$defTradeConfirm, "quantity"));
        XBigNumHandler price = $this$defTradeConfirm.toXBigNum(StaksBuilderKt.attribute($this$defTradeConfirm, "price"));
        CurrentAttrHandler amount = StaksBuilderKt.attribute($this$defTradeConfirm, "amount");
        CurrentAttrHandler proceeds = StaksBuilderKt.attribute($this$defTradeConfirm, "proceeds");
        CurrentAttrHandler netCash = StaksBuilderKt.attribute($this$defTradeConfirm, "netCash");
        CurrentAttrHandler netCashWithBillable = StaksBuilderKt.attribute($this$defTradeConfirm, "netCashWithBillable");
        XBigNumHandler commission = $this$defTradeConfirm.toXBigNum(StaksBuilderKt.attribute($this$defTradeConfirm, "commission"));
        CurrentAttrHandler brokerExecutionCommission = StaksBuilderKt.attribute($this$defTradeConfirm, "brokerExecutionCommission");
        CurrentAttrHandler brokerClearingCommission = StaksBuilderKt.attribute($this$defTradeConfirm, "brokerClearingCommission");
        CurrentAttrHandler thirdPartyExecutionCommission = StaksBuilderKt.attribute($this$defTradeConfirm, "thirdPartyExecutionCommission");
        CurrentAttrHandler thirdPartyClearingCommission = StaksBuilderKt.attribute($this$defTradeConfirm, "thirdPartyClearingCommission");
        CurrentAttrHandler thirdPartyRegulatoryCommission = StaksBuilderKt.attribute($this$defTradeConfirm, "thirdPartyRegulatoryCommission");
        CurrentAttrHandler otherCommission = StaksBuilderKt.attribute($this$defTradeConfirm, "otherCommission");
        CurrentAttrHandler commissionCurrency = StaksBuilderKt.attribute($this$defTradeConfirm, "commissionCurrency");
        CurrentAttrHandler tax = StaksBuilderKt.attribute($this$defTradeConfirm, "tax");
        CurrentAttrHandler code = StaksBuilderKt.attribute($this$defTradeConfirm, "code");
        CurrentAttrHandler orderType = StaksBuilderKt.attribute($this$defTradeConfirm, "orderType");
        CurrentAttrHandler levelOfDetail = StaksBuilderKt.attribute($this$defTradeConfirm, "levelOfDetail");
        CurrentAttrHandler traderID = StaksBuilderKt.attribute($this$defTradeConfirm, "traderID");
        CurrentAttrHandler isAPIOrder = StaksBuilderKt.attribute($this$defTradeConfirm, "isAPIOrder");
        CurrentAttrHandler allocatedTo = StaksBuilderKt.attribute($this$defTradeConfirm, "allocatedTo");
        CurrentAttrHandler accruedInt = StaksBuilderKt.attribute($this$defTradeConfirm, "accruedInt");
        CurrentAttrHandler rfqID = StaksBuilderKt.attribute($this$defTradeConfirm, "rfqID");
        CurrentAttrHandler serialNumber = StaksBuilderKt.attribute($this$defTradeConfirm, "serialNumber");
        CurrentAttrHandler deliveryType = StaksBuilderKt.attribute($this$defTradeConfirm, "deliveryType");
        CurrentAttrHandler commodityType = StaksBuilderKt.attribute($this$defTradeConfirm, "commodityType");
        CurrentAttrHandler fineness = StaksBuilderKt.attribute($this$defTradeConfirm, "fineness");
        CurrentAttrHandler weight = StaksBuilderKt.attribute($this$defTradeConfirm, "weight");
        return () -> TradeConfirmationXmlParser.defTradeConfirm$lambda$1(accountId, acctAlias, model, currency, assetCategory, subCategory, symbol, description, conid, securityID, securityIDType, cusip, isin, figi, listingExchange, underlyingConid, underlyingSymbol, underlyingSecurityID, underlyingListingExchange, issuer, issuerCountryCode, multiplier, strike, expiry, putCall, principalAdjustFactor, transactionType, tradeID, orderID, execID, brokerageOrderID, orderReference, volatilityOrderLink, clearingFirmID, origTradePrice, origTradeDate, origTradeID, extExecID, blockID, orderTime, dateTime, reportDate, settleDate, tradeDate, exchange, buySell, quantity, price, amount, proceeds, netCash, netCashWithBillable, commission, brokerExecutionCommission, brokerClearingCommission, thirdPartyExecutionCommission, thirdPartyClearingCommission, thirdPartyRegulatoryCommission, otherCommission, commissionCurrency, tax, code, orderType, levelOfDetail, traderID, isAPIOrder, allocatedTo, accruedInt, rfqID, serialNumber, deliveryType, commodityType, fineness, weight);
    }

    private static final Function0 parse$lambda$0(StaxBuilder $this$staks) {
        Intrinsics.checkNotNullParameter((Object)$this$staks, (String)"$this$staks");
        return INSTANCE.defDocument($this$staks);
    }

    private static final Function0 defDocument$lambda$0(CompoundHandler $this$startDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$startDocument, (String)"$this$startDocument");
        SingleHandler flexQueryResponse = StaksBuilderKt.single($this$startDocument, "FlexQueryResponse", TradeConfirmationXmlParser::defDocument$lambda$0$0);
        return () -> TradeConfirmationXmlParser.defDocument$lambda$0$1(flexQueryResponse);
    }

    private static final Function0 defDocument$lambda$0$0(CompoundHandler $this$single) {
        Intrinsics.checkNotNullParameter((Object)$this$single, (String)"$this$single");
        return INSTANCE.defFlexQueryResponse($this$single);
    }

    private static final FlexQueryResponse defDocument$lambda$0$1(SingleHandler $flexQueryResponse) {
        return (FlexQueryResponse)$flexQueryResponse.invoke();
    }

    private static final FlexQueryResponse defDocument$lambda$1(StartDocumentHandler $flexQueryResponse) {
        return (FlexQueryResponse)$flexQueryResponse.invoke();
    }

    private static final Function0 defFlexQueryResponse$lambda$0(CompoundHandler $this$single) {
        Intrinsics.checkNotNullParameter((Object)$this$single, (String)"$this$single");
        return INSTANCE.defFlexStatements($this$single);
    }

    private static final FlexQueryResponse defFlexQueryResponse$lambda$1(CurrentAttrHandler $queryName, CurrentAttrHandler $type, SingleHandler $flexStatements) {
        return new FlexQueryResponse((String)$queryName.invoke(), (String)$type.invoke(), (FlexStatements)$flexStatements.invoke());
    }

    private static final Function0 defFlexStatements$lambda$0(CompoundHandler $this$list) {
        Intrinsics.checkNotNullParameter((Object)$this$list, (String)"$this$list");
        return INSTANCE.defFlexStatement($this$list);
    }

    private static final FlexStatements defFlexStatements$lambda$1(IntHandler $count, ListHandler $flexStatements) {
        return new FlexStatements(((Number)$count.invoke()).intValue(), (List)$flexStatements.invoke());
    }

    private static final Function0 defFlexStatement$lambda$0(CompoundHandler $this$single) {
        Intrinsics.checkNotNullParameter((Object)$this$single, (String)"$this$single");
        return INSTANCE.defTradeConfirms($this$single);
    }

    private static final FlexStatement defFlexStatement$lambda$1(CurrentAttrHandler $accountId, LocalDateHandler $fromDate, LocalDateHandler $toDate, CurrentAttrHandler $period, LocalDateTimeHandler $whenGenerated, OptionalHandler $defTradeConfirms) {
        return new FlexStatement((String)$accountId.invoke(), (LocalDate)$fromDate.invoke(), (LocalDate)$toDate.invoke(), (String)$period.invoke(), (LocalDateTime)$whenGenerated.invoke(), (TradeConfirms)$defTradeConfirms.invoke());
    }

    private static final Function0 defTradeConfirms$lambda$0(CompoundHandler $this$list) {
        Intrinsics.checkNotNullParameter((Object)$this$list, (String)"$this$list");
        return INSTANCE.defOrder($this$list);
    }

    private static final Function0 defTradeConfirms$lambda$1(CompoundHandler $this$list) {
        Intrinsics.checkNotNullParameter((Object)$this$list, (String)"$this$list");
        return INSTANCE.defSymbolSummary($this$list);
    }

    private static final Function0 defTradeConfirms$lambda$2(CompoundHandler $this$list) {
        Intrinsics.checkNotNullParameter((Object)$this$list, (String)"$this$list");
        return INSTANCE.defTradeConfirm($this$list);
    }

    private static final TradeConfirms defTradeConfirms$lambda$3(OptionalHandler $orders, OptionalHandler $symbolSummaries, OptionalHandler $tradeConfirms) {
        List list;
        List list2;
        List list3 = (List)$orders.invoke();
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        if ((list2 = (List)$symbolSummaries.invoke()) == null) {
            list2 = CollectionsKt.emptyList();
        }
        if ((list = (List)$tradeConfirms.invoke()) == null) {
            list = CollectionsKt.emptyList();
        }
        return new TradeConfirms(list3, list2, list);
    }

    private static final Order defOrder$lambda$0(CurrentAttrHandler $accountId, CurrentAttrHandler $acctAlias, CurrentAttrHandler $model, CurrentAttrHandler $currency, CurrentAttrHandler $assetCategory, CurrentAttrHandler $subCategory, CurrentAttrHandler $symbol, CurrentAttrHandler $description, CurrentAttrHandler $conid, CurrentAttrHandler $securityID, CurrentAttrHandler $securityIDType, CurrentAttrHandler $cusip, CurrentAttrHandler $isin, CurrentAttrHandler $figi, CurrentAttrHandler $listingExchange, CurrentAttrHandler $underlyingConid, CurrentAttrHandler $underlyingSymbol, CurrentAttrHandler $underlyingSecurityID, CurrentAttrHandler $underlyingListingExchange, CurrentAttrHandler $issuer, CurrentAttrHandler $issuerCountryCode, CurrentAttrHandler $multiplier, CurrentAttrHandler $strike, CurrentAttrHandler $expiry, CurrentAttrHandler $putCall, CurrentAttrHandler $principalAdjustFactor, CurrentAttrHandler $transactionType, CurrentAttrHandler $tradeID, CurrentAttrHandler $orderID, CurrentAttrHandler $execID, CurrentAttrHandler $brokerageOrderID, CurrentAttrHandler $orderReference, CurrentAttrHandler $volatilityOrderLink, CurrentAttrHandler $clearingFirmID, CurrentAttrHandler $origTradePrice, CurrentAttrHandler $origTradeDate, CurrentAttrHandler $origTradeID, CurrentAttrHandler $extExecID, CurrentAttrHandler $blockID, CurrentAttrHandler $orderTime, CurrentAttrHandler $dateTime, CurrentAttrHandler $reportDate, CurrentAttrHandler $settleDate, CurrentAttrHandler $tradeDate, CurrentAttrHandler $exchange, CurrentAttrHandler $buySell, CurrentAttrHandler $quantity, CurrentAttrHandler $price, CurrentAttrHandler $amount, CurrentAttrHandler $proceeds, CurrentAttrHandler $netCash, CurrentAttrHandler $netCashWithBillable, CurrentAttrHandler $commission, CurrentAttrHandler $brokerExecutionCommission, CurrentAttrHandler $brokerClearingCommission, CurrentAttrHandler $thirdPartyExecutionCommission, CurrentAttrHandler $thirdPartyClearingCommission, CurrentAttrHandler $thirdPartyRegulatoryCommission, CurrentAttrHandler $otherCommission, CurrentAttrHandler $commissionCurrency, CurrentAttrHandler $tax, CurrentAttrHandler $code, CurrentAttrHandler $orderType, CurrentAttrHandler $levelOfDetail, CurrentAttrHandler $traderID, CurrentAttrHandler $isAPIOrder, CurrentAttrHandler $allocatedTo, CurrentAttrHandler $accruedInt, CurrentAttrHandler $rfqID, CurrentAttrHandler $serialNumber, CurrentAttrHandler $deliveryType, CurrentAttrHandler $commodityType, CurrentAttrHandler $fineness, CurrentAttrHandler $weight) {
        return new Order((String)$accountId.invoke(), (String)$acctAlias.invoke(), (String)$model.invoke(), (String)$currency.invoke(), (String)$assetCategory.invoke(), (String)$subCategory.invoke(), (String)$symbol.invoke(), (String)$description.invoke(), (String)$conid.invoke(), (String)$securityID.invoke(), (String)$securityIDType.invoke(), (String)$cusip.invoke(), (String)$isin.invoke(), (String)$figi.invoke(), (String)$listingExchange.invoke(), (String)$underlyingConid.invoke(), (String)$underlyingSymbol.invoke(), (String)$underlyingSecurityID.invoke(), (String)$underlyingListingExchange.invoke(), (String)$issuer.invoke(), (String)$issuerCountryCode.invoke(), (String)$multiplier.invoke(), (String)$strike.invoke(), (String)$expiry.invoke(), (String)$putCall.invoke(), (String)$principalAdjustFactor.invoke(), (String)$transactionType.invoke(), (String)$tradeID.invoke(), (String)$orderID.invoke(), (String)$execID.invoke(), (String)$brokerageOrderID.invoke(), (String)$orderReference.invoke(), (String)$volatilityOrderLink.invoke(), (String)$clearingFirmID.invoke(), (String)$origTradePrice.invoke(), (String)$origTradeDate.invoke(), (String)$origTradeID.invoke(), (String)$extExecID.invoke(), (String)$blockID.invoke(), (String)$orderTime.invoke(), (String)$dateTime.invoke(), (String)$reportDate.invoke(), (String)$settleDate.invoke(), (String)$tradeDate.invoke(), (String)$exchange.invoke(), (String)$buySell.invoke(), (String)$quantity.invoke(), (String)$price.invoke(), (String)$amount.invoke(), (String)$proceeds.invoke(), (String)$netCash.invoke(), (String)$netCashWithBillable.invoke(), (String)$commission.invoke(), (String)$brokerExecutionCommission.invoke(), (String)$brokerClearingCommission.invoke(), (String)$thirdPartyExecutionCommission.invoke(), (String)$thirdPartyClearingCommission.invoke(), (String)$thirdPartyRegulatoryCommission.invoke(), (String)$otherCommission.invoke(), (String)$commissionCurrency.invoke(), (String)$tax.invoke(), (String)$code.invoke(), (String)$orderType.invoke(), (String)$levelOfDetail.invoke(), (String)$traderID.invoke(), (String)$isAPIOrder.invoke(), (String)$allocatedTo.invoke(), (String)$accruedInt.invoke(), (String)$rfqID.invoke(), (String)$serialNumber.invoke(), (String)$deliveryType.invoke(), (String)$commodityType.invoke(), (String)$fineness.invoke(), (String)$weight.invoke());
    }

    private static final SymbolSummary defSymbolSummary$lambda$0(CurrentAttrHandler $accountId, CurrentAttrHandler $acctAlias, CurrentAttrHandler $model, CurrentAttrHandler $currency, CurrentAttrHandler $assetCategory, CurrentAttrHandler $subCategory, CurrentAttrHandler $symbol, CurrentAttrHandler $description, IntHandler $conid, CurrentAttrHandler $securityID, CurrentAttrHandler $securityIDType, CurrentAttrHandler $cusip, CurrentAttrHandler $isin, CurrentAttrHandler $figi, CurrentAttrHandler $listingExchange, IntOrNullHandler $underlyingConid, CurrentAttrHandler $underlyingSymbol, CurrentAttrHandler $underlyingSecurityID, CurrentAttrHandler $underlyingListingExchange, CurrentAttrHandler $issuer, CurrentAttrHandler $issuerCountryCode, XBigNumHandler $multiplier, XBigNumOrNullHandler $strike, LocalDateOrNullHandler $expiry, CustomTypeHandler $putCall, CurrentAttrHandler $principalAdjustFactor, CurrentAttrHandler $transactionType, CurrentAttrHandler $tradeID, CurrentAttrHandler $orderID, CurrentAttrHandler $execID, CurrentAttrHandler $brokerageOrderID, CurrentAttrHandler $orderReference, CurrentAttrHandler $volatilityOrderLink, CurrentAttrHandler $clearingFirmID, CurrentAttrHandler $origTradePrice, CurrentAttrHandler $origTradeDate, CurrentAttrHandler $origTradeID, CurrentAttrHandler $extExecID, CurrentAttrHandler $blockID, CurrentAttrHandler $orderTime, CurrentAttrHandler $dateTime, CurrentAttrHandler $reportDate, CurrentAttrHandler $settleDate, CurrentAttrHandler $tradeDate, CurrentAttrHandler $exchange, CurrentAttrHandler $buySell, CurrentAttrHandler $quantity, CurrentAttrHandler $price, CurrentAttrHandler $amount, CurrentAttrHandler $proceeds, CurrentAttrHandler $netCash, CurrentAttrHandler $netCashWithBillable, CurrentAttrHandler $commission, CurrentAttrHandler $brokerExecutionCommission, CurrentAttrHandler $brokerClearingCommission, CurrentAttrHandler $thirdPartyExecutionCommission, CurrentAttrHandler $thirdPartyClearingCommission, CurrentAttrHandler $thirdPartyRegulatoryCommission, CurrentAttrHandler $otherCommission, CurrentAttrHandler $commissionCurrency, CurrentAttrHandler $tax, CurrentAttrHandler $code, CurrentAttrHandler $orderType, CurrentAttrHandler $levelOfDetail, CurrentAttrHandler $traderID, CurrentAttrHandler $isAPIOrder, CurrentAttrHandler $allocatedTo, CurrentAttrHandler $accruedInt, CurrentAttrHandler $rfqID, CurrentAttrHandler $serialNumber, CurrentAttrHandler $deliveryType, CurrentAttrHandler $commodityType, CurrentAttrHandler $fineness, CurrentAttrHandler $weight) {
        return new SymbolSummary((String)$accountId.invoke(), (String)$acctAlias.invoke(), (String)$model.invoke(), (String)$currency.invoke(), (String)$assetCategory.invoke(), (String)$subCategory.invoke(), (String)$symbol.invoke(), (String)$description.invoke(), ((Number)$conid.invoke()).intValue(), (String)$securityID.invoke(), (String)$securityIDType.invoke(), (String)$cusip.invoke(), (String)$isin.invoke(), (String)$figi.invoke(), (String)$listingExchange.invoke(), (Integer)$underlyingConid.invoke(), (String)$underlyingSymbol.invoke(), (String)$underlyingSecurityID.invoke(), (String)$underlyingListingExchange.invoke(), (String)$issuer.invoke(), (String)$issuerCountryCode.invoke(), (XBigNum)$multiplier.invoke(), (XBigNum)$strike.invoke(), (LocalDate)$expiry.invoke(), (Right)$putCall.invoke(), (String)$principalAdjustFactor.invoke(), (String)$transactionType.invoke(), (String)$tradeID.invoke(), (String)$orderID.invoke(), (String)$execID.invoke(), (String)$brokerageOrderID.invoke(), (String)$orderReference.invoke(), (String)$volatilityOrderLink.invoke(), (String)$clearingFirmID.invoke(), (String)$origTradePrice.invoke(), (String)$origTradeDate.invoke(), (String)$origTradeID.invoke(), (String)$extExecID.invoke(), (String)$blockID.invoke(), (String)$orderTime.invoke(), (String)$dateTime.invoke(), (String)$reportDate.invoke(), (String)$settleDate.invoke(), (String)$tradeDate.invoke(), (String)$exchange.invoke(), (String)$buySell.invoke(), (String)$quantity.invoke(), (String)$price.invoke(), (String)$amount.invoke(), (String)$proceeds.invoke(), (String)$netCash.invoke(), (String)$netCashWithBillable.invoke(), (String)$commission.invoke(), (String)$brokerExecutionCommission.invoke(), (String)$brokerClearingCommission.invoke(), (String)$thirdPartyExecutionCommission.invoke(), (String)$thirdPartyClearingCommission.invoke(), (String)$thirdPartyRegulatoryCommission.invoke(), (String)$otherCommission.invoke(), (String)$commissionCurrency.invoke(), (String)$tax.invoke(), (String)$code.invoke(), (String)$orderType.invoke(), (String)$levelOfDetail.invoke(), (String)$traderID.invoke(), (String)$isAPIOrder.invoke(), (String)$allocatedTo.invoke(), (String)$accruedInt.invoke(), (String)$rfqID.invoke(), (String)$serialNumber.invoke(), (String)$deliveryType.invoke(), (String)$commodityType.invoke(), (String)$fineness.invoke(), (String)$weight.invoke());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Right defTradeConfirm$lambda$0(String it) {
        Right right;
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String it2 = string = it;
        boolean bl = false;
        if (((CharSequence)it2).length() <= 0) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        String string2 = string;
        if (string2 == null) return null;
        it2 = string2;
        boolean bl3 = false;
        String string3 = it2;
        if (Intrinsics.areEqual((Object)string3, (Object)"C")) {
            right = Right.CALL;
            return right;
        } else {
            if (!Intrinsics.areEqual((Object)string3, (Object)"P")) throw new IllegalStateException(("constant '" + it2 + "' not supported").toString());
            right = Right.PUT;
        }
        return right;
    }

    private static final TradeConfirm defTradeConfirm$lambda$1(CurrentAttrHandler $accountId, CurrentAttrHandler $acctAlias, CurrentAttrHandler $model, CurrentAttrHandler $currency, CurrentAttrHandler $assetCategory, CurrentAttrHandler $subCategory, CurrentAttrHandler $symbol, CurrentAttrHandler $description, IntHandler $conid, CurrentAttrHandler $securityID, CurrentAttrHandler $securityIDType, CurrentAttrHandler $cusip, CurrentAttrHandler $isin, CurrentAttrHandler $figi, CurrentAttrHandler $listingExchange, IntOrNullHandler $underlyingConid, CurrentAttrHandler $underlyingSymbol, CurrentAttrHandler $underlyingSecurityID, CurrentAttrHandler $underlyingListingExchange, CurrentAttrHandler $issuer, CurrentAttrHandler $issuerCountryCode, XBigNumHandler $multiplier, OptionalHandler $strike, CurrentAttrHandler $expiry, CustomTypeHandler $putCall, CurrentAttrHandler $principalAdjustFactor, CurrentAttrHandler $transactionType, CurrentAttrHandler $tradeID, CurrentAttrHandler $orderID, CurrentAttrHandler $execID, CurrentAttrHandler $brokerageOrderID, CurrentAttrHandler $orderReference, CurrentAttrHandler $volatilityOrderLink, CurrentAttrHandler $clearingFirmID, CurrentAttrHandler $origTradePrice, CurrentAttrHandler $origTradeDate, CurrentAttrHandler $origTradeID, CurrentAttrHandler $extExecID, CurrentAttrHandler $blockID, CurrentAttrHandler $orderTime, InstantWithFlexDefaultTimeZoneHandler $dateTime, CurrentAttrHandler $reportDate, CurrentAttrHandler $settleDate, CurrentAttrHandler $tradeDate, CurrentAttrHandler $exchange, CurrentAttrHandler $buySell, XBigNumHandler $quantity, XBigNumHandler $price, CurrentAttrHandler $amount, CurrentAttrHandler $proceeds, CurrentAttrHandler $netCash, CurrentAttrHandler $netCashWithBillable, XBigNumHandler $commission, CurrentAttrHandler $brokerExecutionCommission, CurrentAttrHandler $brokerClearingCommission, CurrentAttrHandler $thirdPartyExecutionCommission, CurrentAttrHandler $thirdPartyClearingCommission, CurrentAttrHandler $thirdPartyRegulatoryCommission, CurrentAttrHandler $otherCommission, CurrentAttrHandler $commissionCurrency, CurrentAttrHandler $tax, CurrentAttrHandler $code, CurrentAttrHandler $orderType, CurrentAttrHandler $levelOfDetail, CurrentAttrHandler $traderID, CurrentAttrHandler $isAPIOrder, CurrentAttrHandler $allocatedTo, CurrentAttrHandler $accruedInt, CurrentAttrHandler $rfqID, CurrentAttrHandler $serialNumber, CurrentAttrHandler $deliveryType, CurrentAttrHandler $commodityType, CurrentAttrHandler $fineness, CurrentAttrHandler $weight) {
        return new TradeConfirm((String)$accountId.invoke(), (String)$acctAlias.invoke(), (String)$model.invoke(), (String)$currency.invoke(), (String)$assetCategory.invoke(), (String)$subCategory.invoke(), (String)$symbol.invoke(), (String)$description.invoke(), ((Number)$conid.invoke()).intValue(), (String)$securityID.invoke(), (String)$securityIDType.invoke(), (String)$cusip.invoke(), (String)$isin.invoke(), (String)$figi.invoke(), (String)$listingExchange.invoke(), (Integer)$underlyingConid.invoke(), (String)$underlyingSymbol.invoke(), (String)$underlyingSecurityID.invoke(), (String)$underlyingListingExchange.invoke(), (String)$issuer.invoke(), (String)$issuerCountryCode.invoke(), (XBigNum)$multiplier.invoke(), (XBigNum)$strike.invoke(), (String)$expiry.invoke(), (Right)$putCall.invoke(), (String)$principalAdjustFactor.invoke(), (String)$transactionType.invoke(), (String)$tradeID.invoke(), (String)$orderID.invoke(), (String)$execID.invoke(), (String)$brokerageOrderID.invoke(), (String)$orderReference.invoke(), (String)$volatilityOrderLink.invoke(), (String)$clearingFirmID.invoke(), (String)$origTradePrice.invoke(), (String)$origTradeDate.invoke(), (String)$origTradeID.invoke(), (String)$extExecID.invoke(), (String)$blockID.invoke(), (String)$orderTime.invoke(), (Instant)$dateTime.invoke(), (String)$reportDate.invoke(), (String)$settleDate.invoke(), (String)$tradeDate.invoke(), (String)$exchange.invoke(), (String)$buySell.invoke(), (XBigNum)$quantity.invoke(), (XBigNum)$price.invoke(), (String)$amount.invoke(), (String)$proceeds.invoke(), (String)$netCash.invoke(), (String)$netCashWithBillable.invoke(), (XBigNum)$commission.invoke(), (String)$brokerExecutionCommission.invoke(), (String)$brokerClearingCommission.invoke(), (String)$thirdPartyExecutionCommission.invoke(), (String)$thirdPartyClearingCommission.invoke(), (String)$thirdPartyRegulatoryCommission.invoke(), (String)$otherCommission.invoke(), (String)$commissionCurrency.invoke(), (String)$tax.invoke(), (String)$code.invoke(), (String)$orderType.invoke(), (String)$levelOfDetail.invoke(), (String)$traderID.invoke(), (String)$isAPIOrder.invoke(), (String)$allocatedTo.invoke(), (String)$accruedInt.invoke(), (String)$rfqID.invoke(), (String)$serialNumber.invoke(), (String)$deliveryType.invoke(), (String)$commodityType.invoke(), (String)$fineness.invoke(), (String)$weight.invoke());
    }
}

