/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.view.tool;

import com.xorrus.trading.lot.app.javafx.dsl.LabelKt;
import com.xorrus.trading.lot.app.javafx.dsl.MigpaneKt;
import com.xorrus.trading.lot.app.javafx.dsl.TextfieldKt;
import com.xorrus.trading.lot.app.plot.DistributionType;
import com.xorrus.trading.lot.app.plot.MonteCarloChartNode;
import com.xorrus.trading.lot.app.plot.RiskMode;
import java.util.Arrays;
import java.util.Collection;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.tbee.javafx.scene.layout.MigPane;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/xorrus/trading/lot/app/view/tool/MonteCarloPane;", "Lorg/tbee/javafx/scene/layout/MigPane;", "<init>", "()V", "chartNode", "Lcom/xorrus/trading/lot/app/plot/MonteCarloChartNode;", "initialPortfolioField", "Ljavafx/scene/control/TextField;", "numberOfPortfoliosField", "tradesPerPortfolioField", "winProbabilityField", "lossProbabilityField", "breakevenProbabilityLabel", "Ljavafx/scene/control/Label;", "riskModeCombo", "Ljavafx/scene/control/ComboBox;", "", "riskValueField", "riskStdDevField", "winMultipleField", "winDistributionCombo", "winStdDevField", "lossDistributionCombo", "lossStdDevField", "updateChart", "", "validateField", "", "field", "valid", "laboftrades-app"})
public final class MonteCarloPane
extends MigPane {
    @NotNull
    private final MonteCarloChartNode chartNode = new MonteCarloChartNode();
    private TextField initialPortfolioField;
    private TextField numberOfPortfoliosField;
    private TextField tradesPerPortfolioField;
    private TextField winProbabilityField;
    private TextField lossProbabilityField;
    private Label breakevenProbabilityLabel;
    private ComboBox<String> riskModeCombo;
    private TextField riskValueField;
    private TextField riskStdDevField;
    private TextField winMultipleField;
    private ComboBox<String> winDistributionCombo;
    private TextField winStdDevField;
    private ComboBox<String> lossDistributionCombo;
    private TextField lossStdDevField;

    public MonteCarloPane() {
        super("fill, insets 10");
        VBox vBox;
        ObservableList observableList = this.getStyleClass();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getStyleClass(...)");
        Collection collection = (Collection)observableList;
        collection.add("detail");
        LabelKt.addLabel((MigPane)this, (String)"Monte Carlo Simulation", (String)"wrap", MonteCarloPane::_init_$lambda$0);
        MigpaneKt.addMigPane$default((MigPane)this, (String)"fillx, ins 0", null, null, (String)"wrap", arg_0 -> MonteCarloPane._init_$lambda$1(this, arg_0), (int)6, null);
        VBox $this$_init__u24lambda_u242 = vBox = new VBox();
        boolean bl = false;
        $this$_init__u24lambda_u242.getChildren().add((Object)this.chartNode);
        VBox.setVgrow((Node)((Node)this.chartNode), (Priority)Priority.ALWAYS);
        $this$_init__u24lambda_u242.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        this.chartNode.prefWidthProperty().bind((ObservableValue)$this$_init__u24lambda_u242.widthProperty());
        this.chartNode.prefHeightProperty().bind((ObservableValue)$this$_init__u24lambda_u242.heightProperty());
        VBox chartContainer = vBox;
        this.add((Node)chartContainer, "grow, push, span");
        this.updateChart();
    }

    private final void updateChart() {
        double beProb;
        TextField textField = this.initialPortfolioField;
        if (textField == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"initialPortfolioField");
            textField = null;
        }
        String string = textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Double initialPortfolio = StringsKt.toDoubleOrNull((String)string);
        TextField textField2 = this.numberOfPortfoliosField;
        if (textField2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"numberOfPortfoliosField");
            textField2 = null;
        }
        String string2 = textField2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        Integer numberOfPortfolios = StringsKt.toIntOrNull((String)string2);
        TextField textField3 = this.tradesPerPortfolioField;
        if (textField3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tradesPerPortfolioField");
            textField3 = null;
        }
        String string3 = textField3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        Integer tradesPerPortfolio = StringsKt.toIntOrNull((String)string3);
        TextField textField4 = this.winProbabilityField;
        if (textField4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"winProbabilityField");
            textField4 = null;
        }
        String string4 = textField4.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        Double winProb = StringsKt.toDoubleOrNull((String)string4);
        TextField textField5 = this.lossProbabilityField;
        if (textField5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lossProbabilityField");
            textField5 = null;
        }
        String string5 = textField5.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
        Double lossProb = StringsKt.toDoubleOrNull((String)string5);
        TextField textField6 = this.riskValueField;
        if (textField6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"riskValueField");
            textField6 = null;
        }
        String string6 = textField6.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
        Double riskValue = StringsKt.toDoubleOrNull((String)string6);
        TextField textField7 = this.riskStdDevField;
        if (textField7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"riskStdDevField");
            textField7 = null;
        }
        String string7 = textField7.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getText(...)");
        Double riskStdDev = StringsKt.toDoubleOrNull((String)string7);
        TextField textField8 = this.winMultipleField;
        if (textField8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"winMultipleField");
            textField8 = null;
        }
        String string8 = textField8.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getText(...)");
        Double winMultiple = StringsKt.toDoubleOrNull((String)string8);
        TextField textField9 = this.winStdDevField;
        if (textField9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"winStdDevField");
            textField9 = null;
        }
        String string9 = textField9.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getText(...)");
        Double winStdDev = StringsKt.toDoubleOrNull((String)string9);
        TextField textField10 = this.lossStdDevField;
        if (textField10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lossStdDevField");
            textField10 = null;
        }
        String string10 = textField10.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getText(...)");
        Double lossStdDev = StringsKt.toDoubleOrNull((String)string10);
        boolean hasError = false;
        TextField textField11 = this.initialPortfolioField;
        if (textField11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"initialPortfolioField");
            textField11 = null;
        }
        hasError = this.validateField(textField11, initialPortfolio != null && initialPortfolio > 0.0);
        TextField textField12 = this.numberOfPortfoliosField;
        if (textField12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"numberOfPortfoliosField");
            textField12 = null;
        }
        hasError = this.validateField(textField12, numberOfPortfolios != null && numberOfPortfolios > 0) || hasError;
        TextField textField13 = this.tradesPerPortfolioField;
        if (textField13 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tradesPerPortfolioField");
            textField13 = null;
        }
        hasError = this.validateField(textField13, tradesPerPortfolio != null && tradesPerPortfolio > 0) || hasError;
        TextField textField14 = this.winProbabilityField;
        if (textField14 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"winProbabilityField");
            textField14 = null;
        }
        hasError = this.validateField(textField14, winProb != null && winProb >= 0.0 && winProb <= 100.0) || hasError;
        TextField textField15 = this.lossProbabilityField;
        if (textField15 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lossProbabilityField");
            textField15 = null;
        }
        hasError = this.validateField(textField15, lossProb != null && lossProb >= 0.0 && lossProb <= 100.0) || hasError;
        TextField textField16 = this.riskValueField;
        if (textField16 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"riskValueField");
            textField16 = null;
        }
        hasError = this.validateField(textField16, riskValue != null && riskValue > 0.0) || hasError;
        TextField textField17 = this.riskStdDevField;
        if (textField17 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"riskStdDevField");
            textField17 = null;
        }
        hasError = this.validateField(textField17, riskStdDev != null && riskStdDev >= 0.0) || hasError;
        TextField textField18 = this.winMultipleField;
        if (textField18 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"winMultipleField");
            textField18 = null;
        }
        hasError = this.validateField(textField18, winMultiple != null && winMultiple > 0.0) || hasError;
        TextField textField19 = this.winStdDevField;
        if (textField19 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"winStdDevField");
            textField19 = null;
        }
        hasError = this.validateField(textField19, winStdDev != null && winStdDev >= 0.0) || hasError;
        TextField textField20 = this.lossStdDevField;
        if (textField20 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lossStdDevField");
            textField20 = null;
        }
        boolean bl = hasError = this.validateField(textField20, lossStdDev != null && lossStdDev >= 0.0) || hasError;
        if (winProb != null && lossProb != null) {
            beProb = (double)100 - winProb - lossProb;
            Label label = this.breakevenProbabilityLabel;
            if (label == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"breakevenProbabilityLabel");
                label = null;
            }
            String string11 = "%.0f%%";
            Object[] objectArray = new Object[]{beProb};
            String string12 = String.format(string11, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"format(...)");
            label.setText(string12);
            if (beProb < 0.0) {
                hasError = true;
                TextField textField21 = this.winProbabilityField;
                if (textField21 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"winProbabilityField");
                    textField21 = null;
                }
                ObservableList observableList = textField21.getStyleClass();
                Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getStyleClass(...)");
                Collection collection = (Collection)observableList;
                collection.add("error");
                TextField textField22 = this.lossProbabilityField;
                if (textField22 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"lossProbabilityField");
                    textField22 = null;
                }
                ObservableList observableList2 = textField22.getStyleClass();
                Intrinsics.checkNotNullExpressionValue((Object)observableList2, (String)"getStyleClass(...)");
                collection = (Collection)observableList2;
                collection.add("error");
            }
        }
        if (!hasError && initialPortfolio != null && numberOfPortfolios != null && tradesPerPortfolio != null && winProb != null && lossProb != null && riskValue != null && riskStdDev != null && winMultiple != null && winStdDev != null && lossStdDev != null) {
            beProb = (double)100 - winProb - lossProb;
            this.chartNode.setInitialPortfolio(initialPortfolio);
            this.chartNode.setNumberOfPortfolios(numberOfPortfolios);
            this.chartNode.setTradesPerPortfolio(tradesPerPortfolio);
            this.chartNode.setWinProbability(winProb / 100.0);
            this.chartNode.setBreakevenProbability(beProb / 100.0);
            ComboBox<String> comboBox = this.riskModeCombo;
            if (comboBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"riskModeCombo");
                comboBox = null;
            }
            this.chartNode.setRiskMode(comboBox.getSelectionModel().getSelectedIndex() == 0 ? RiskMode.ABSOLUTE : RiskMode.PERCENTAGE);
            this.chartNode.setRiskValue(riskValue);
            this.chartNode.setRiskStdDev(riskStdDev / 100.0);
            this.chartNode.setWinMultiple(winMultiple);
            ComboBox<String> comboBox2 = this.winDistributionCombo;
            if (comboBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"winDistributionCombo");
                comboBox2 = null;
            }
            this.chartNode.setWinDistribution(switch (comboBox2.getSelectionModel().getSelectedIndex()) {
                case 0 -> DistributionType.UNIFORM;
                case 1 -> DistributionType.NORMAL;
                case 2 -> DistributionType.STUDENT_T;
                default -> DistributionType.HALF_NORMAL_RIGHT;
            });
            this.chartNode.setWinStdDev(winStdDev);
            ComboBox<String> comboBox3 = this.lossDistributionCombo;
            if (comboBox3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lossDistributionCombo");
                comboBox3 = null;
            }
            this.chartNode.setLossDistribution(switch (comboBox3.getSelectionModel().getSelectedIndex()) {
                case 0 -> DistributionType.UNIFORM;
                case 1 -> DistributionType.NORMAL;
                case 2 -> DistributionType.STUDENT_T;
                default -> DistributionType.TRUNCATED_LEFT;
            });
            this.chartNode.setLossStdDev(lossStdDev);
        }
    }

    private final boolean validateField(TextField field, boolean valid) {
        if (!valid) {
            if (!field.getStyleClass().contains((Object)"error")) {
                ObservableList observableList = field.getStyleClass();
                Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getStyleClass(...)");
                Collection collection = (Collection)observableList;
                collection.add("error");
            }
            return true;
        }
        ObservableList observableList = field.getStyleClass();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getStyleClass(...)");
        Collection collection = (Collection)observableList;
        collection.remove("error");
        return false;
    }

    private static final Unit _init_$lambda$0(Label $this$addLabel) {
        Intrinsics.checkNotNullParameter((Object)$this$addLabel, (String)"$this$addLabel");
        ObservableList observableList = $this$addLabel.getStyleClass();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getStyleClass(...)");
        Collection collection = (Collection)observableList;
        collection.add("heading2");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(MonteCarloPane this$0, MigPane $this$addMigPane) {
        Intrinsics.checkNotNullParameter((Object)$this$addMigPane, (String)"$this$addMigPane");
        MonteCarloPane.lambda$1$addSectionLabel($this$addMigPane, "Portfolio");
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"Startwert:", (String)"", null, (int)4, null);
        this$0.initialPortfolioField = TextfieldKt.addTextField$default((MigPane)$this$addMigPane, (String)"10000", null, (String)"", arg_0 -> MonteCarloPane.lambda$1$1(this$0, arg_0), (int)2, null);
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"Portfolios:", (String)"", null, (int)4, null);
        this$0.numberOfPortfoliosField = TextfieldKt.addTextField$default((MigPane)$this$addMigPane, (String)"500", null, (String)"", arg_0 -> MonteCarloPane.lambda$1$2(this$0, arg_0), (int)2, null);
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"Trades:", (String)"", null, (int)4, null);
        this$0.tradesPerPortfolioField = TextfieldKt.addTextField$default((MigPane)$this$addMigPane, (String)"100", null, (String)"wrap", arg_0 -> MonteCarloPane.lambda$1$3(this$0, arg_0), (int)2, null);
        MonteCarloPane.lambda$1$addSectionLabel($this$addMigPane, "Wahrscheinlichkeiten");
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"Gewinn:", (String)"", null, (int)4, null);
        this$0.winProbabilityField = TextfieldKt.addTextField$default((MigPane)$this$addMigPane, (String)"40", null, (String)"", arg_0 -> MonteCarloPane.lambda$1$4(this$0, arg_0), (int)2, null);
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"Verlust:", (String)"", null, (int)4, null);
        this$0.lossProbabilityField = TextfieldKt.addTextField$default((MigPane)$this$addMigPane, (String)"50", null, (String)"", arg_0 -> MonteCarloPane.lambda$1$5(this$0, arg_0), (int)2, null);
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"BE:", (String)"", null, (int)4, null);
        this$0.breakevenProbabilityLabel = new Label("10%");
        Label label = this$0.breakevenProbabilityLabel;
        if (label == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"breakevenProbabilityLabel");
            label = null;
        }
        ObservableList observableList = label.getStyleClass();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getStyleClass(...)");
        Object[] objectArray = (Object[])observableList;
        objectArray.add("small-text");
        Label label2 = this$0.breakevenProbabilityLabel;
        if (label2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"breakevenProbabilityLabel");
            label2 = null;
        }
        $this$addMigPane.add((Node)label2, "wrap");
        MonteCarloPane.lambda$1$addSectionLabel($this$addMigPane, "Risiko pro Trade");
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"Modus:", (String)"", null, (int)4, null);
        objectArray = new String[]{"Absolut", "Prozent"};
        this$0.riskModeCombo = new ComboBox(FXCollections.observableArrayList((Object[])objectArray));
        ComboBox<String> comboBox = this$0.riskModeCombo;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"riskModeCombo");
            comboBox = null;
        }
        comboBox.getSelectionModel().select(0);
        ComboBox<String> comboBox2 = this$0.riskModeCombo;
        if (comboBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"riskModeCombo");
            comboBox2 = null;
        }
        comboBox2.setOnAction(arg_0 -> MonteCarloPane.lambda$1$6(this$0, arg_0));
        ComboBox<String> comboBox3 = this$0.riskModeCombo;
        if (comboBox3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"riskModeCombo");
            comboBox3 = null;
        }
        $this$addMigPane.add((Node)comboBox3, "");
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"Wert:", (String)"", null, (int)4, null);
        this$0.riskValueField = TextfieldKt.addTextField$default((MigPane)$this$addMigPane, (String)"100", null, (String)"", arg_0 -> MonteCarloPane.lambda$1$7(this$0, arg_0), (int)2, null);
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"\u03c3:", (String)"", null, (int)4, null);
        this$0.riskStdDevField = TextfieldKt.addTextField$default((MigPane)$this$addMigPane, (String)"0", null, (String)"wrap", arg_0 -> MonteCarloPane.lambda$1$8(this$0, arg_0), (int)2, null);
        MonteCarloPane.lambda$1$addSectionLabel($this$addMigPane, "Gewinn");
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"Vert.:", (String)"", null, (int)4, null);
        objectArray = new String[]{"Uniform", "Normal", "Fat-Tail", "Half-N"};
        this$0.winDistributionCombo = new ComboBox(FXCollections.observableArrayList((Object[])objectArray));
        ComboBox<String> comboBox4 = this$0.winDistributionCombo;
        if (comboBox4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"winDistributionCombo");
            comboBox4 = null;
        }
        comboBox4.getSelectionModel().select(1);
        ComboBox<String> comboBox5 = this$0.winDistributionCombo;
        if (comboBox5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"winDistributionCombo");
            comboBox5 = null;
        }
        comboBox5.setOnAction(arg_0 -> MonteCarloPane.lambda$1$9(this$0, arg_0));
        ComboBox<String> comboBox6 = this$0.winDistributionCombo;
        if (comboBox6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"winDistributionCombo");
            comboBox6 = null;
        }
        $this$addMigPane.add((Node)comboBox6, "");
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"R:", (String)"", null, (int)4, null);
        this$0.winMultipleField = TextfieldKt.addTextField$default((MigPane)$this$addMigPane, (String)"2.0", null, (String)"", arg_0 -> MonteCarloPane.lambda$1$10(this$0, arg_0), (int)2, null);
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"\u03c3:", (String)"", null, (int)4, null);
        this$0.winStdDevField = TextfieldKt.addTextField$default((MigPane)$this$addMigPane, (String)"0.5", null, (String)"wrap", arg_0 -> MonteCarloPane.lambda$1$11(this$0, arg_0), (int)2, null);
        MonteCarloPane.lambda$1$addSectionLabel($this$addMigPane, "Verlust");
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"Vert.:", (String)"", null, (int)4, null);
        objectArray = new String[]{"Uniform", "Normal", "Fat-Tail", "Slippage"};
        this$0.lossDistributionCombo = new ComboBox(FXCollections.observableArrayList((Object[])objectArray));
        ComboBox<String> comboBox7 = this$0.lossDistributionCombo;
        if (comboBox7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lossDistributionCombo");
            comboBox7 = null;
        }
        comboBox7.getSelectionModel().select(1);
        ComboBox<String> comboBox8 = this$0.lossDistributionCombo;
        if (comboBox8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lossDistributionCombo");
            comboBox8 = null;
        }
        comboBox8.setOnAction(arg_0 -> MonteCarloPane.lambda$1$12(this$0, arg_0));
        ComboBox<String> comboBox9 = this$0.lossDistributionCombo;
        if (comboBox9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lossDistributionCombo");
            comboBox9 = null;
        }
        $this$addMigPane.add((Node)comboBox9, "");
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"R:", (String)"", null, (int)4, null);
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"= 1", (String)"", null, (int)4, null);
        LabelKt.addLabel$default((MigPane)$this$addMigPane, (String)"\u03c3:", (String)"", null, (int)4, null);
        this$0.lossStdDevField = TextfieldKt.addTextField$default((MigPane)$this$addMigPane, (String)"0.2", null, (String)"wrap", arg_0 -> MonteCarloPane.lambda$1$13(this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Label lambda$1$addSectionLabel(MigPane $this_addMigPane, String text) {
        return LabelKt.addLabel((MigPane)$this_addMigPane, (String)text, (String)"wrap", MonteCarloPane::lambda$1$addSectionLabel$0);
    }

    private static final Unit lambda$1$addSectionLabel$0(Label $this$addLabel) {
        Intrinsics.checkNotNullParameter((Object)$this$addLabel, (String)"$this$addLabel");
        ObservableList observableList = $this$addLabel.getStyleClass();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getStyleClass(...)");
        Collection collection = (Collection)observableList;
        collection.add("small-heading");
        $this$addLabel.setStyle("-fx-font-weight: bold; -fx-text-fill: #aaa;");
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$1(MonteCarloPane this$0, TextField $this$addTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextField, (String)"$this$addTextField");
        $this$addTextField.setPrefColumnCount(6);
        $this$addTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$1$1((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$1$0(this$0, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$1$0(MonteCarloPane this$0, ObservableValue observableValue, String string, String string2) {
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final void lambda$1$1$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit lambda$1$2(MonteCarloPane this$0, TextField $this$addTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextField, (String)"$this$addTextField");
        $this$addTextField.setPrefColumnCount(4);
        $this$addTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$2$1((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$2$0(this$0, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$2$0(MonteCarloPane this$0, ObservableValue observableValue, String string, String string2) {
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final void lambda$1$2$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit lambda$1$3(MonteCarloPane this$0, TextField $this$addTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextField, (String)"$this$addTextField");
        $this$addTextField.setPrefColumnCount(4);
        $this$addTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$3$1((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$3$0(this$0, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$3$0(MonteCarloPane this$0, ObservableValue observableValue, String string, String string2) {
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final void lambda$1$3$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit lambda$1$4(MonteCarloPane this$0, TextField $this$addTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextField, (String)"$this$addTextField");
        $this$addTextField.setPrefColumnCount(4);
        $this$addTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$4$1((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$4$0(this$0, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$4$0(MonteCarloPane this$0, ObservableValue observableValue, String string, String string2) {
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final void lambda$1$4$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit lambda$1$5(MonteCarloPane this$0, TextField $this$addTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextField, (String)"$this$addTextField");
        $this$addTextField.setPrefColumnCount(4);
        $this$addTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$5$1((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$5$0(this$0, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$5$0(MonteCarloPane this$0, ObservableValue observableValue, String string, String string2) {
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final void lambda$1$5$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void lambda$1$6(MonteCarloPane this$0, ActionEvent it) {
        this$0.updateChart();
    }

    private static final Unit lambda$1$7(MonteCarloPane this$0, TextField $this$addTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextField, (String)"$this$addTextField");
        $this$addTextField.setPrefColumnCount(4);
        $this$addTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$7$1((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$7$0(this$0, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$7$0(MonteCarloPane this$0, ObservableValue observableValue, String string, String string2) {
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final void lambda$1$7$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit lambda$1$8(MonteCarloPane this$0, TextField $this$addTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextField, (String)"$this$addTextField");
        $this$addTextField.setPrefColumnCount(4);
        $this$addTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$8$1((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$8$0(this$0, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$8$0(MonteCarloPane this$0, ObservableValue observableValue, String string, String string2) {
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final void lambda$1$8$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void lambda$1$9(MonteCarloPane this$0, ActionEvent it) {
        this$0.updateChart();
    }

    private static final Unit lambda$1$10(MonteCarloPane this$0, TextField $this$addTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextField, (String)"$this$addTextField");
        $this$addTextField.setPrefColumnCount(4);
        $this$addTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$10$1((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$10$0(this$0, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$10$0(MonteCarloPane this$0, ObservableValue observableValue, String string, String string2) {
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final void lambda$1$10$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit lambda$1$11(MonteCarloPane this$0, TextField $this$addTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextField, (String)"$this$addTextField");
        $this$addTextField.setPrefColumnCount(4);
        $this$addTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$11$1((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$11$0(this$0, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$11$0(MonteCarloPane this$0, ObservableValue observableValue, String string, String string2) {
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final void lambda$1$11$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void lambda$1$12(MonteCarloPane this$0, ActionEvent it) {
        this$0.updateChart();
    }

    private static final Unit lambda$1$13(MonteCarloPane this$0, TextField $this$addTextField) {
        Intrinsics.checkNotNullParameter((Object)$this$addTextField, (String)"$this$addTextField");
        $this$addTextField.setPrefColumnCount(4);
        $this$addTextField.textProperty().addListener((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$13$1((arg_0, arg_1, arg_2) -> MonteCarloPane.lambda$1$13$0(this$0, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$1$13$0(MonteCarloPane this$0, ObservableValue observableValue, String string, String string2) {
        this$0.updateChart();
        return Unit.INSTANCE;
    }

    private static final void lambda$1$13$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }
}

