/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot.interaction;

import com.xorrus.trading.lot.app.plot.PnLViewModel;
import com.xorrus.trading.lot.app.plot.interaction.CursorExitEvent;
import com.xorrus.trading.lot.app.plot.interaction.CursorMoveEvent;
import com.xorrus.trading.lot.app.plot.interaction.InteractionEvent;
import com.xorrus.trading.lot.app.plot.interaction.PanEvent;
import com.xorrus.trading.lot.app.plot.interaction.ResetZoomXEvent;
import com.xorrus.trading.lot.app.plot.interaction.ResetZoomYEvent;
import com.xorrus.trading.lot.app.plot.interaction.ZoomXEvent;
import com.xorrus.trading.lot.app.plot.interaction.ZoomYEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/xorrus/trading/lot/app/plot/interaction/PnLInteractionHandler;", "Lkotlin/Function1;", "Lcom/xorrus/trading/lot/app/plot/interaction/InteractionEvent;", "", "viewModel", "Lcom/xorrus/trading/lot/app/plot/PnLViewModel;", "<init>", "(Lcom/xorrus/trading/lot/app/plot/PnLViewModel;)V", "invoke", "event", "laboftrades-app"})
public final class PnLInteractionHandler
implements Function1<InteractionEvent, Unit> {
    @NotNull
    private final PnLViewModel viewModel;

    public PnLInteractionHandler(@NotNull PnLViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.viewModel = viewModel;
    }

    public void invoke(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InteractionEvent interactionEvent = event;
        if (interactionEvent instanceof PanEvent) {
            this.viewModel.pan(((PanEvent)event).getDxPixels(), ((PanEvent)event).getDyPixels(), ((PanEvent)event).getTotalWidth(), ((PanEvent)event).getTotalHeight());
        } else if (interactionEvent instanceof ZoomXEvent) {
            this.viewModel.zoomX(((ZoomXEvent)event).getFactor(), ((ZoomXEvent)event).getMouseX(), ((ZoomXEvent)event).getTotalWidth());
        } else if (interactionEvent instanceof ZoomYEvent) {
            this.viewModel.zoomY(((ZoomYEvent)event).getFactor(), ((ZoomYEvent)event).getMouseY(), ((ZoomYEvent)event).getTotalHeight());
        } else if (Intrinsics.areEqual((Object)interactionEvent, (Object)ResetZoomXEvent.INSTANCE)) {
            this.viewModel.resetX();
        } else if (Intrinsics.areEqual((Object)interactionEvent, (Object)ResetZoomYEvent.INSTANCE)) {
            this.viewModel.resetY();
        } else if (interactionEvent instanceof CursorMoveEvent) {
            this.viewModel.updateCursor(((CursorMoveEvent)event).getX(), ((CursorMoveEvent)event).getY());
        } else if (Intrinsics.areEqual((Object)interactionEvent, (Object)CursorExitEvent.INSTANCE)) {
            this.viewModel.clearCursor();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

