/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.view.strategy;

import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.common.TimezoneKt;
import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.OHLCV;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.datetime.DatePeriod;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateRange;
import kotlinx.datetime.TimeZone;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a?\u0010\u0000\u001a\u001d\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002\u001a\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b*\b\u0012\u0004\u0012\u00020\u000b0\bH\u0002\u001a\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u001a&\u0010\u0010\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00110\b2\b\b\u0002\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\u0013\u001a\u00020\u0002H\u0002\"\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0018\u0010\u0018\u001a\u00020\u0015*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\"\u0018\u0010\u001a\u001a\u00020\u0015*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006\u001c"}, d2={"buildTermStructure", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "dte", "", "dtes", "", "ivs", "filterDates", "Lkotlinx/datetime/LocalDate;", "expectedMove", "straddle", "Lcom/xorrus/trading/common/bignum/XBigNum;", "underlyingPrice", "yangZhang", "Lcom/xorrus/trading/common/contract/OHLCV;", "window", "tradingPeriods", "years", "Lkotlinx/datetime/DatePeriod;", "getYears", "(I)Lkotlinx/datetime/DatePeriod;", "months", "getMonths", "days", "getDays", "laboftrades-app"})
@SourceDebugExtension(value={"SMAP\nEarningsVolaEdgePane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EarningsVolaEdgePane.kt\ncom/xorrus/trading/lot/app/view/strategy/EarningsVolaEdgePaneKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,425:1\n1#2:426\n295#3,2:427\n774#3:429\n865#3,2:430\n1563#3:432\n1634#3,3:433\n1563#3:436\n1634#3,3:437\n1563#3:440\n1634#3,3:441\n*S KotlinDebug\n*F\n+ 1 EarningsVolaEdgePane.kt\ncom/xorrus/trading/lot/app/view/strategy/EarningsVolaEdgePaneKt\n*L\n364#1:427,2\n367#1:429\n367#1:430,2\n382#1:432\n382#1:433,3\n388#1:436\n388#1:437,3\n394#1:440\n394#1:441,3\n*E\n"})
public final class EarningsVolaEdgePaneKt {
    private static final Function1<Integer, Double> buildTermStructure(List<Integer> dtes, List<Double> ivs) {
        if (!(!((Collection)dtes).isEmpty())) {
            boolean $i$a$-require-EarningsVolaEdgePaneKt$buildTermStructure$32 = false;
            String $i$a$-require-EarningsVolaEdgePaneKt$buildTermStructure$32 = "Keine (dte, iv)-Punkte vorhanden.";
            throw new IllegalArgumentException($i$a$-require-EarningsVolaEdgePaneKt$buildTermStructure$32.toString());
        }
        if (!(dtes.size() == ivs.size())) {
            boolean bl = false;
            String string = "dtes.size != ivs.size";
            throw new IllegalArgumentException(string.toString());
        }
        if (dtes.size() == 1) {
            double v = ((Number)CollectionsKt.first(ivs)).doubleValue();
            return arg_0 -> EarningsVolaEdgePaneKt.buildTermStructure$lambda$2(v, arg_0);
        }
        return arg_0 -> EarningsVolaEdgePaneKt.buildTermStructure$lambda$3(dtes, ivs, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<LocalDate> filterDates(List<LocalDate> $this$filterDates) {
        void $this$filterTo$iv$iv;
        Object v0;
        LocalDate today;
        List datesSorted;
        block3: {
            datesSorted = CollectionsKt.sorted((Iterable)$this$filterDates);
            today = DateKt.today((TimeZone)TimezoneKt.getNewYorkTimezone());
            LocalDate minCutOff = LocalDateKt.plus((LocalDate)today, (int)45, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getDAY()));
            Iterable $this$firstOrNull$iv = datesSorted;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LocalDate it = (LocalDate)element$iv;
                boolean bl = false;
                if (!(it.compareTo(minCutOff) >= 0)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        LocalDate localDate = v0;
        if (localDate == null) {
            throw new IllegalStateException("no expiration >= 45 days".toString());
        }
        LocalDate cutOff = localDate;
        LocalDateRange range = LocalDateKt.plus((LocalDate)today, (int)1, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getDAY())).rangeTo(cutOff);
        Iterable $this$filter$iv = datesSorted;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LocalDate it = (LocalDate)element$iv$iv;
            boolean bl = false;
            if (!range.contains((Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final double expectedMove(XBigNum straddle, XBigNum underlyingPrice) {
        double s = XbignumKt.toDouble((XBigNum)straddle);
        double p = XbignumKt.toDouble((XBigNum)underlyingPrice);
        return s / p * 100.2;
    }

    /*
     * WARNING - void declaration
     */
    private static final double yangZhang(List<OHLCV> $this$yangZhang, int window, int tradingPeriods) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        int n;
        Collection collection;
        void $this$mapTo$iv$iv3;
        if ($this$yangZhang.size() < window + 1) {
            return Double.NaN;
        }
        List slice = CollectionsKt.takeLast($this$yangZhang, (int)(window + 1));
        int n2 = window;
        Iterable $this$map$iv = (Iterable)new IntRange(1, n2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv3.iterator();
        while (iterator.hasNext()) {
            XBigNum c;
            void t;
            int item$iv$iv;
            int n3 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            n = 0;
            XBigNum o = ((OHLCV)slice.get((int)t)).getOpen();
            XBigNum xBigNum = c = ((OHLCV)slice.get((int)t)).getClose();
            Intrinsics.checkNotNull((Object)xBigNum);
            double d = XbignumKt.toDouble((XBigNum)xBigNum);
            XBigNum xBigNum2 = o;
            Intrinsics.checkNotNull((Object)xBigNum2);
            collection.add(Math.log(d / XbignumKt.toDouble((XBigNum)xBigNum2)));
        }
        List r = (List)destination$iv$iv;
        Iterable $this$map$iv2 = (Iterable)new IntRange(1, n2);
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator item$iv$iv = $this$mapTo$iv$iv2.iterator();
        while (item$iv$iv.hasNext()) {
            void t;
            int item$iv$iv2;
            n = item$iv$iv2 = ((IntIterator)item$iv$iv).nextInt();
            collection = destination$iv$iv2;
            boolean bl = false;
            XBigNum o = ((OHLCV)slice.get((int)t)).getOpen();
            XBigNum prevC = ((OHLCV)slice.get((int)(t - true))).getClose();
            XBigNum xBigNum = o;
            Intrinsics.checkNotNull((Object)xBigNum);
            double d = XbignumKt.toDouble((XBigNum)xBigNum);
            XBigNum xBigNum3 = prevC;
            Intrinsics.checkNotNull((Object)xBigNum3);
            collection.add(Math.log(d / XbignumKt.toDouble((XBigNum)xBigNum3)));
        }
        List u = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = (Iterable)new IntRange(1, n2);
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void t;
            int item$iv$iv3;
            int bl = item$iv$iv3 = ((IntIterator)iterator2).nextInt();
            collection = destination$iv$iv3;
            boolean bl2 = false;
            XBigNum o = ((OHLCV)slice.get((int)t)).getOpen();
            XBigNum h = ((OHLCV)slice.get((int)t)).getHigh();
            XBigNum l = ((OHLCV)slice.get((int)t)).getLow();
            XBigNum c = ((OHLCV)slice.get((int)t)).getClose();
            XBigNum xBigNum = h;
            Intrinsics.checkNotNull((Object)xBigNum);
            double d = XbignumKt.toDouble((XBigNum)xBigNum);
            XBigNum xBigNum4 = o;
            Intrinsics.checkNotNull((Object)xBigNum4);
            double d2 = Math.log(d / XbignumKt.toDouble((XBigNum)xBigNum4));
            double d3 = XbignumKt.toDouble((XBigNum)h);
            XBigNum xBigNum5 = c;
            Intrinsics.checkNotNull((Object)xBigNum5);
            double d4 = d2 * Math.log(d3 / XbignumKt.toDouble((XBigNum)xBigNum5));
            XBigNum xBigNum6 = l;
            Intrinsics.checkNotNull((Object)xBigNum6);
            collection.add(d4 + Math.log(XbignumKt.toDouble((XBigNum)xBigNum6) / XbignumKt.toDouble((XBigNum)o)) * Math.log(XbignumKt.toDouble((XBigNum)l) / XbignumKt.toDouble((XBigNum)c)));
        }
        List rs = (List)destination$iv$iv3;
        double sigmaR2 = EarningsVolaEdgePaneKt.yangZhang$variance(r);
        double sigmaU2 = EarningsVolaEdgePaneKt.yangZhang$variance(u);
        double sigmaRS2 = CollectionsKt.averageOfDouble((Iterable)rs);
        double k = 0.34 / (1.34 + ((double)n2 + 1.0) / ((double)n2 - 1.0));
        double sigmaYZ2 = sigmaU2 + k * sigmaR2 + (1.0 - k) * sigmaRS2;
        return Math.sqrt(sigmaYZ2) * Math.sqrt(tradingPeriods);
    }

    static /* synthetic */ double yangZhang$default(List list, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 30;
        }
        if ((n3 & 2) != 0) {
            n2 = 252;
        }
        return EarningsVolaEdgePaneKt.yangZhang(list, n, n2);
    }

    private static final DatePeriod getYears(int $this$years) {
        return new DatePeriod($this$years, 0, 0);
    }

    private static final DatePeriod getMonths(int $this$months) {
        return new DatePeriod(0, $this$months, 0);
    }

    private static final DatePeriod getDays(int $this$days) {
        return new DatePeriod(0, 0, $this$days);
    }

    private static final double buildTermStructure$lambda$2(double $v, int n) {
        return $v;
    }

    private static final double buildTermStructure$lambda$3(List $dtes, List $ivs, int qDte) {
        double d;
        if (qDte <= ((Number)CollectionsKt.first((List)$dtes)).intValue()) {
            return ((Number)CollectionsKt.first((List)$ivs)).doubleValue();
        }
        if (qDte >= ((Number)CollectionsKt.last((List)$dtes)).intValue()) {
            return ((Number)CollectionsKt.last((List)$ivs)).doubleValue();
        }
        int idx = CollectionsKt.binarySearch$default((List)$dtes, (Comparable)Integer.valueOf(qDte), (int)0, (int)0, (int)6, null);
        if (idx >= 0) {
            d = ((Number)$ivs.get(idx)).doubleValue();
        } else {
            int ip = -idx - 1;
            int i0 = ip - 1;
            int i1 = ip;
            double x0 = ((Number)$dtes.get(i0)).intValue();
            double x1 = ((Number)$dtes.get(i1)).intValue();
            double y0 = ((Number)$ivs.get(i0)).doubleValue();
            double y1 = ((Number)$ivs.get(i1)).doubleValue();
            d = y0 + ((double)qDte - x0) * (y1 - y0) / (x1 - x0);
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    private static final double yangZhang$variance(List<Double> values) {
        double mean = CollectionsKt.averageOfDouble((Iterable)values);
        Iterable iterable = values;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            double d2 = ((Number)t).doubleValue();
            double d3 = d;
            boolean bl = false;
            void var13_9 = (it - mean) * (it - mean);
            d = d3 + var13_9;
        }
        return d / (double)(values.size() - 1);
    }

    public static final /* synthetic */ List access$filterDates(List $receiver) {
        return EarningsVolaEdgePaneKt.filterDates($receiver);
    }

    public static final /* synthetic */ Function1 access$buildTermStructure(List dtes, List ivs) {
        return EarningsVolaEdgePaneKt.buildTermStructure(dtes, ivs);
    }
}

