/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot.renderer;

import com.xorrus.trading.lot.app.plot.PnLCalculator;
import com.xorrus.trading.lot.app.plot.PnLDiagramData;
import com.xorrus.trading.lot.app.plot.PnLDiagramState;
import com.xorrus.trading.lot.app.plot.layout.DiagramLayout;
import com.xorrus.trading.lot.app.plot.renderer.CurveStyle;
import com.xorrus.trading.lot.app.plot.renderer.PnLRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.Point;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u00102\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/xorrus/trading/lot/app/plot/renderer/PnLCurveRenderer;", "Lcom/xorrus/trading/lot/app/plot/renderer/PnLRenderer;", "style", "Lcom/xorrus/trading/lot/app/plot/renderer/CurveStyle;", "timeFraction", "", "<init>", "(Lcom/xorrus/trading/lot/app/plot/renderer/CurveStyle;D)V", "render", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "Lcom/xorrus/trading/lot/app/plot/SkiaCanvas;", "state", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramState;", "computePoints", "", "Lorg/jetbrains/skia/Point;", "Lcom/xorrus/trading/lot/app/plot/SkiaPoint;", "pixelStep", "", "laboftrades-app"})
public final class PnLCurveRenderer
implements PnLRenderer {
    @NotNull
    private final CurveStyle style;
    private final double timeFraction;

    public PnLCurveRenderer(@NotNull CurveStyle style, double timeFraction) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.style = style;
        this.timeFraction = timeFraction;
    }

    @Override
    public void render(@NotNull Canvas canvas, @NotNull PnLDiagramState state) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List points = PnLCurveRenderer.computePoints$default(this, state, 0.0f, 2, null);
        if (points.size() < 2) {
            return;
        }
        Path $this$render_u24lambda_u240 = path = new Path();
        boolean bl = false;
        $this$render_u24lambda_u240.moveTo(((Point)CollectionsKt.first((List)points)).getX(), ((Point)CollectionsKt.first((List)points)).getY());
        int n = points.size();
        for (int i = 1; i < n; ++i) {
            $this$render_u24lambda_u240.lineTo((Point)points.get(i));
        }
        Path path2 = path;
        Paint paint = this.style.createPaint();
        canvas.drawPath(path2, paint);
    }

    private final List<Point> computePoints(PnLDiagramState state, float pixelStep) {
        DiagramLayout layout = state.getLayout();
        PnLDiagramData data = state.getData();
        float plotLeft = layout.getOriginX();
        float plotRight = state.getWidth();
        float plotBottom = layout.getOriginY();
        float plotTop = 0.0f;
        ClosedRange<Double> xRange = state.getXRange();
        ClosedRange<Double> yRange = state.getYRange();
        double xSpan = ((Number)((Object)xRange.getEndInclusive())).doubleValue() - ((Number)((Object)xRange.getStart())).doubleValue();
        double ySpan = ((Number)((Object)yRange.getEndInclusive())).doubleValue() - ((Number)((Object)yRange.getStart())).doubleValue();
        float plotWidth = plotRight - plotLeft;
        float plotHeight = plotBottom - plotTop;
        int numSteps = RangesKt.coerceAtLeast((int)((int)(plotWidth / pixelStep)), (int)2);
        ArrayList points = new ArrayList(numSteps + 1);
        int i = 0;
        if (i <= numSteps) {
            while (true) {
                float xScreen = plotLeft + (float)i * pixelStep;
                double xDomain = ((Number)((Object)xRange.getStart())).doubleValue() + (double)((float)i * pixelStep / plotWidth) * xSpan;
                double pnlDomain = PnLCalculator.INSTANCE.computePnLAtPrice(data, xDomain, this.timeFraction);
                float yRatio = (float)((pnlDomain - ((Number)((Object)yRange.getStart())).doubleValue()) / ySpan);
                float yScreen = plotBottom - yRatio * plotHeight;
                ((Collection)points).add(new Point(xScreen, yScreen));
                if (i == numSteps) break;
                ++i;
            }
        }
        return points;
    }

    static /* synthetic */ List computePoints$default(PnLCurveRenderer pnLCurveRenderer, PnLDiagramState pnLDiagramState, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        return pnLCurveRenderer.computePoints(pnLDiagramState, f);
    }
}

