/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot;

import com.xorrus.trading.common.BlackscholeKt;
import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.common.contract.Right;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b#\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u00019Bw\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010#\u001a\u0004\u0018\u00010\bJ\b\u0010$\u001a\u0004\u0018\u00010\bJ\u0016\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\bH\u00c6\u0003J\u0010\u0010,\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010-\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001bJ\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J~\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00c6\u0001\u00a2\u0006\u0002\u00102J\u0013\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00106\u001a\u000207H\u00d6\u0001J\t\u00108\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001bR\u0015\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006:"}, d2={"Lcom/xorrus/trading/lot/app/plot/PnLDiagramData;", "", "xScale", "", "volatility", "volatilityShift", "interestRate", "currentTime", "Lkotlin/time/Instant;", "underlyingPrice", "underlyingEntryPrice", "underlyingQuantity", "options", "", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramData$OptionLeg;", "currency", "", "<init>", "(DDDDLkotlin/time/Instant;Ljava/lang/Double;Ljava/lang/Double;DLjava/util/List;Ljava/lang/String;)V", "getXScale", "()D", "getVolatility", "getVolatilityShift", "getInterestRate", "getCurrentTime", "()Lkotlin/time/Instant;", "getUnderlyingPrice", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getUnderlyingEntryPrice", "getUnderlyingQuantity", "getOptions", "()Ljava/util/List;", "getCurrency", "()Ljava/lang/String;", "getLatestExpiration", "getFirstExpiration", "getExpectedPnL", "instant", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "copy", "(DDDDLkotlin/time/Instant;Ljava/lang/Double;Ljava/lang/Double;DLjava/util/List;Ljava/lang/String;)Lcom/xorrus/trading/lot/app/plot/PnLDiagramData;", "equals", "", "other", "hashCode", "", "toString", "OptionLeg", "laboftrades-app"})
@SourceDebugExtension(value={"SMAP\nPnLDiagramData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PnLDiagramData.kt\ncom/xorrus/trading/lot/app/plot/PnLDiagramData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1740#2,3:122\n1740#2,3:125\n1#3:128\n*S KotlinDebug\n*F\n+ 1 PnLDiagramData.kt\ncom/xorrus/trading/lot/app/plot/PnLDiagramData\n*L\n42#1:122,3\n43#1:125,3\n*E\n"})
public final class PnLDiagramData {
    private final double xScale;
    private final double volatility;
    private final double volatilityShift;
    private final double interestRate;
    @NotNull
    private final Instant currentTime;
    @Nullable
    private final Double underlyingPrice;
    @Nullable
    private final Double underlyingEntryPrice;
    private final double underlyingQuantity;
    @NotNull
    private final List<OptionLeg> options;
    @Nullable
    private final String currency;

    public PnLDiagramData(double xScale, double volatility, double volatilityShift, double interestRate, @NotNull Instant currentTime, @Nullable Double underlyingPrice, @Nullable Double underlyingEntryPrice, double underlyingQuantity, @NotNull List<OptionLeg> options, @Nullable String currency) {
        boolean bl;
        block11: {
            OptionLeg it;
            boolean bl2;
            boolean $i$f$all2;
            Iterable $this$all$iv;
            block10: {
                Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
                Intrinsics.checkNotNullParameter(options, (String)"options");
                this.xScale = xScale;
                this.volatility = volatility;
                this.volatilityShift = volatilityShift;
                this.interestRate = interestRate;
                this.currentTime = currentTime;
                this.underlyingPrice = underlyingPrice;
                this.underlyingEntryPrice = underlyingEntryPrice;
                this.underlyingQuantity = underlyingQuantity;
                this.options = options;
                this.currency = currency;
                if (!(this.interestRate > 0.0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(this.underlyingQuantity == 0.0) && !(this.underlyingEntryPrice != null && this.underlyingEntryPrice > 0.0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                $this$all$iv = this.options;
                $i$f$all2 = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (OptionLeg)element$iv;
                        boolean bl3 = false;
                        if (it.getEntryPrice() > 0.0) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                String $i$f$all2 = "Failed requirement.";
                throw new IllegalArgumentException($i$f$all2.toString());
            }
            $this$all$iv = this.options;
            $i$f$all2 = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (OptionLeg)element$iv;
                    boolean bl4 = false;
                    if (it.getStrike() > 0.0) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ PnLDiagramData(double d, double d2, double d3, double d4, Instant instant, Double d5, Double d6, double d7, List list, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.05;
        }
        if ((n & 2) != 0) {
            d2 = 0.2;
        }
        if ((n & 4) != 0) {
            d3 = 0.0;
        }
        if ((n & 8) != 0) {
            d4 = 0.05;
        }
        if ((n & 0x10) != 0) {
            instant = DateKt.now();
        }
        if ((n & 0x20) != 0) {
            d5 = null;
        }
        if ((n & 0x40) != 0) {
            d6 = null;
        }
        if ((n & 0x80) != 0) {
            d7 = 0.0;
        }
        if ((n & 0x100) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x200) != 0) {
            string = null;
        }
        this(d, d2, d3, d4, instant, d5, d6, d7, list, string);
    }

    public final double getXScale() {
        return this.xScale;
    }

    public final double getVolatility() {
        return this.volatility;
    }

    public final double getVolatilityShift() {
        return this.volatilityShift;
    }

    public final double getInterestRate() {
        return this.interestRate;
    }

    @NotNull
    public final Instant getCurrentTime() {
        return this.currentTime;
    }

    @Nullable
    public final Double getUnderlyingPrice() {
        return this.underlyingPrice;
    }

    @Nullable
    public final Double getUnderlyingEntryPrice() {
        return this.underlyingEntryPrice;
    }

    public final double getUnderlyingQuantity() {
        return this.underlyingQuantity;
    }

    @NotNull
    public final List<OptionLeg> getOptions() {
        return this.options;
    }

    @Nullable
    public final String getCurrency() {
        return this.currency;
    }

    @Nullable
    public final Instant getLatestExpiration() {
        Comparable comparable;
        Iterator iterator = ((Iterable)this.options).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            OptionLeg it = (OptionLeg)iterator.next();
            boolean bl = false;
            Comparable comparable2 = (Comparable)it.getExpiration();
            while (iterator.hasNext()) {
                OptionLeg it2 = (OptionLeg)iterator.next();
                $i$a$-maxOfOrNull-PnLDiagramData$getLatestExpiration$1 = false;
                Comparable comparable3 = (Comparable)it2.getExpiration();
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        return (Instant)comparable;
    }

    @Nullable
    public final Instant getFirstExpiration() {
        Comparable comparable;
        Iterator iterator = ((Iterable)this.options).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            OptionLeg it = (OptionLeg)iterator.next();
            boolean bl = false;
            Comparable comparable2 = (Comparable)it.getExpiration();
            while (iterator.hasNext()) {
                OptionLeg it2 = (OptionLeg)iterator.next();
                $i$a$-minOfOrNull-PnLDiagramData$getFirstExpiration$1 = false;
                Comparable comparable3 = (Comparable)it2.getExpiration();
                if (comparable2.compareTo(comparable3) <= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        return (Instant)comparable;
    }

    /*
     * WARNING - void declaration
     */
    public final double getExpectedPnL(@NotNull Instant instant, double underlyingPrice) {
        double d;
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        if (this.underlyingQuantity == 0.0) {
            d = 0.0;
        } else {
            Double d2 = this.underlyingEntryPrice;
            Intrinsics.checkNotNull((Object)d2);
            d = (underlyingPrice - d2) * this.underlyingQuantity;
        }
        double underlyingPnL = d;
        Iterable iterable = this.options;
        double d3 = 0.0;
        for (Object t : iterable) {
            double d4;
            void leg;
            double d5;
            block8: {
                double timeToExpiry;
                block7: {
                    OptionLeg optionLeg = (OptionLeg)t;
                    d5 = d3;
                    boolean bl = false;
                    timeToExpiry = BlackscholeKt.yearsBetween((Instant)instant, (Instant)leg.getExpiration());
                    if (!(timeToExpiry <= 0.0)) break block7;
                    switch (WhenMappings.$EnumSwitchMapping$0[leg.getRight().ordinal()]) {
                        case 1: {
                            d4 = Math.max(0.0, underlyingPrice - leg.getStrike());
                            break block8;
                        }
                        case 2: {
                            d4 = Math.max(0.0, leg.getStrike() - underlyingPrice);
                            break block8;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                d4 = leg.getPriceByBlackScholes(underlyingPrice, this.interestRate, this.volatility + this.volatilityShift, timeToExpiry);
            }
            double optionPrice = d4;
            double d6 = leg.getQuantity() * (optionPrice - leg.getEntryPrice());
            d3 = d5 + d6;
        }
        double optionsPnL = d3;
        return underlyingPnL + optionsPnL;
    }

    public final double component1() {
        return this.xScale;
    }

    public final double component2() {
        return this.volatility;
    }

    public final double component3() {
        return this.volatilityShift;
    }

    public final double component4() {
        return this.interestRate;
    }

    @NotNull
    public final Instant component5() {
        return this.currentTime;
    }

    @Nullable
    public final Double component6() {
        return this.underlyingPrice;
    }

    @Nullable
    public final Double component7() {
        return this.underlyingEntryPrice;
    }

    public final double component8() {
        return this.underlyingQuantity;
    }

    @NotNull
    public final List<OptionLeg> component9() {
        return this.options;
    }

    @Nullable
    public final String component10() {
        return this.currency;
    }

    @NotNull
    public final PnLDiagramData copy(double xScale, double volatility, double volatilityShift, double interestRate, @NotNull Instant currentTime, @Nullable Double underlyingPrice, @Nullable Double underlyingEntryPrice, double underlyingQuantity, @NotNull List<OptionLeg> options, @Nullable String currency) {
        Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return new PnLDiagramData(xScale, volatility, volatilityShift, interestRate, currentTime, underlyingPrice, underlyingEntryPrice, underlyingQuantity, options, currency);
    }

    public static /* synthetic */ PnLDiagramData copy$default(PnLDiagramData pnLDiagramData, double d, double d2, double d3, double d4, Instant instant, Double d5, Double d6, double d7, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            d = pnLDiagramData.xScale;
        }
        if ((n & 2) != 0) {
            d2 = pnLDiagramData.volatility;
        }
        if ((n & 4) != 0) {
            d3 = pnLDiagramData.volatilityShift;
        }
        if ((n & 8) != 0) {
            d4 = pnLDiagramData.interestRate;
        }
        if ((n & 0x10) != 0) {
            instant = pnLDiagramData.currentTime;
        }
        if ((n & 0x20) != 0) {
            d5 = pnLDiagramData.underlyingPrice;
        }
        if ((n & 0x40) != 0) {
            d6 = pnLDiagramData.underlyingEntryPrice;
        }
        if ((n & 0x80) != 0) {
            d7 = pnLDiagramData.underlyingQuantity;
        }
        if ((n & 0x100) != 0) {
            list = pnLDiagramData.options;
        }
        if ((n & 0x200) != 0) {
            string = pnLDiagramData.currency;
        }
        return pnLDiagramData.copy(d, d2, d3, d4, instant, d5, d6, d7, list, string);
    }

    @NotNull
    public String toString() {
        return "PnLDiagramData(xScale=" + this.xScale + ", volatility=" + this.volatility + ", volatilityShift=" + this.volatilityShift + ", interestRate=" + this.interestRate + ", currentTime=" + this.currentTime + ", underlyingPrice=" + this.underlyingPrice + ", underlyingEntryPrice=" + this.underlyingEntryPrice + ", underlyingQuantity=" + this.underlyingQuantity + ", options=" + this.options + ", currency=" + this.currency + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.xScale);
        result = result * 31 + Double.hashCode(this.volatility);
        result = result * 31 + Double.hashCode(this.volatilityShift);
        result = result * 31 + Double.hashCode(this.interestRate);
        result = result * 31 + this.currentTime.hashCode();
        result = result * 31 + (this.underlyingPrice == null ? 0 : ((Object)this.underlyingPrice).hashCode());
        result = result * 31 + (this.underlyingEntryPrice == null ? 0 : ((Object)this.underlyingEntryPrice).hashCode());
        result = result * 31 + Double.hashCode(this.underlyingQuantity);
        result = result * 31 + ((Object)this.options).hashCode();
        result = result * 31 + (this.currency == null ? 0 : this.currency.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PnLDiagramData)) {
            return false;
        }
        PnLDiagramData pnLDiagramData = (PnLDiagramData)other;
        if (Double.compare(this.xScale, pnLDiagramData.xScale) != 0) {
            return false;
        }
        if (Double.compare(this.volatility, pnLDiagramData.volatility) != 0) {
            return false;
        }
        if (Double.compare(this.volatilityShift, pnLDiagramData.volatilityShift) != 0) {
            return false;
        }
        if (Double.compare(this.interestRate, pnLDiagramData.interestRate) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.currentTime, (Object)pnLDiagramData.currentTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.underlyingPrice, (Object)pnLDiagramData.underlyingPrice)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.underlyingEntryPrice, (Object)pnLDiagramData.underlyingEntryPrice)) {
            return false;
        }
        if (Double.compare(this.underlyingQuantity, pnLDiagramData.underlyingQuantity) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual(this.options, pnLDiagramData.options)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.currency, (Object)pnLDiagramData.currency);
    }

    public PnLDiagramData() {
        this(0.0, 0.0, 0.0, 0.0, null, null, null, 0.0, null, null, 1023, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ&\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016JL\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0015\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006,"}, d2={"Lcom/xorrus/trading/lot/app/plot/PnLDiagramData$OptionLeg;", "", "strike", "", "right", "Lcom/xorrus/trading/common/contract/Right;", "expiration", "Lkotlin/time/Instant;", "quantity", "entryPrice", "currentPrice", "<init>", "(DLcom/xorrus/trading/common/contract/Right;Lkotlin/time/Instant;DDLjava/lang/Double;)V", "getStrike", "()D", "getRight", "()Lcom/xorrus/trading/common/contract/Right;", "getExpiration", "()Lkotlin/time/Instant;", "getQuantity", "getEntryPrice", "getCurrentPrice", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getPriceByBlackScholes", "underlyingPrice", "interestRate", "volatility", "timeToExpiry", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(DLcom/xorrus/trading/common/contract/Right;Lkotlin/time/Instant;DDLjava/lang/Double;)Lcom/xorrus/trading/lot/app/plot/PnLDiagramData$OptionLeg;", "equals", "", "other", "hashCode", "", "toString", "", "laboftrades-app"})
    public static final class OptionLeg {
        private final double strike;
        @NotNull
        private final Right right;
        @NotNull
        private final Instant expiration;
        private final double quantity;
        private final double entryPrice;
        @Nullable
        private final Double currentPrice;

        public OptionLeg(double strike, @NotNull Right right, @NotNull Instant expiration, double quantity, double entryPrice, @Nullable Double currentPrice) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
            this.strike = strike;
            this.right = right;
            this.expiration = expiration;
            this.quantity = quantity;
            this.entryPrice = entryPrice;
            this.currentPrice = currentPrice;
        }

        public final double getStrike() {
            return this.strike;
        }

        @NotNull
        public final Right getRight() {
            return this.right;
        }

        @NotNull
        public final Instant getExpiration() {
            return this.expiration;
        }

        public final double getQuantity() {
            return this.quantity;
        }

        public final double getEntryPrice() {
            return this.entryPrice;
        }

        @Nullable
        public final Double getCurrentPrice() {
            return this.currentPrice;
        }

        public final double getPriceByBlackScholes(double underlyingPrice, double interestRate, double volatility, double timeToExpiry) {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.right.ordinal()]) {
                case 1 -> BlackscholeKt.preisCall((double)underlyingPrice, (double)interestRate, (double)volatility, (double)timeToExpiry, (double)this.strike);
                case 2 -> BlackscholeKt.preisPut((double)underlyingPrice, (double)interestRate, (double)volatility, (double)timeToExpiry, (double)this.strike);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public final double component1() {
            return this.strike;
        }

        @NotNull
        public final Right component2() {
            return this.right;
        }

        @NotNull
        public final Instant component3() {
            return this.expiration;
        }

        public final double component4() {
            return this.quantity;
        }

        public final double component5() {
            return this.entryPrice;
        }

        @Nullable
        public final Double component6() {
            return this.currentPrice;
        }

        @NotNull
        public final OptionLeg copy(double strike, @NotNull Right right, @NotNull Instant expiration, double quantity, double entryPrice, @Nullable Double currentPrice) {
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            Intrinsics.checkNotNullParameter((Object)expiration, (String)"expiration");
            return new OptionLeg(strike, right, expiration, quantity, entryPrice, currentPrice);
        }

        public static /* synthetic */ OptionLeg copy$default(OptionLeg optionLeg, double d, Right right, Instant instant, double d2, double d3, Double d4, int n, Object object) {
            if ((n & 1) != 0) {
                d = optionLeg.strike;
            }
            if ((n & 2) != 0) {
                right = optionLeg.right;
            }
            if ((n & 4) != 0) {
                instant = optionLeg.expiration;
            }
            if ((n & 8) != 0) {
                d2 = optionLeg.quantity;
            }
            if ((n & 0x10) != 0) {
                d3 = optionLeg.entryPrice;
            }
            if ((n & 0x20) != 0) {
                d4 = optionLeg.currentPrice;
            }
            return optionLeg.copy(d, right, instant, d2, d3, d4);
        }

        @NotNull
        public String toString() {
            return "OptionLeg(strike=" + this.strike + ", right=" + this.right + ", expiration=" + this.expiration + ", quantity=" + this.quantity + ", entryPrice=" + this.entryPrice + ", currentPrice=" + this.currentPrice + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.strike);
            result = result * 31 + this.right.hashCode();
            result = result * 31 + this.expiration.hashCode();
            result = result * 31 + Double.hashCode(this.quantity);
            result = result * 31 + Double.hashCode(this.entryPrice);
            result = result * 31 + (this.currentPrice == null ? 0 : ((Object)this.currentPrice).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OptionLeg)) {
                return false;
            }
            OptionLeg optionLeg = (OptionLeg)other;
            if (Double.compare(this.strike, optionLeg.strike) != 0) {
                return false;
            }
            if (this.right != optionLeg.right) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expiration, (Object)optionLeg.expiration)) {
                return false;
            }
            if (Double.compare(this.quantity, optionLeg.quantity) != 0) {
                return false;
            }
            if (Double.compare(this.entryPrice, optionLeg.entryPrice) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.currentPrice, (Object)optionLeg.currentPrice);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Right.values().length];
                try {
                    nArray[Right.CALL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Right.PUT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Right.values().length];
            try {
                nArray[Right.CALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Right.PUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

