/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot;

import com.xorrus.trading.lot.app.plot.PnLDiagramState;
import com.xorrus.trading.lot.app.plot.SkiaNode;
import com.xorrus.trading.lot.app.plot.interaction.CursorExitEvent;
import com.xorrus.trading.lot.app.plot.interaction.CursorMoveEvent;
import com.xorrus.trading.lot.app.plot.interaction.DiagramMouseController;
import com.xorrus.trading.lot.app.plot.interaction.InteractionEvent;
import com.xorrus.trading.lot.app.plot.interaction.PanEvent;
import com.xorrus.trading.lot.app.plot.interaction.ResetZoomXEvent;
import com.xorrus.trading.lot.app.plot.interaction.ResetZoomYEvent;
import com.xorrus.trading.lot.app.plot.interaction.ZoomXEvent;
import com.xorrus.trading.lot.app.plot.interaction.ZoomYEvent;
import com.xorrus.trading.lot.app.plot.renderer.PnLDiagramRenderer;
import javafx.scene.Node;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00126\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u0006\u0010\u001e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0004\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/xorrus/trading/lot/app/plot/PnLChartNode;", "Lcom/xorrus/trading/lot/app/plot/SkiaNode;", "chartRenderer", "Lcom/xorrus/trading/lot/app/plot/renderer/PnLDiagramRenderer;", "stateProvider", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "width", "height", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramState;", "onEvent", "Lkotlin/Function1;", "Lcom/xorrus/trading/lot/app/plot/interaction/InteractionEvent;", "", "<init>", "(Lcom/xorrus/trading/lot/app/plot/renderer/PnLDiagramRenderer;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "cachedState", "lastWidth", "lastHeight", "mouseController", "Lcom/xorrus/trading/lot/app/plot/interaction/DiagramMouseController;", "draw", "canvas", "Lorg/jetbrains/skia/Canvas;", "getOrCreateState", "shouldInvalidateState", "", "event", "invalidateState", "Companion", "laboftrades-app"})
public final class PnLChartNode
extends SkiaNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PnLDiagramRenderer chartRenderer;
    @NotNull
    private final Function2<Float, Float, PnLDiagramState> stateProvider;
    @NotNull
    private final Function1<InteractionEvent, Unit> onEvent;
    @Nullable
    private PnLDiagramState cachedState;
    private float lastWidth;
    private float lastHeight;
    @NotNull
    private final DiagramMouseController mouseController;
    @NotNull
    private static final Logger logger;

    public PnLChartNode(@NotNull PnLDiagramRenderer chartRenderer, @NotNull Function2<? super Float, ? super Float, PnLDiagramState> stateProvider, @NotNull Function1<? super InteractionEvent, Unit> onEvent) {
        Intrinsics.checkNotNullParameter((Object)chartRenderer, (String)"chartRenderer");
        Intrinsics.checkNotNullParameter(stateProvider, (String)"stateProvider");
        Intrinsics.checkNotNullParameter(onEvent, (String)"onEvent");
        this.chartRenderer = chartRenderer;
        this.stateProvider = stateProvider;
        this.onEvent = onEvent;
        this.mouseController = new DiagramMouseController((Node)this, (Function0<PnLDiagramState>)((Function0)() -> PnLChartNode.mouseController$lambda$0(this)), (Function1<? super InteractionEvent, Unit>)((Function1)arg_0 -> PnLChartNode.mouseController$lambda$1(this, arg_0)));
    }

    public /* synthetic */ PnLChartNode(PnLDiagramRenderer pnLDiagramRenderer, Function2 function2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = PnLChartNode::_init_$lambda$0;
        }
        this(pnLDiagramRenderer, (Function2<? super Float, ? super Float, PnLDiagramState>)function2, (Function1<? super InteractionEvent, Unit>)function1);
    }

    @Override
    public void draw(@NotNull Canvas canvas, float width, float height) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        PnLDiagramState state = this.getOrCreateState(width, height);
        this.chartRenderer.render(canvas, state);
    }

    private final PnLDiagramState getOrCreateState(float width, float height) {
        boolean sizeChanged;
        boolean bl = !(width == this.lastWidth) || !(height == this.lastHeight) ? true : (sizeChanged = false);
        if (sizeChanged || this.cachedState == null) {
            PnLDiagramState newState;
            this.cachedState = newState = (PnLDiagramState)this.stateProvider.invoke((Object)Float.valueOf(width), (Object)Float.valueOf(height));
            this.lastWidth = width;
            this.lastHeight = height;
            logger.debug("PnLChartNode: State recreated ({}\u00d7{})", (Object)Float.valueOf(width), (Object)Float.valueOf(height));
            return newState;
        }
        PnLDiagramState pnLDiagramState = this.cachedState;
        Intrinsics.checkNotNull((Object)pnLDiagramState);
        return pnLDiagramState;
    }

    private final boolean shouldInvalidateState(InteractionEvent event) {
        boolean bl;
        InteractionEvent interactionEvent = event;
        if (interactionEvent instanceof PanEvent || interactionEvent instanceof ZoomXEvent || interactionEvent instanceof ZoomYEvent || interactionEvent instanceof ResetZoomXEvent || interactionEvent instanceof ResetZoomYEvent) {
            bl = true;
        } else if (interactionEvent instanceof CursorMoveEvent || interactionEvent instanceof CursorExitEvent) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final void invalidateState() {
        this.cachedState = null;
    }

    private static final Unit _init_$lambda$0(InteractionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final PnLDiagramState mouseController$lambda$0(PnLChartNode this$0) {
        return this$0.getOrCreateState((float)this$0.getWidth(), (float)this$0.getHeight());
    }

    private static final Unit mouseController$lambda$1(PnLChartNode this$0, InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.onEvent.invoke((Object)event);
        if (this$0.shouldInvalidateState(event)) {
            this$0.invalidateState();
        }
        this$0.repaint();
        return Unit.INSTANCE;
    }

    static {
        Logger logger = LoggerFactory.getLogger(PnLChartNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        PnLChartNode.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/xorrus/trading/lot/app/plot/PnLChartNode$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "laboftrades-app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

