/*
 * Decompiled with CFR 0.152.
 */
package korlibs.bignumber;

import java.util.Arrays;
import korlibs.bignumber.BigInt;
import korlibs.bignumber.BigIntCompanion;
import korlibs.bignumber.BigIntConstructor;
import korlibs.bignumber.BigIntDivisionByZeroException;
import korlibs.bignumber.BigIntException;
import korlibs.bignumber.BigIntInvalidFormatException;
import korlibs.bignumber.BigIntNegativeExponentException;
import korlibs.bignumber.BigIntOverflowException;
import korlibs.bignumber.BigNum;
import korlibs.bignumber.CommonBigIntKt;
import korlibs.bignumber.UInt16ArrayZeroPad;
import korlibs.bignumber.UnsignedBigInt;
import korlibs.bignumber.internal.IntExtKt;
import korlibs.bignumber.ranges.BigIntRange;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 `2\u00020\u00012\u00020\u0002:\u0003`abB\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001b\u001a\u00020\u0000H\u0016J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0004JI\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u000026\u0010\u001f\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00060 H\u0082\bJ\u0011\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0001H\u0096\u0002J\u0006\u0010'\u001a\u00020\u0006J\u0011\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0006H\u0096\u0001J\u0011\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*H\u0096\u0001J\u0011\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020+H\u0096\u0001J\u0019\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0006H\u0096\u0001J\u0011\u0010-\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010-\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0006H\u0096\u0002J\u000e\u0010.\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u0000J\u0010\u00100\u001a\u00020/2\u0006\u0010\u001d\u001a\u00020\u0000H\u0002J\u0013\u00101\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u000102H\u0096\u0002J\u000e\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\u0006J\u000e\u00105\u001a\u00020\u00062\u0006\u00104\u001a\u00020\u0006J\u0010\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0006H\u0002J\u0010\u00108\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0006H\u0002J\b\u00109\u001a\u00020\u0006H\u0016J\b\u0010:\u001a\u00020\u0000H\u0016J\u0006\u0010;\u001a\u00020\u0006J\u0011\u0010<\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010<\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0006H\u0096\u0002J\u0016\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u0006J\u0018\u0010@\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u00002\b\u0010A\u001a\u0004\u0018\u00010BJ\u0011\u0010C\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0004J\u0011\u0010D\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010D\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0006H\u0096\u0002J\u0011\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0001H\u0096\u0004J\u0011\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0006H\u0096\u0004J\u0018\u0010G\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u00062\b\u0010A\u001a\u0004\u0018\u00010BJ\u0011\u0010H\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010H\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0006H\u0096\u0002J\u0011\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u0006H\u0096\u0004J\u0011\u0010K\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u0006H\u0096\u0004J\b\u0010L\u001a\u00020\u0000H\u0016J\u0011\u0010M\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010M\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0006H\u0096\u0002J\u0011\u0010M\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020*H\u0096\u0002J\u0006\u0010N\u001a\u00020OJ\b\u0010P\u001a\u00020\u0006H\u0016J\b\u0010Q\u001a\u00020+H\u0016J\u0010\u0010Q\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0006H\u0016J\u001a\u0010Q\u001a\u00020R2\n\u0010S\u001a\u00060Tj\u0002`U2\u0006\u0010,\u001a\u00020\u0006J\u0014\u0010V\u001a\u00020R2\n\u0010S\u001a\u00060Tj\u0002`UH\u0002J\u0014\u0010W\u001a\u00020R2\n\u0010S\u001a\u00060Tj\u0002`UH\u0002J\u001c\u0010X\u001a\u00020R2\n\u0010S\u001a\u00060Tj\u0002`U2\u0006\u0010,\u001a\u00020\u0006H\u0002J\u0006\u0010Y\u001a\u00020\u0006J\t\u0010Z\u001a\u00020\u0000H\u0096\u0002J\t\u0010[\u001a\u00020\u0000H\u0096\u0002J\u0018\u0010\\\u001a\u00020\u00002\u0006\u0010]\u001a\u00020\u00062\b\b\u0002\u0010^\u001a\u00020\bJ\u0011\u0010_\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0004R\u0011\u0010\n\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017\u00a8\u0006c"}, d2={"Lkorlibs/bignumber/CommonBigInt;", "Lkorlibs/bignumber/BigInt;", "Lkorlibs/bignumber/BigIntConstructor;", "data", "Lkorlibs/bignumber/UInt16ArrayZeroPad;", "signum", "", "dummy", "", "(Lkorlibs/bignumber/UInt16ArrayZeroPad;IZ)V", "absoluteValue", "getAbsoluteValue", "()Lkorlibs/bignumber/CommonBigInt;", "getData", "()Lkorlibs/bignumber/UInt16ArrayZeroPad;", "getDummy", "()Z", "setDummy", "(Z)V", "isOne", "isSmall", "maxBits", "getMaxBits", "()I", "significantBits", "getSignificantBits", "getSignum", "abs", "and", "other", "bitwise", "op", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "a", "b", "compareTo", "that", "countBits", "create", "value", "", "", "radix", "div", "divRem", "Lkorlibs/bignumber/CommonBigInt$DivRem;", "divRemBig", "equals", "", "getBit", "n", "getBitInt", "getLower", "len", "getUpper", "hashCode", "inv", "leadingZeros", "minus", "mulAddSmall", "mul", "add", "mulWithStats", "stats", "Lkorlibs/bignumber/CommonBigInt$OpStats;", "or", "plus", "pow", "exponent", "powWithStats", "rem", "shl", "count", "shr", "square", "times", "toBigNum", "Lkorlibs/bignumber/BigNum;", "toInt", "toString", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toUnsignedString16", "toUnsignedString2", "toUnsignedStringGeneric", "trailingZeros", "unaryMinus", "unaryPlus", "withBit", "bit", "set", "xor", "Companion", "DivRem", "OpStats", "kbignum"})
@SourceDebugExtension(value={"SMAP\nCommonBigInt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonBigInt.kt\nkorlibs/bignumber/CommonBigInt\n*L\n1#1,699:1\n404#1,4:700\n404#1,4:704\n404#1,4:708\n*S KotlinDebug\n*F\n+ 1 CommonBigInt.kt\nkorlibs/bignumber/CommonBigInt\n*L\n397#1:700,4\n398#1:704,4\n399#1:708,4\n*E\n"})
public final class CommonBigInt
implements BigInt,
BigIntConstructor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UInt16ArrayZeroPad data;
    private final int signum;
    private boolean dummy;
    private final /* synthetic */ Companion $$delegate_0;
    public static final int CHUNK_BITS = 16;
    @NotNull
    private static final CommonBigInt ZERO = new CommonBigInt(CommonBigIntKt.uint16ArrayZeroPadOf(new int[0]), 0, true);
    @NotNull
    private static final CommonBigInt MINUS_ONE;
    @NotNull
    private static final CommonBigInt ONE;
    @NotNull
    private static final CommonBigInt TWO;
    @NotNull
    private static final CommonBigInt TEN;
    @NotNull
    private static final CommonBigInt SMALL;

    private CommonBigInt(UInt16ArrayZeroPad data, int signum, boolean dummy) {
        this.data = data;
        this.signum = signum;
        this.dummy = dummy;
        this.$$delegate_0 = Companion;
    }

    @NotNull
    public final UInt16ArrayZeroPad getData() {
        return this.data;
    }

    @Override
    public int getSignum() {
        return this.signum;
    }

    public final boolean getDummy() {
        return this.dummy;
    }

    public final void setDummy(boolean bl) {
        this.dummy = bl;
    }

    @Override
    @NotNull
    public BigInt create(int value) {
        return this.$$delegate_0.create(value);
    }

    @Override
    @NotNull
    public BigInt create(long value) {
        return this.$$delegate_0.create(value);
    }

    @Override
    @NotNull
    public BigInt create(@NotNull String value) {
        return this.$$delegate_0.create(value);
    }

    @Override
    @NotNull
    public BigInt create(@NotNull String value, int radix) {
        return this.$$delegate_0.create(value, radix);
    }

    public final boolean isOne() {
        return this.isSmall() && Intrinsics.areEqual((Object)this, (Object)ONE);
    }

    public final boolean isSmall() {
        return this.data.getSize() <= 1;
    }

    public final int getMaxBits() {
        return this.data.getSize() * 16;
    }

    public final int getSignificantBits() {
        return this.getMaxBits() - this.leadingZeros();
    }

    public final int countBits() {
        int count = 0;
        int n = this.data.getSize();
        for (int n2 = 0; n2 < n; ++n2) {
            count += IntExtKt.bitCount(this.data.get(n2));
        }
        return count;
    }

    public final int leadingZeros() {
        if (this.isZero()) {
            return this.getMaxBits();
        }
        int n = this.data.getSize();
        for (int n2 = 0; n2 < n; ++n2) {
            int dataN = this.data.get(this.data.getSize() - n2 - 1);
            if (dataN == 0) continue;
            return 16 * n2 + (IntExtKt.leadingZeros(dataN) - 16);
        }
        return this.getMaxBits();
    }

    public final int trailingZeros() {
        if (this.isZero()) {
            return this.getMaxBits();
        }
        int n = this.data.getSize();
        for (int n2 = 0; n2 < n; ++n2) {
            int dataN = this.data.get(n2);
            if (dataN == 0) continue;
            return 16 * n2 + IntExtKt.trailingZeros(dataN);
        }
        return this.getMaxBits();
    }

    @Override
    @NotNull
    public CommonBigInt plus(@NotNull BigInt other) {
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
        CommonBigInt cfr_ignored_0 = (CommonBigInt)other;
        CommonBigInt l = this;
        BigInt r = other;
        return l.isZero() ? (CommonBigInt)r : (r.isZero() ? l : (l.isNegative() && r.isPositive() ? ((CommonBigInt)r).minus(l.getAbsoluteValue()) : (l.isPositive() && r.isNegative() ? l.minus(((CommonBigInt)r).getAbsoluteValue()) : (l.isNegative() && r.isNegative() ? l.getAbsoluteValue().plus(((CommonBigInt)r).getAbsoluteValue()).unaryMinus() : Companion.invoke(UnsignedBigInt.INSTANCE.add(this.data, ((CommonBigInt)other).data), this.getSignum())))));
    }

    @Override
    @NotNull
    public CommonBigInt minus(@NotNull BigInt other) {
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
        CommonBigInt cfr_ignored_0 = (CommonBigInt)other;
        CommonBigInt l = this;
        BigInt r = other;
        return r.isZero() ? l : (l.isZero() ? ((CommonBigInt)r).unaryMinus() : (l.isNegative() && r.isNegative() ? ((CommonBigInt)r).abs().minus(l.abs()) : (l.isNegative() && r.isPositive() ? l.getAbsoluteValue().plus(r).unaryMinus() : (l.isPositive() && r.isNegative() ? l.plus(((CommonBigInt)r).getAbsoluteValue()) : (l.isPositive() && r.isPositive() && l.compareTo(r) < 0 ? ((CommonBigInt)r).minus(l).unaryMinus() : Companion.invoke(UnsignedBigInt.INSTANCE.sub(l.data, ((CommonBigInt)r).data), 1))))));
    }

    @Override
    @NotNull
    public CommonBigInt pow(@NotNull BigInt exponent) {
        Intrinsics.checkNotNull((Object)exponent, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
        CommonBigInt cfr_ignored_0 = (CommonBigInt)exponent;
        if (exponent.isNegative()) {
            throw new BigIntNegativeExponentException();
        }
        if (exponent.isZero()) {
            return ONE;
        }
        if (Intrinsics.areEqual((Object)exponent, (Object)ONE)) {
            return this;
        }
        CommonBigInt base = this;
        int expMaxBits = ((CommonBigInt)exponent).getSignificantBits();
        if (expMaxBits < 32) {
            return this.pow(exponent.toInt());
        }
        CommonBigInt result = ONE;
        for (int expBit = 0; expBit < expMaxBits; ++expBit) {
            if (((CommonBigInt)exponent).getBit(expBit)) {
                result = result.times(base);
            }
            base = base.times(base);
        }
        return result;
    }

    @Override
    @NotNull
    public CommonBigInt pow(int exponent) {
        return this.powWithStats(exponent, null);
    }

    private final CommonBigInt getLower(int len) {
        return len >= this.data.getSize() ? this.getAbsoluteValue() : Companion.invoke(this.data.copyOfRange(0, len), 1);
    }

    private final CommonBigInt getUpper(int len) {
        return len >= this.data.getSize() ? ZERO : Companion.invoke(this.data.copyOfRange(len, this.data.getSize()), 1);
    }

    @Override
    @NotNull
    public CommonBigInt square() {
        CommonBigInt commonBigInt;
        if (this.isZero()) {
            return ZERO;
        }
        if (this.data.getSize() > 128) {
            int half = (this.data.getSize() + 1) / 2;
            CommonBigInt l = this.getLower(half);
            CommonBigInt ul = l.square();
            CommonBigInt u = this.getUpper(half);
            CommonBigInt us = u.square();
            commonBigInt = us.shl(half * 16).plus(l.plus(u).square().minus(us.plus(ul))).shl(half * 16).plus(ul);
        } else {
            commonBigInt = this.times(this);
        }
        return commonBigInt;
    }

    @NotNull
    public final CommonBigInt powWithStats(int exponent, @Nullable OpStats stats) {
        CommonBigInt result;
        int exp;
        block12: {
            if (exponent < 0) {
                throw new BigIntNegativeExponentException();
            }
            if (exponent == 0) {
                return ONE;
            }
            if (exponent == 1) {
                return this;
            }
            if (this.isZero()) {
                return exponent == 0 ? ONE : this;
            }
            int iterCount = 0;
            int multCount = 0;
            int squareCount = 0;
            OpStats opStats = stats;
            if (opStats != null) {
                OpStats.set$default(opStats, 0, 0, 0, 7, null);
            }
            exp = exponent;
            CommonBigInt part = this.abs();
            int pot = part.trailingZeros();
            int shift = pot * exp;
            if (pot > 0) {
                part = part.shr(pot);
            } else {
                shift = 0;
            }
            int remainingBits = part.countBits();
            if (remainingBits == 1) {
                return this.isNegative() && (exp & 1) == 1 ? MINUS_ONE.shl(shift) : ONE.shl(shift);
            }
            result = ONE;
            while (exp != 0) {
                if ((exp & 1) == 1) {
                    result = result.times(part);
                    ++multCount;
                }
                if ((exp >>>= 1) != 0) {
                    part = part.square();
                    ++squareCount;
                }
                ++iterCount;
            }
            if (pot > 0) {
                result = result.shl(shift);
            }
            OpStats opStats2 = stats;
            if (opStats2 == null) break block12;
            opStats2.set(iterCount, multCount, squareCount);
        }
        return this.getSignum() < 0 && (exp & 1) == 1 ? result.unaryMinus() : result;
    }

    @NotNull
    public final CommonBigInt mulWithStats(@NotNull CommonBigInt other, @Nullable OpStats stats) {
        OpStats opStats = stats;
        if (opStats != null) {
            opStats.setIterations(0);
        }
        return this.isZero() || other.isZero() ? ZERO : (Intrinsics.areEqual((Object)this, (Object)ONE) ? other : (Intrinsics.areEqual((Object)other, (Object)ONE) ? this : (Intrinsics.areEqual((Object)this, (Object)TWO) ? other.shl(1) : (Intrinsics.areEqual((Object)other, (Object)TWO) ? this.shl(1) : (other.countBits() == 1 ? Companion.invoke(this.shl((int)other.trailingZeros()).data, this.getSignum() == other.getSignum() ? 1 : -1) : Companion.invoke(UnsignedBigInt.INSTANCE.mul(this.data, other.data, stats), this.getSignum() == other.getSignum() ? 1 : -1))))));
    }

    @Override
    @NotNull
    public CommonBigInt times(@NotNull BigInt other) {
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
        CommonBigInt cfr_ignored_0 = (CommonBigInt)other;
        return this.isOne() ? (CommonBigInt)other : (((CommonBigInt)other).isOne() ? this : (this.isZero() ? ZERO : (other.isZero() ? ZERO : this.mulWithStats((CommonBigInt)other, null))));
    }

    @Override
    @NotNull
    public CommonBigInt div(@NotNull BigInt other) {
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
        return this.divRem((CommonBigInt)other).getDiv();
    }

    @Override
    @NotNull
    public CommonBigInt rem(@NotNull BigInt other) {
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
        return this.divRem((CommonBigInt)other).getRem();
    }

    @NotNull
    public final CommonBigInt withBit(int bit, boolean set) {
        int bitShift = bit % 16;
        int bitMask = 1 << bitShift;
        int wordPos = bit / 16;
        CommonBigInt out = new CommonBigInt(this.data.copyOf(Math.max(this.data.getSize(), wordPos + 1)), this.getSignum() == 0 ? 1 : this.getSignum(), this.dummy);
        UInt16ArrayZeroPad outData = out.data;
        outData.set(wordPos, set ? outData.get(wordPos) | bitMask : outData.get(wordPos) & ~bitMask);
        return out;
    }

    public static /* synthetic */ CommonBigInt withBit$default(CommonBigInt commonBigInt, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return commonBigInt.withBit(n, bl);
    }

    @NotNull
    public final DivRem divRem(@NotNull CommonBigInt other) {
        DivRem divRem;
        if (this.isZero()) {
            divRem = new DivRem(ZERO, ZERO);
        } else {
            if (other.isZero()) {
                throw new BigIntDivisionByZeroException();
            }
            if (this.isNegative() && other.isNegative()) {
                DivRem it = this.getAbsoluteValue().divRem(other.getAbsoluteValue());
                boolean bl = false;
                divRem = new DivRem(it.getDiv(), it.getRem().unaryMinus());
            } else if (this.isNegative() && other.isPositive()) {
                DivRem it = this.getAbsoluteValue().divRem(other.getAbsoluteValue());
                boolean bl = false;
                divRem = new DivRem(it.getDiv().unaryMinus(), it.getRem().unaryMinus());
            } else if (this.isPositive() && other.isNegative()) {
                DivRem it = this.getAbsoluteValue().divRem(other.getAbsoluteValue());
                boolean bl = false;
                divRem = new DivRem(it.getDiv().unaryMinus(), it.getRem());
            } else if (Intrinsics.areEqual((Object)other, (Object)ONE)) {
                divRem = new DivRem(this, ZERO);
            } else if (Intrinsics.areEqual((Object)other, (Object)TWO)) {
                CommonBigInt commonBigInt = this.shr(1);
                CommonBigInt commonBigInt2 = Companion.invoke(this.getBitInt(0));
                Intrinsics.checkNotNull((Object)commonBigInt2, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
                divRem = new DivRem(commonBigInt, commonBigInt2);
            } else if (other.compareTo(SMALL) <= 0) {
                UnsignedBigInt.DivRemSmall it = UnsignedBigInt.INSTANCE.divRemSmall(this.data, other.toInt());
                boolean bl = false;
                CommonBigInt commonBigInt = Companion.invoke(it.getDiv(), this.getSignum());
                CommonBigInt commonBigInt3 = Companion.invoke(it.getRem());
                Intrinsics.checkNotNull((Object)commonBigInt3, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
                divRem = new DivRem(commonBigInt, commonBigInt3);
            } else if (other.countBits() == 1) {
                int bits = other.trailingZeros();
                divRem = new DivRem(this.shr(bits), this.and(ONE.shl(bits).minus(ONE)));
            } else {
                divRem = this.divRemBig(other);
            }
        }
        return divRem;
    }

    private final DivRem divRemBig(CommonBigInt other) {
        if (this.isZero()) {
            return new DivRem(ZERO, ZERO);
        }
        if (other.isZero()) {
            throw new BigIntDivisionByZeroException();
        }
        if (this.isNegative() || other.isNegative()) {
            throw new BigIntException("Non positive numbers");
        }
        int lbits = this.getSignificantBits();
        int rbits = other.getSignificantBits();
        CommonBigInt rem = this;
        CommonBigInt divisor = other;
        int divisorShift = 0;
        CommonBigInt res = ZERO;
        int initialShiftBits = lbits - rbits + 1;
        divisorShift += initialShiftBits;
        divisor = divisor.shl(initialShiftBits);
        while (divisorShift >= 0) {
            if (divisor.isZero()) {
                throw new BigIntDivisionByZeroException();
            }
            if (divisor.compareTo(rem) <= 0) {
                res = CommonBigInt.withBit$default(res, divisorShift, false, 2, null);
                rem = rem.minus(divisor);
            }
            --divisorShift;
            divisor = divisor.shr(1);
        }
        return new DivRem(res, rem);
    }

    public final int getBitInt(int n) {
        return this.data.get(n / 16) >>> n % 16 & 1;
    }

    public final boolean getBit(int n) {
        return this.getBitInt(n) != 0;
    }

    @Override
    @NotNull
    public CommonBigInt shl(int count) {
        if (count == 0) {
            return this;
        }
        if (count < 0) {
            return this.shr(-count);
        }
        int blockShift = count / 16;
        int smallShift = count % 16;
        UInt16ArrayZeroPad out = new UInt16ArrayZeroPad(this.data.getSize() + blockShift + 1);
        int carry = 0;
        int count_rcp = 16 - smallShift;
        int n = this.data.getSize() + 1;
        for (int n2 = 0; n2 < n; ++n2) {
            int v = this.data.get(n2);
            out.set(n2 + blockShift, carry | v << smallShift);
            carry = v >>> count_rcp;
        }
        if (carry != 0) {
            throw new BigIntException("ERROR!");
        }
        return Companion.invoke(out, this.getSignum());
    }

    @Override
    @NotNull
    public CommonBigInt shr(int count) {
        if (count < 0) {
            return this.shl(-count);
        }
        int blockShift = count / 16;
        int smallShift = count % 16;
        UInt16ArrayZeroPad out = new UInt16ArrayZeroPad(this.data.getSize() - blockShift);
        int carry = 0;
        int count_rcp = 16 - smallShift;
        int LOW_MASK = (1 << smallShift) - 1;
        int n = this.data.getSize() - 1;
        if (blockShift <= n) {
            while (true) {
                int v = this.data.get(n);
                out.set(n - blockShift, carry << count_rcp | v >>> smallShift);
                carry = v & LOW_MASK;
                if (n == blockShift) break;
                --n;
            }
        }
        return Companion.invoke(out, this.getSignum());
    }

    @Override
    public int compareTo(@NotNull BigInt that) {
        Intrinsics.checkNotNull((Object)that, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
        CommonBigInt cfr_ignored_0 = (CommonBigInt)that;
        if (this.isNegative() && that.isPositiveOrZero()) {
            return -1;
        }
        if (this.isPositiveOrZero() && that.isNegative()) {
            return 1;
        }
        int resUnsigned = UnsignedBigInt.INSTANCE.compare(this.data, ((CommonBigInt)that).data);
        return this.isNegative() && that.isNegative() ? -resUnsigned : resUnsigned;
    }

    public int hashCode() {
        return this.data.contentHashCode() * this.getSignum();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CommonBigInt && this.getSignum() == ((CommonBigInt)other).getSignum() && this.data.contentEquals(((CommonBigInt)other).data);
    }

    @NotNull
    public final CommonBigInt getAbsoluteValue() {
        return this.abs();
    }

    @Override
    @NotNull
    public CommonBigInt abs() {
        return this.isZero() ? ZERO : (this.isPositive() ? this : Companion.invoke(this.data, 1));
    }

    @Override
    @NotNull
    public CommonBigInt unaryPlus() {
        return this;
    }

    @Override
    @NotNull
    public CommonBigInt unaryMinus() {
        return new CommonBigInt(this.data, -this.getSignum(), false);
    }

    @NotNull
    public final CommonBigInt mulAddSmall(int mul, int add) {
        if ((mul & 0xFFFF) == mul && (add & 0xFFFF) == add) {
            int[] nArray = Arrays.copyOf(this.data.getData(), this.data.getSize() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(this, newSize)");
            UInt16ArrayZeroPad temp = new UInt16ArrayZeroPad(nArray);
            UnsignedBigInt.INSTANCE.inplaceSmallMulAdd(temp, mul, add);
            return Companion.invoke(temp, temp.isAllZero() ? 0 : (this.getSignum() == 0 ? 1 : this.getSignum()));
        }
        CommonBigInt out = this.times(Companion.invoke(mul));
        return add == 0 ? out : out.plus(Companion.invoke(add));
    }

    @Override
    @NotNull
    public CommonBigInt plus(int other) {
        return this.plus(Companion.invoke(other));
    }

    @Override
    @NotNull
    public CommonBigInt minus(int other) {
        return this.minus(Companion.invoke(other));
    }

    @Override
    @NotNull
    public CommonBigInt times(int other) {
        return this.mulAddSmall(other, 0);
    }

    @Override
    @NotNull
    public CommonBigInt times(long other) {
        return this.times(Companion.invoke(other));
    }

    @Override
    @NotNull
    public CommonBigInt div(int other) {
        return this.div(Companion.invoke(other));
    }

    @Override
    @NotNull
    public CommonBigInt rem(int other) {
        return this.rem(Companion.invoke(other));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommonBigInt and(@NotNull BigInt other) {
        void it$iv;
        void this_$iv;
        UInt16ArrayZeroPad uInt16ArrayZeroPad;
        CommonBigInt commonBigInt = this;
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
        CommonBigInt other$iv = (CommonBigInt)other;
        boolean $i$f$bitwise = false;
        UInt16ArrayZeroPad uInt16ArrayZeroPad2 = uInt16ArrayZeroPad = new UInt16ArrayZeroPad(Math.max(this_$iv.data.getSize(), other$iv.data.getSize()));
        Companion companion = Companion;
        boolean bl = false;
        int n$iv = 0;
        int n = it$iv.getSize();
        while (n$iv < n) {
            void p1;
            void p0;
            int n2 = other$iv.data.get(n$iv);
            int n3 = this_$iv.data.get(n$iv);
            int n4 = n$iv++;
            void var14_14 = it$iv;
            boolean bl2 = false;
            int n5 = p0 & p1;
            var14_14.set(n4, n5);
        }
        return companion.invoke(uInt16ArrayZeroPad, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommonBigInt or(@NotNull BigInt other) {
        void it$iv;
        void this_$iv;
        UInt16ArrayZeroPad uInt16ArrayZeroPad;
        CommonBigInt commonBigInt = this;
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
        CommonBigInt other$iv = (CommonBigInt)other;
        boolean $i$f$bitwise = false;
        UInt16ArrayZeroPad uInt16ArrayZeroPad2 = uInt16ArrayZeroPad = new UInt16ArrayZeroPad(Math.max(this_$iv.data.getSize(), other$iv.data.getSize()));
        Companion companion = Companion;
        boolean bl = false;
        int n$iv = 0;
        int n = it$iv.getSize();
        while (n$iv < n) {
            void p1;
            void p0;
            int n2 = other$iv.data.get(n$iv);
            int n3 = this_$iv.data.get(n$iv);
            int n4 = n$iv++;
            void var14_14 = it$iv;
            boolean bl2 = false;
            int n5 = p0 | p1;
            var14_14.set(n4, n5);
        }
        return companion.invoke(uInt16ArrayZeroPad, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommonBigInt xor(@NotNull BigInt other) {
        void it$iv;
        void this_$iv;
        UInt16ArrayZeroPad uInt16ArrayZeroPad;
        CommonBigInt commonBigInt = this;
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
        CommonBigInt other$iv = (CommonBigInt)other;
        boolean $i$f$bitwise = false;
        UInt16ArrayZeroPad uInt16ArrayZeroPad2 = uInt16ArrayZeroPad = new UInt16ArrayZeroPad(Math.max(this_$iv.data.getSize(), other$iv.data.getSize()));
        Companion companion = Companion;
        boolean bl = false;
        int n$iv = 0;
        int n = it$iv.getSize();
        while (n$iv < n) {
            void p1;
            void p0;
            int n2 = other$iv.data.get(n$iv);
            int n3 = this_$iv.data.get(n$iv);
            int n4 = n$iv++;
            void var14_14 = it$iv;
            boolean bl2 = false;
            int n5 = p0 ^ p1;
            var14_14.set(n4, n5);
        }
        return companion.invoke(uInt16ArrayZeroPad, 1);
    }

    @Override
    @NotNull
    public CommonBigInt inv() {
        return this.plus(1).unaryMinus();
    }

    /*
     * WARNING - void declaration
     */
    private final CommonBigInt bitwise(CommonBigInt other, Function2<? super Integer, ? super Integer, Integer> op) {
        void it;
        UInt16ArrayZeroPad uInt16ArrayZeroPad;
        boolean $i$f$bitwise = false;
        UInt16ArrayZeroPad uInt16ArrayZeroPad2 = uInt16ArrayZeroPad = new UInt16ArrayZeroPad(Math.max(this.data.getSize(), other.data.getSize()));
        Companion companion = Companion;
        boolean bl = false;
        int n = it.getSize();
        for (int n2 = 0; n2 < n; ++n2) {
            it.set(n2, ((Number)op.invoke((Object)this.data.get(n2), (Object)other.data.get(n2))).intValue());
        }
        return companion.invoke(uInt16ArrayZeroPad, 1);
    }

    @NotNull
    public String toString() {
        return this.toString(10);
    }

    @Override
    @NotNull
    public String toString(int radix) {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, radix);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void toString(@NotNull StringBuilder sb, int radix) {
        if (this.isZero()) {
            sb.append(0);
            return;
        }
        if (this.isNegative()) {
            sb.append('-');
        }
        switch (radix) {
            case 2: {
                this.toUnsignedString2(sb);
                break;
            }
            case 16: {
                this.toUnsignedString16(sb);
                break;
            }
            default: {
                this.toUnsignedStringGeneric(sb, radix);
            }
        }
    }

    private final void toUnsignedString2(StringBuilder sb) {
        int mb = this.getMaxBits();
        boolean started = false;
        for (int n = 0; n < mb; ++n) {
            boolean bit = this.getBit(mb - n - 1);
            if (!started && !bit) continue;
            sb.append(bit ? (char)'1' : '0');
            started = true;
        }
    }

    private final void toUnsignedString16(StringBuilder sb) {
        boolean started = false;
        int n = this.data.getSize();
        for (int n2 = 0; n2 < n; ++n2) {
            int i = this.data.getSize() - 1 - n2;
            int value = this.data.get(i);
            for (int m = 0; m < 4; ++m) {
                int digit = value >>> 12 - 4 * m & 0xF;
                if (digit == 0 && !started) continue;
                sb.append(CommonBigIntKt.access$digit(digit));
                started = true;
            }
        }
    }

    private final void toUnsignedStringGeneric(StringBuilder sb, int radix) {
        if (!(2 <= radix ? radix < 27 : false)) {
            throw new BigIntInvalidFormatException("Invalid radix " + radix + '!');
        }
        StringBuilder out = new StringBuilder();
        CommonBigInt num = this;
        while (!Intrinsics.areEqual((Object)num, (Object)ZERO)) {
            UnsignedBigInt.DivRemSmall result = UnsignedBigInt.INSTANCE.divRemSmall(num.data, radix);
            out.append(CommonBigIntKt.access$digit(result.getRem()));
            num = Companion.invoke(result.getDiv(), 1);
        }
        sb.append(((Object)StringsKt.reversed((CharSequence)out)).toString());
    }

    @Override
    public int toInt() {
        if (this.getSignificantBits() > 31) {
            throw new BigIntOverflowException("Can't represent CommonBigInt(" + this + ") as integer: maxBits=" + this.getMaxBits() + ", significantBits=" + this.getSignificantBits() + ", trailingZeros=" + this.trailingZeros());
        }
        long magnitude = ((long)this.data.get(0) | (long)this.data.get(1) << 16) * (long)this.getSignum();
        return (int)magnitude;
    }

    @NotNull
    public final BigNum toBigNum() {
        return new BigNum(this, 0);
    }

    @Override
    public boolean isZero() {
        return BigInt.DefaultImpls.isZero(this);
    }

    @Override
    public boolean isNotZero() {
        return BigInt.DefaultImpls.isNotZero(this);
    }

    @Override
    public boolean isNegative() {
        return BigInt.DefaultImpls.isNegative(this);
    }

    @Override
    public boolean isPositive() {
        return BigInt.DefaultImpls.isPositive(this);
    }

    @Override
    public boolean isNegativeOrZero() {
        return BigInt.DefaultImpls.isNegativeOrZero(this);
    }

    @Override
    public boolean isPositiveOrZero() {
        return BigInt.DefaultImpls.isPositiveOrZero(this);
    }

    @Override
    @NotNull
    public BigIntRange rangeTo(@NotNull BigInt that) {
        return BigInt.DefaultImpls.rangeTo(this, that);
    }

    public /* synthetic */ CommonBigInt(UInt16ArrayZeroPad data, int signum, boolean dummy, DefaultConstructorMarker $constructor_marker) {
        this(data, signum, dummy);
    }

    static {
        int[] nArray = new int[]{1};
        MINUS_ONE = new CommonBigInt(CommonBigIntKt.uint16ArrayZeroPadOf(nArray), -1, true);
        nArray = new int[]{1};
        ONE = new CommonBigInt(CommonBigIntKt.uint16ArrayZeroPadOf(nArray), 1, true);
        nArray = new int[]{2};
        TWO = new CommonBigInt(CommonBigIntKt.uint16ArrayZeroPadOf(nArray), 1, true);
        nArray = new int[]{10};
        TEN = new CommonBigInt(CommonBigIntKt.uint16ArrayZeroPadOf(nArray), 1, true);
        nArray = new int[]{65535};
        SMALL = new CommonBigInt(CommonBigIntKt.uint16ArrayZeroPadOf(nArray), 1, true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u0019\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0004H\u0096\u0002J\u0011\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0019H\u0096\u0002J\u0011\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u001aH\u0096\u0002J\u0019\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u001c"}, d2={"Lkorlibs/bignumber/CommonBigInt$Companion;", "Lkorlibs/bignumber/BigIntCompanion;", "()V", "CHUNK_BITS", "", "MINUS_ONE", "Lkorlibs/bignumber/CommonBigInt;", "getMINUS_ONE", "()Lkorlibs/bignumber/CommonBigInt;", "ONE", "getONE", "SMALL", "getSMALL", "TEN", "getTEN", "TWO", "getTWO", "ZERO", "getZERO", "create", "value", "invoke", "data", "Lkorlibs/bignumber/UInt16ArrayZeroPad;", "signum", "", "", "radix", "kbignum"})
    public static final class Companion
    implements BigIntCompanion {
        private Companion() {
        }

        @NotNull
        public final CommonBigInt getZERO() {
            return ZERO;
        }

        @NotNull
        public final CommonBigInt getMINUS_ONE() {
            return MINUS_ONE;
        }

        @NotNull
        public final CommonBigInt getONE() {
            return ONE;
        }

        @NotNull
        public final CommonBigInt getTWO() {
            return TWO;
        }

        @NotNull
        public final CommonBigInt getTEN() {
            return TEN;
        }

        @NotNull
        public final CommonBigInt getSMALL() {
            return SMALL;
        }

        @NotNull
        public final CommonBigInt invoke(@NotNull UInt16ArrayZeroPad data, int signum) {
            int maxN = 0;
            for (int n = data.getSize() - 1; -1 < n; --n) {
                if (data.get(n) == 0) continue;
                maxN = n + 1;
                break;
            }
            if (maxN == 0) {
                return this.getZERO();
            }
            return new CommonBigInt(data.copyOf(maxN), signum, false, null);
        }

        @Override
        @NotNull
        public CommonBigInt create(int value) {
            CommonBigInt commonBigInt;
            switch (value) {
                case -1: {
                    commonBigInt = this.getMINUS_ONE();
                    break;
                }
                case 0: {
                    commonBigInt = this.getZERO();
                    break;
                }
                case 1: {
                    commonBigInt = this.getONE();
                    break;
                }
                case 2: {
                    commonBigInt = this.getTWO();
                    break;
                }
                default: {
                    long magnitude = Math.abs((long)value);
                    int[] nArray = new int[]{(int)(magnitude >>> 0), (int)(magnitude >>> 16)};
                    commonBigInt = Companion.invoke(CommonBigIntKt.uint16ArrayZeroPadOf(nArray), MathKt.getSign((int)value));
                }
            }
            return commonBigInt;
        }

        @Override
        @NotNull
        public CommonBigInt invoke(int value) {
            return this.create(value);
        }

        @Override
        @NotNull
        public CommonBigInt invoke(long value) {
            BigInt bigInt = this.create(value);
            Intrinsics.checkNotNull((Object)bigInt, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
            return (CommonBigInt)bigInt;
        }

        @Override
        @NotNull
        public CommonBigInt invoke(@NotNull String value) {
            BigInt bigInt = this.create(value);
            Intrinsics.checkNotNull((Object)bigInt, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
            return (CommonBigInt)bigInt;
        }

        @Override
        @NotNull
        public CommonBigInt invoke(@NotNull String value, int radix) {
            BigInt bigInt = this.create(value, radix);
            Intrinsics.checkNotNull((Object)bigInt, (String)"null cannot be cast to non-null type korlibs.bignumber.CommonBigInt");
            return (CommonBigInt)bigInt;
        }

        @Override
        @NotNull
        public BigInt create(long value) {
            return BigIntCompanion.DefaultImpls.create((BigIntCompanion)this, value);
        }

        @Override
        @NotNull
        public BigInt create(@NotNull String value, int radix) {
            return BigIntCompanion.DefaultImpls.create(this, value, radix);
        }

        @Override
        @NotNull
        public BigInt create(@NotNull String value) {
            return BigIntCompanion.DefaultImpls.create((BigIntCompanion)this, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lkorlibs/bignumber/CommonBigInt$DivRem;", "", "div", "Lkorlibs/bignumber/CommonBigInt;", "rem", "(Lkorlibs/bignumber/CommonBigInt;Lkorlibs/bignumber/CommonBigInt;)V", "getDiv", "()Lkorlibs/bignumber/CommonBigInt;", "getRem", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kbignum"})
    public static final class DivRem {
        @NotNull
        private final CommonBigInt div;
        @NotNull
        private final CommonBigInt rem;

        public DivRem(@NotNull CommonBigInt div, @NotNull CommonBigInt rem) {
            this.div = div;
            this.rem = rem;
        }

        @NotNull
        public final CommonBigInt getDiv() {
            return this.div;
        }

        @NotNull
        public final CommonBigInt getRem() {
            return this.rem;
        }

        @NotNull
        public final CommonBigInt component1() {
            return this.div;
        }

        @NotNull
        public final CommonBigInt component2() {
            return this.rem;
        }

        @NotNull
        public final DivRem copy(@NotNull CommonBigInt div, @NotNull CommonBigInt rem) {
            return new DivRem(div, rem);
        }

        public static /* synthetic */ DivRem copy$default(DivRem divRem, CommonBigInt commonBigInt, CommonBigInt commonBigInt2, int n, Object object) {
            if ((n & 1) != 0) {
                commonBigInt = divRem.div;
            }
            if ((n & 2) != 0) {
                commonBigInt2 = divRem.rem;
            }
            return divRem.copy(commonBigInt, commonBigInt2);
        }

        @NotNull
        public String toString() {
            return "DivRem(div=" + this.div + ", rem=" + this.rem + ')';
        }

        public int hashCode() {
            int result = this.div.hashCode();
            result = result * 31 + this.rem.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DivRem)) {
                return false;
            }
            DivRem divRem = (DivRem)other;
            if (!Intrinsics.areEqual((Object)this.div, (Object)divRem.div)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.rem, (Object)divRem.rem);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J$\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u001b"}, d2={"Lkorlibs/bignumber/CommonBigInt$OpStats;", "", "iterations", "", "bigMultiplications", "square", "(III)V", "getBigMultiplications", "()I", "setBigMultiplications", "(I)V", "getIterations", "setIterations", "getSquare", "setSquare", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "set", "", "toString", "", "kbignum"})
    public static final class OpStats {
        private int iterations;
        private int bigMultiplications;
        private int square;

        public OpStats(int iterations, int bigMultiplications, int square) {
            this.iterations = iterations;
            this.bigMultiplications = bigMultiplications;
            this.square = square;
        }

        public /* synthetic */ OpStats(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            this(n, n2, n3);
        }

        public final int getIterations() {
            return this.iterations;
        }

        public final void setIterations(int n) {
            this.iterations = n;
        }

        public final int getBigMultiplications() {
            return this.bigMultiplications;
        }

        public final void setBigMultiplications(int n) {
            this.bigMultiplications = n;
        }

        public final int getSquare() {
            return this.square;
        }

        public final void setSquare(int n) {
            this.square = n;
        }

        public final void set(int iterations, int bigMultiplications, int square) {
            this.iterations = iterations;
            this.bigMultiplications = bigMultiplications;
            this.square = square;
        }

        public static /* synthetic */ void set$default(OpStats opStats, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            opStats.set(n, n2, n3);
        }

        public final int component1() {
            return this.iterations;
        }

        public final int component2() {
            return this.bigMultiplications;
        }

        public final int component3() {
            return this.square;
        }

        @NotNull
        public final OpStats copy(int iterations, int bigMultiplications, int square) {
            return new OpStats(iterations, bigMultiplications, square);
        }

        public static /* synthetic */ OpStats copy$default(OpStats opStats, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = opStats.iterations;
            }
            if ((n4 & 2) != 0) {
                n2 = opStats.bigMultiplications;
            }
            if ((n4 & 4) != 0) {
                n3 = opStats.square;
            }
            return opStats.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "OpStats(iterations=" + this.iterations + ", bigMultiplications=" + this.bigMultiplications + ", square=" + this.square + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.iterations);
            result = result * 31 + Integer.hashCode(this.bigMultiplications);
            result = result * 31 + Integer.hashCode(this.square);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OpStats)) {
                return false;
            }
            OpStats opStats = (OpStats)other;
            if (this.iterations != opStats.iterations) {
                return false;
            }
            if (this.bigMultiplications != opStats.bigMultiplications) {
                return false;
            }
            return this.square == opStats.square;
        }

        public OpStats() {
            this(0, 0, 0, 7, null);
        }
    }
}

