/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.earningswhispers;

import com.xorrus.trading.earningswhispers.ReleaseTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u001c\u001a\u00020\u0003H\u0016J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010!\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\fH\u00c6\u0003JI\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006)"}, d2={"Lcom/xorrus/trading/earningswhispers/EarningsData;", "", "ticker", "", "company", "date", "Lkotlinx/datetime/LocalDate;", "time", "Lkotlinx/datetime/LocalTime;", "releaseTime", "Lcom/xorrus/trading/earningswhispers/ReleaseTime;", "confirmInstant", "Lkotlin/time/Instant;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlinx/datetime/LocalDate;Lkotlinx/datetime/LocalTime;Lcom/xorrus/trading/earningswhispers/ReleaseTime;Lkotlin/time/Instant;)V", "getTicker", "()Ljava/lang/String;", "getCompany", "getDate", "()Lkotlinx/datetime/LocalDate;", "getTime", "()Lkotlinx/datetime/LocalTime;", "getReleaseTime", "()Lcom/xorrus/trading/earningswhispers/ReleaseTime;", "getConfirmInstant", "()Lkotlin/time/Instant;", "instant", "getInstant", "toString", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "earnings-whispers-client"})
public final class EarningsData {
    @NotNull
    private final String ticker;
    @NotNull
    private final String company;
    @NotNull
    private final LocalDate date;
    @Nullable
    private final LocalTime time;
    @NotNull
    private final ReleaseTime releaseTime;
    @Nullable
    private final Instant confirmInstant;

    public EarningsData(@NotNull String ticker, @NotNull String company, @NotNull LocalDate date, @Nullable LocalTime time, @NotNull ReleaseTime releaseTime, @Nullable Instant confirmInstant) {
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        Intrinsics.checkNotNullParameter((Object)company, (String)"company");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)releaseTime), (String)"releaseTime");
        this.ticker = ticker;
        this.company = company;
        this.date = date;
        this.time = time;
        this.releaseTime = releaseTime;
        this.confirmInstant = confirmInstant;
    }

    public /* synthetic */ EarningsData(String string, String string2, LocalDate localDate, LocalTime localTime, ReleaseTime releaseTime, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            instant = null;
        }
        this(string, string2, localDate, localTime, releaseTime, instant);
    }

    @NotNull
    public final String getTicker() {
        return this.ticker;
    }

    @NotNull
    public final String getCompany() {
        return this.company;
    }

    @NotNull
    public final LocalDate getDate() {
        return this.date;
    }

    @Nullable
    public final LocalTime getTime() {
        return this.time;
    }

    @NotNull
    public final ReleaseTime getReleaseTime() {
        return this.releaseTime;
    }

    @Nullable
    public final Instant getConfirmInstant() {
        return this.confirmInstant;
    }

    @Nullable
    public final Instant getInstant() {
        return this.time == null ? null : TimeZoneKt.toInstant$default((LocalDateTime)LocalDateKt.atTime((LocalDate)this.date, (LocalTime)this.time), (TimeZone)TimeZone.Companion.of("America/New_York"), null, (int)2, null);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("Ticker     : " + this.ticker).append('\n');
        $this$toString_u24lambda_u240.append("company    : " + this.company).append('\n');
        $this$toString_u24lambda_u240.append("date       : " + this.date).append('\n');
        $this$toString_u24lambda_u240.append("time       : " + this.time + " (New York Zeit)").append('\n');
        $this$toString_u24lambda_u240.append("instant    : " + this.getInstant()).append('\n');
        $this$toString_u24lambda_u240.append("confirmDate: " + this.confirmInstant).append('\n');
        $this$toString_u24lambda_u240.append("releaseTime: " + this.releaseTime).append('\n');
        return stringBuilder.toString();
    }

    @NotNull
    public final String component1() {
        return this.ticker;
    }

    @NotNull
    public final String component2() {
        return this.company;
    }

    @NotNull
    public final LocalDate component3() {
        return this.date;
    }

    @Nullable
    public final LocalTime component4() {
        return this.time;
    }

    @NotNull
    public final ReleaseTime component5() {
        return this.releaseTime;
    }

    @Nullable
    public final Instant component6() {
        return this.confirmInstant;
    }

    @NotNull
    public final EarningsData copy(@NotNull String ticker, @NotNull String company, @NotNull LocalDate date, @Nullable LocalTime time, @NotNull ReleaseTime releaseTime, @Nullable Instant confirmInstant) {
        Intrinsics.checkNotNullParameter((Object)ticker, (String)"ticker");
        Intrinsics.checkNotNullParameter((Object)company, (String)"company");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)releaseTime), (String)"releaseTime");
        return new EarningsData(ticker, company, date, time, releaseTime, confirmInstant);
    }

    public static /* synthetic */ EarningsData copy$default(EarningsData earningsData, String string, String string2, LocalDate localDate, LocalTime localTime, ReleaseTime releaseTime, Instant instant, int n, Object object) {
        if ((n & 1) != 0) {
            string = earningsData.ticker;
        }
        if ((n & 2) != 0) {
            string2 = earningsData.company;
        }
        if ((n & 4) != 0) {
            localDate = earningsData.date;
        }
        if ((n & 8) != 0) {
            localTime = earningsData.time;
        }
        if ((n & 0x10) != 0) {
            releaseTime = earningsData.releaseTime;
        }
        if ((n & 0x20) != 0) {
            instant = earningsData.confirmInstant;
        }
        return earningsData.copy(string, string2, localDate, localTime, releaseTime, instant);
    }

    public int hashCode() {
        int result = this.ticker.hashCode();
        result = result * 31 + this.company.hashCode();
        result = result * 31 + this.date.hashCode();
        result = result * 31 + (this.time == null ? 0 : this.time.hashCode());
        result = result * 31 + this.releaseTime.hashCode();
        result = result * 31 + (this.confirmInstant == null ? 0 : this.confirmInstant.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EarningsData)) {
            return false;
        }
        EarningsData earningsData = (EarningsData)other;
        if (!Intrinsics.areEqual((Object)this.ticker, (Object)earningsData.ticker)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.company, (Object)earningsData.company)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.date, (Object)earningsData.date)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.time, (Object)earningsData.time)) {
            return false;
        }
        if (this.releaseTime != earningsData.releaseTime) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.confirmInstant, (Object)earningsData.confirmInstant);
    }
}

