/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.contract;

import com.xorrus.trading.common.UtilKt;
import com.xorrus.trading.common.contract.Contract;
import com.xorrus.trading.common.contract.ContractVisitor;
import com.xorrus.trading.common.contract.Future;
import com.xorrus.trading.common.contract.Index;
import com.xorrus.trading.common.contract.Option;
import com.xorrus.trading.common.contract.Stock;
import com.xorrus.trading.common.contract.Underlying;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B5\b\u0016\u0012*\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00040\b\"\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\tJ!\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00040\u0003H\u00c6\u0003J%\u0010\u001a\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00040\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010 \u001a\u00020\rH\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/xorrus/trading/common/contract/Combo;", "Lcom/xorrus/trading/common/contract/Contract;", "legs", "", "Lkotlin/Pair;", "", "<init>", "(Ljava/util/List;)V", "", "([Lkotlin/Pair;)V", "getLegs", "()Ljava/util/List;", "symbol", "", "getSymbol", "()Ljava/lang/String;", "underlying", "Lcom/xorrus/trading/common/contract/Underlying;", "getUnderlying", "()Lcom/xorrus/trading/common/contract/Underlying;", "visit", "RESULT", "visitor", "Lcom/xorrus/trading/common/contract/ContractVisitor;", "(Lcom/xorrus/trading/common/contract/ContractVisitor;)Ljava/lang/Object;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "Companion", "common-trading-common"})
@SourceDebugExtension(value={"SMAP\nCombo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Combo.kt\ncom/xorrus/trading/common/contract/Combo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1#2:76\n1740#3,3:77\n*S KotlinDebug\n*F\n+ 1 Combo.kt\ncom/xorrus/trading/common/contract/Combo\n*L\n11#1:77,3\n*E\n"})
public final class Combo
extends Contract {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Pair<Integer, Contract>> legs;
    @NotNull
    private final String symbol;
    @NotNull
    private static final Regex legPattern = new Regex("^([+-]\\d+)\\s+(\\S.*)$");

    public Combo(@NotNull List<? extends Pair<Integer, ? extends Contract>> legs) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(legs, (String)"legs");
            super(null);
            this.legs = legs;
            if (!(!((Collection)this.legs).isEmpty())) {
                boolean $i$a$-require-Combo$22 = false;
                String $i$a$-require-Combo$22 = "A combo must have at least one leg";
                throw new IllegalArgumentException($i$a$-require-Combo$22.toString());
            }
            Iterable $this$all$iv = this.legs;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (((Number)it.getFirst()).intValue() != 0) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "A combo leg must have a count > 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.symbol = CollectionsKt.joinToString$default((Iterable)this.legs, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, Combo::symbol$lambda$0, (int)24, null);
    }

    @NotNull
    public final List<Pair<Integer, Contract>> getLegs() {
        return this.legs;
    }

    public Combo(Pair<Integer, ? extends Contract> ... legs) {
        Intrinsics.checkNotNullParameter(legs, (String)"legs");
        this(ArraysKt.toList((Object[])legs));
    }

    @Override
    @NotNull
    public String getSymbol() {
        return this.symbol;
    }

    @NotNull
    public final Underlying getUnderlying() {
        Underlying underlying;
        Contract firstLeg = (Contract)((Pair)CollectionsKt.first(this.legs)).getSecond();
        if (firstLeg instanceof Option) {
            underlying = ((Option)firstLeg).getUnderlying();
        } else {
            if (firstLeg instanceof Combo) {
                UtilKt.IMPOSSIBLE("Combos d\u00fcrfen keine Combos enthalten");
                throw new KotlinNothingValueException();
            }
            if (firstLeg instanceof Future || firstLeg instanceof Index || firstLeg instanceof Stock) {
                underlying = (Underlying)firstLeg;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return underlying;
    }

    @Override
    public <RESULT> RESULT visit(@NotNull ContractVisitor<RESULT> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        return visitor.visit(this);
    }

    @NotNull
    public final List<Pair<Integer, Contract>> component1() {
        return this.legs;
    }

    @NotNull
    public final Combo copy(@NotNull List<? extends Pair<Integer, ? extends Contract>> legs) {
        Intrinsics.checkNotNullParameter(legs, (String)"legs");
        return new Combo(legs);
    }

    public static /* synthetic */ Combo copy$default(Combo combo, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = combo.legs;
        }
        return combo.copy(list);
    }

    @NotNull
    public String toString() {
        return "Combo(legs=" + this.legs + ")";
    }

    public int hashCode() {
        return ((Object)this.legs).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Combo)) {
            return false;
        }
        Combo combo = (Combo)other;
        return Intrinsics.areEqual(this.legs, combo.legs);
    }

    private static final CharSequence symbol$lambda$0(Pair leg) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)leg, (String)"leg");
        StringBuilder $this$symbol_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int count = ((Number)leg.getFirst()).intValue();
        if (count > 0) {
            $this$symbol_u24lambda_u240_u240.append("+");
        }
        $this$symbol_u24lambda_u240_u240.append(count).append(" ").append(((Contract)leg.getSecond()).getSymbol());
        return stringBuilder.toString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/xorrus/trading/common/contract/Combo$Companion;", "", "<init>", "()V", "legPattern", "Lkotlin/text/Regex;", "fromSymbol", "Lcom/xorrus/trading/common/contract/Combo;", "symbol", "", "common-trading-common"})
    @SourceDebugExtension(value={"SMAP\nCombo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Combo.kt\ncom/xorrus/trading/common/contract/Combo$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1573#2:76\n1604#2,4:77\n*S KotlinDebug\n*F\n+ 1 Combo.kt\ncom/xorrus/trading/common/contract/Combo$Companion\n*L\n59#1:76\n59#1:77,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Combo fromSymbol(@NotNull String symbol) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            String trimmedSymbol = ((Object)StringsKt.trim((CharSequence)symbol)).toString();
            if (!StringsKt.startsWith$default((CharSequence)trimmedSymbol, (char)'[', (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)trimmedSymbol, (char)']', (boolean)false, (int)2, null)) {
                throw new IllegalStateException(("Ung\u00fcltiges Combo-Symbol: " + symbol + " (muss mit [ beginnen und ] enden)").toString());
            }
            String string = trimmedSymbol.substring(1, trimmedSymbol.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String body = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (((CharSequence)body).length() == 0) {
                throw new IllegalStateException(("Leeres Combo-Symbol: " + symbol).toString());
            }
            Object object = new char[]{','};
            object = StringsKt.split$default((CharSequence)body, (char[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$mapIndexed = false;
            void var7_6 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                MatchResult match;
                void legText;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String trimmedLeg = ((Object)StringsKt.trim((CharSequence)((CharSequence)legText))).toString();
                if (legPattern.matchEntire((CharSequence)trimmedLeg) == null) {
                    void index;
                    throw new IllegalStateException(("Ung\u00fcltiges Combo-Leg #" + (int)(index + true) + ": '" + trimmedLeg + "' in " + symbol).toString());
                }
                int count = Integer.parseInt((String)match.getGroupValues().get(1));
                String contractSymbol = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(2)))).toString();
                collection.add(TuplesKt.to((Object)count, (Object)Contract.Companion.fromSymbol(contractSymbol)));
            }
            List legs = (List)destination$iv$iv;
            return new Combo(legs);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

