/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common;

import com.xorrus.trading.common.Leg;
import com.xorrus.trading.common.contract.Right;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.Instant;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0010 \n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0007\u001a\"\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u001a\"\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u001a:\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018\u001a:\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018\u001a.\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003\u001a.\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003\u001a.\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003\u001a.\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003\u001a.\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003\u001a.\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003\u001a.\u0010 \u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003\u001a.\u0010\"\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003\u001a:\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018\u001a\u001e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003\u001a.\u0010#\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003\u001a.\u0010$\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003\u001a&\u0010%\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(\u001a,\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00062\f\u0010+\u001a\b\u0012\u0004\u0012\u00020(0,\u001aD\u0010\r\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00062\f\u0010+\u001a\b\u0012\u0004\u0012\u00020(0,2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0001\u001a,\u00102\u001a\b\u0012\u0004\u0012\u00020\u0003032\u0006\u0010-\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0001\u001a$\u00105\u001a\b\u0012\u0004\u0012\u00020\u0006032\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\u0001\u001a0\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030;2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030<2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000*\n\u00109\"\u00020\u00172\u00020\u0017\u00a8\u0006="}, d2={"JAHR_IN_MINUTEN", "", "SECONDS_PER_YEAR", "", "yearsBetween", "from", "Lkotlin/time/Instant;", "to", "restlaufzeit", "bezugsDatum", "expiry", "normalverteilt", "x", "erwartungswert", "standardabweichung", "normaldichte", "delta", "underlyingKurs", "strike", "zins", "vola", "Trest", "optionType", "Lcom/xorrus/trading/common/contract/Right;", "Lcom/xorrus/trading/common/LegTyp;", "theta", "deltaCall", "deltaPut", "thetaPut", "thetaCall", "preisCall", "preisPut", "volaCall", "optionKurs", "volaPut", "d1", "d2", "pNLEinesLegsBeiZukuenftigemKurs", "bezugsZeitpunkt", "leg", "Lcom/xorrus/trading/common/Leg;", "pNLDerLegsBeiZukuenftigemKurs", "aktuellerKursDesUnderlyings", "legs", "", "S", "r", "sigma", "breiteInSD", "anzahlStuetzstellen", "strikesInnerhalbXSdMitAbstand", "Lkotlin/sequences/Sequence;", "SD", "gleicherAbstand", "min", "max", "anzahl", "LegTyp", "diskretisierteNormalverteilung", "", "", "common-trading-common"})
@SourceDebugExtension(value={"SMAP\nblackschole.kt\nKotlin\n*S Kotlin\n*F\n+ 1 blackschole.kt\ncom/xorrus/trading/common/BlackscholeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,426:1\n1#2:427\n1285#3,2:428\n1299#3,4:430\n*S KotlinDebug\n*F\n+ 1 blackschole.kt\ncom/xorrus/trading/common/BlackscholeKt\n*L\n425#1:428,2\n425#1:430,4\n*E\n"})
public final class BlackscholeKt {
    public static final int JAHR_IN_MINUTEN = 525600;
    public static final double SECONDS_PER_YEAR = 3.1556951999999996E7;

    public static final double yearsBetween(@NotNull Instant from, @NotNull Instant to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        double durationInSeconds = Duration.getInWholeSeconds-impl((long)to.minus-UwyO8pc(from));
        return durationInSeconds / 3.1556951999999996E7;
    }

    @Deprecated(message="Verwende yearsBetween stattdessen", replaceWith=@ReplaceWith(expression="yearsBetween(bezugsDatum, expiry)", imports={}))
    public static final double restlaufzeit(@NotNull Instant bezugsDatum, @NotNull Instant expiry) {
        Intrinsics.checkNotNullParameter((Object)bezugsDatum, (String)"bezugsDatum");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        return BlackscholeKt.yearsBetween(bezugsDatum, expiry);
    }

    public static final double normalverteilt(double x, double erwartungswert, double standardabweichung) {
        return new NormalDistribution(erwartungswert, standardabweichung).cumulativeProbability(x);
    }

    public static /* synthetic */ double normalverteilt$default(double d, double d2, double d3, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        return BlackscholeKt.normalverteilt(d, d2, d3);
    }

    public static final double normaldichte(double x, double erwartungswert, double standardabweichung) {
        return new NormalDistribution(erwartungswert, standardabweichung).density(x);
    }

    public static /* synthetic */ double normaldichte$default(double d, double d2, double d3, int n, Object object) {
        if ((n & 2) != 0) {
            d2 = 0.0;
        }
        if ((n & 4) != 0) {
            d3 = 1.0;
        }
        return BlackscholeKt.normaldichte(d, d2, d3);
    }

    public static final double delta(double underlyingKurs, double strike, double zins, double vola, double Trest, @NotNull Right optionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)optionType), (String)"optionType");
        return switch (WhenMappings.$EnumSwitchMapping$0[optionType.ordinal()]) {
            case 1 -> BlackscholeKt.deltaPut(underlyingKurs, zins, vola, Trest, strike);
            case 2 -> BlackscholeKt.deltaCall(underlyingKurs, zins, vola, Trest, strike);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final double theta(double underlyingKurs, double strike, double zins, double vola, double Trest, @NotNull Right optionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)optionType), (String)"optionType");
        return switch (WhenMappings.$EnumSwitchMapping$0[optionType.ordinal()]) {
            case 1 -> BlackscholeKt.thetaPut(underlyingKurs, zins, vola, Trest, strike);
            case 2 -> BlackscholeKt.thetaCall(underlyingKurs, zins, vola, Trest, strike);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final double deltaCall(double underlyingKurs, double zins, double vola, double Trest, double strike) {
        return BlackscholeKt.normalverteilt$default(BlackscholeKt.d1(underlyingKurs, zins, vola, Trest, strike), 0.0, 0.0, 6, null);
    }

    public static final double deltaPut(double underlyingKurs, double zins, double vola, double Trest, double strike) {
        return BlackscholeKt.deltaCall(underlyingKurs, zins, vola, Trest, strike) - 1.0;
    }

    public static final double thetaPut(double underlyingKurs, double zins, double vola, double Trest, double strike) {
        double d1 = BlackscholeKt.d1(underlyingKurs, zins, vola, Trest, strike);
        double d2 = BlackscholeKt.d2(underlyingKurs, zins, vola, Trest, strike);
        double phiD1 = BlackscholeKt.normaldichte$default(d1, 0.0, 0.0, 6, null);
        double PhiNegD2 = BlackscholeKt.normalverteilt$default(-d2, 0.0, 0.0, 6, null);
        double term1 = -underlyingKurs * phiD1 * vola / ((double)2 * Math.sqrt(Trest));
        double term2 = zins * strike * Math.exp(-zins * Trest) * PhiNegD2;
        return (term1 + term2) / (double)365;
    }

    public static final double thetaCall(double underlyingKurs, double zins, double vola, double Trest, double strike) {
        double d1 = BlackscholeKt.d1(underlyingKurs, zins, vola, Trest, strike);
        double d2 = BlackscholeKt.d2(underlyingKurs, zins, vola, Trest, strike);
        double phiD1 = BlackscholeKt.normaldichte$default(d1, 0.0, 0.0, 6, null);
        double PhiD2 = BlackscholeKt.normalverteilt$default(d2, 0.0, 0.0, 6, null);
        double term1 = -underlyingKurs * phiD1 * vola / ((double)2 * Math.sqrt(Trest));
        double term2 = -zins * strike * Math.exp(-zins * Trest) * PhiD2;
        return (term1 + term2) / (double)365;
    }

    public static final double preisCall(double underlyingKurs, double zins, double vola, double Trest, double strike) {
        double d1 = BlackscholeKt.d1(underlyingKurs, zins, vola, Trest, strike);
        double d2 = BlackscholeKt.d2(underlyingKurs, zins, vola, Trest, strike);
        return underlyingKurs * BlackscholeKt.normalverteilt$default(d1, 0.0, 0.0, 6, null) - strike * Math.exp(-zins * Trest) * BlackscholeKt.normalverteilt$default(d2, 0.0, 0.0, 6, null);
    }

    public static final double preisPut(double underlyingKurs, double zins, double vola, double Trest, double strike) {
        double d1 = BlackscholeKt.d1(underlyingKurs, zins, vola, Trest, strike);
        double d2 = BlackscholeKt.d2(underlyingKurs, zins, vola, Trest, strike);
        return -underlyingKurs * BlackscholeKt.normalverteilt$default(-d1, 0.0, 0.0, 6, null) + strike * Math.exp(-zins * Trest) * BlackscholeKt.normalverteilt$default(-d2, 0.0, 0.0, 6, null);
    }

    public static final double volaCall(double underlyingKurs, double strike, double zins, double optionKurs, double Trest) {
        if (!(Trest >= 0.0)) {
            boolean $i$a$-require-BlackscholeKt$volaCall$52 = false;
            String $i$a$-require-BlackscholeKt$volaCall$52 = "Restlaufzeit darf nicht negativ sein.";
            throw new IllegalArgumentException($i$a$-require-BlackscholeKt$volaCall$52.toString());
        }
        if (!(underlyingKurs > 0.0)) {
            boolean $i$a$-require-BlackscholeKt$volaCall$62 = false;
            String $i$a$-require-BlackscholeKt$volaCall$62 = "Preis des Underlyings muss positiv sein.";
            throw new IllegalArgumentException($i$a$-require-BlackscholeKt$volaCall$62.toString());
        }
        if (!(strike > 0.0)) {
            boolean $i$a$-require-BlackscholeKt$volaCall$72 = false;
            String $i$a$-require-BlackscholeKt$volaCall$72 = "Strike muss positiv sein.";
            throw new IllegalArgumentException($i$a$-require-BlackscholeKt$volaCall$72.toString());
        }
        if (!(optionKurs >= 0.0)) {
            boolean bl = false;
            String string = "Optionspreis kann nicht negativ sein.";
            throw new IllegalArgumentException(string.toString());
        }
        double genauigkeit = 1.0E-7;
        int iterations = 100;
        double vola = 0.5;
        double delta = 1.0;
        int i = 0;
        while (Math.abs(delta) > genauigkeit) {
            ++i;
            double d1 = BlackscholeKt.d1(underlyingKurs, zins, vola, Trest, strike);
            double d2 = BlackscholeKt.d2(underlyingKurs, zins, vola, Trest, strike);
            delta = underlyingKurs * BlackscholeKt.normalverteilt$default(d1, 0.0, 0.0, 6, null) - strike * Math.exp(-zins * Trest) * BlackscholeKt.normalverteilt$default(d2, 0.0, 0.0, 6, null) - optionKurs;
            double vega = underlyingKurs * BlackscholeKt.normalverteilt$default(d1, 0.0, 0.0, 6, null) * Math.sqrt(Trest);
            vola -= delta / vega;
            if (i != iterations) continue;
            System.out.println((Object)"Warnung: Iterationslimit erreicht. Ergebnis k\u00f6nnte ungenau sein.");
            break;
        }
        return vola;
    }

    public static final double volaPut(double underlyingKurs, double strike, double zins, double optionKurs, double Trest) {
        if (!(Trest >= 0.0)) {
            boolean $i$a$-require-BlackscholeKt$volaPut$52 = false;
            String $i$a$-require-BlackscholeKt$volaPut$52 = "Restlaufzeit darf nicht negativ sein.";
            throw new IllegalArgumentException($i$a$-require-BlackscholeKt$volaPut$52.toString());
        }
        if (!(underlyingKurs > 0.0)) {
            boolean $i$a$-require-BlackscholeKt$volaPut$62 = false;
            String $i$a$-require-BlackscholeKt$volaPut$62 = "Preis des Underlyings muss positiv sein.";
            throw new IllegalArgumentException($i$a$-require-BlackscholeKt$volaPut$62.toString());
        }
        if (!(strike > 0.0)) {
            boolean $i$a$-require-BlackscholeKt$volaPut$72 = false;
            String $i$a$-require-BlackscholeKt$volaPut$72 = "Strike muss positiv sein.";
            throw new IllegalArgumentException($i$a$-require-BlackscholeKt$volaPut$72.toString());
        }
        if (!(optionKurs >= 0.0)) {
            boolean bl = false;
            String string = "Optionspreis kann nicht negativ sein.";
            throw new IllegalArgumentException(string.toString());
        }
        double genauigkeit = 1.0E-7;
        int iterations = 100;
        double vola = 0.5;
        double delta = 1.0;
        int i = 0;
        while (Math.abs(delta) > genauigkeit) {
            ++i;
            double d1 = BlackscholeKt.d1(underlyingKurs, zins, vola, Trest, strike);
            double d2 = BlackscholeKt.d2(underlyingKurs, zins, vola, Trest, strike);
            delta = -underlyingKurs * BlackscholeKt.normalverteilt$default(-d1, 0.0, 0.0, 6, null) + strike * Math.exp(-zins * Trest) * BlackscholeKt.normalverteilt$default(-d2, 0.0, 0.0, 6, null) - optionKurs;
            double vega = underlyingKurs * BlackscholeKt.normalverteilt$default(d1, 0.0, 0.0, 6, null) * Math.sqrt(Trest);
            vola -= delta / vega;
            if (i != iterations) continue;
            System.out.println((Object)"Warnung: Iterationslimit erreicht. Ergebnis k\u00f6nnte ungenau sein.");
            break;
        }
        return vola;
    }

    public static final double vola(double underlyingKurs, double strike, double zins, double optionKurs, double Trest, @NotNull Right optionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)optionType), (String)"optionType");
        return switch (WhenMappings.$EnumSwitchMapping$0[optionType.ordinal()]) {
            case 1 -> BlackscholeKt.volaPut(underlyingKurs, strike, zins, optionKurs, Trest);
            case 2 -> BlackscholeKt.volaCall(underlyingKurs, strike, zins, optionKurs, Trest);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final double standardabweichung(double underlyingKurs, double vola, double Trest) {
        return underlyingKurs * vola / Math.sqrt(1.0 / Trest);
    }

    public static final double d1(double underlyingKurs, double zins, double vola, double Trest, double strike) {
        if (!(Trest >= 0.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (Trest == 0.0) {
            return 0.0;
        }
        double sqrtTrest = vola * Math.sqrt(Trest);
        return (Math.log(underlyingKurs / strike) + (zins + Math.pow(vola, 2) / (double)2) * Trest) / sqrtTrest;
    }

    public static final double d2(double underlyingKurs, double zins, double vola, double Trest, double strike) {
        if (!(Trest >= 0.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (Trest == 0.0) {
            return 0.0;
        }
        double sqrtTrest = vola * Math.sqrt(Trest);
        return (Math.log(underlyingKurs / strike) + (zins - Math.pow(vola, 2) / (double)2) * Trest) / sqrtTrest;
    }

    public static final double pNLEinesLegsBeiZukuenftigemKurs(double underlyingKurs, double zins, @NotNull Instant bezugsZeitpunkt, @NotNull Leg leg) {
        Intrinsics.checkNotNullParameter((Object)bezugsZeitpunkt, (String)"bezugsZeitpunkt");
        Intrinsics.checkNotNullParameter((Object)leg, (String)"leg");
        double Trest = BlackscholeKt.yearsBetween(bezugsZeitpunkt, leg.getExpiry());
        double preis = switch (WhenMappings.$EnumSwitchMapping$0[leg.getTyp().ordinal()]) {
            case 2 -> BlackscholeKt.preisCall(underlyingKurs, zins, leg.getVola(), Trest, leg.getStrike());
            case 1 -> BlackscholeKt.preisPut(underlyingKurs, zins, leg.getVola(), Trest, leg.getStrike());
            default -> throw new NoWhenBranchMatchedException();
        };
        return (preis - leg.getKaufkurs()) * leg.getMultiplier() * leg.getAnzahl();
    }

    public static final double pNLDerLegsBeiZukuenftigemKurs(double aktuellerKursDesUnderlyings, double zins, @NotNull Instant bezugsZeitpunkt, @NotNull Collection<Leg> legs) {
        Intrinsics.checkNotNullParameter((Object)bezugsZeitpunkt, (String)"bezugsZeitpunkt");
        Intrinsics.checkNotNullParameter(legs, (String)"legs");
        return SequencesKt.sumOfDouble((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)legs), arg_0 -> BlackscholeKt.pNLDerLegsBeiZukuenftigemKurs$lambda$0(aktuellerKursDesUnderlyings, zins, bezugsZeitpunkt, arg_0)));
    }

    public static final double erwartungswert(double S, double r, double sigma, @NotNull Instant bezugsZeitpunkt, @NotNull Collection<Leg> legs, double breiteInSD, int anzahlStuetzstellen) {
        Intrinsics.checkNotNullParameter((Object)bezugsZeitpunkt, (String)"bezugsZeitpunkt");
        Intrinsics.checkNotNullParameter(legs, (String)"legs");
        Iterator iterator = ((Iterable)legs).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Leg leg = (Leg)iterator.next();
        boolean bl = false;
        double d = BlackscholeKt.standardabweichung(S, sigma, BlackscholeKt.yearsBetween(bezugsZeitpunkt, leg.getExpiry()));
        while (iterator.hasNext()) {
            Leg leg2 = (Leg)iterator.next();
            $i$a$-maxOf-BlackscholeKt$erwartungswert$standardabweichung$1 = false;
            double d2 = BlackscholeKt.standardabweichung(S, sigma, BlackscholeKt.yearsBetween(bezugsZeitpunkt, leg2.getExpiry()));
            d = Math.max(d, d2);
        }
        double standardabweichung = d;
        double step = (double)2 * breiteInSD * standardabweichung / (double)anzahlStuetzstellen;
        return SequencesKt.sumOfDouble((Sequence)SequencesKt.map(BlackscholeKt.strikesInnerhalbXSdMitAbstand(S, standardabweichung, breiteInSD, anzahlStuetzstellen), arg_0 -> BlackscholeKt.erwartungswert$lambda$1(step, S, standardabweichung, r, bezugsZeitpunkt, legs, arg_0)));
    }

    @NotNull
    public static final Sequence<Double> strikesInnerhalbXSdMitAbstand(double S, double SD, double breiteInSD, int anzahlStuetzstellen) {
        double min = Math.max(S - SD * breiteInSD, 0.0);
        double max = S + SD * breiteInSD;
        double step = (double)2 * breiteInSD * SD / (double)anzahlStuetzstellen;
        return SequencesKt.generateSequence((Object)(min + 0.5 * step), arg_0 -> BlackscholeKt.strikesInnerhalbXSdMitAbstand$lambda$0(step, max, arg_0));
    }

    @NotNull
    public static final Sequence<Instant> gleicherAbstand(@NotNull Instant min, @NotNull Instant max, int anzahl) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        long zeitraum = max.minus-UwyO8pc(min);
        long minutes = Duration.getInWholeMinutes-impl((long)zeitraum);
        long minutesPerPeriod = minutes / (long)anzahl;
        Ref.LongRef rest = new Ref.LongRef();
        rest.element = minutes % (long)anzahl;
        return SequencesKt.generateSequence((Object)min, arg_0 -> BlackscholeKt.gleicherAbstand$lambda$0(minutesPerPeriod, rest, max, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Double, Double> diskretisierteNormalverteilung(@NotNull List<Double> x, double erwartungswert, double standardabweichung) {
        void $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter(x, (String)"x");
        Iterable $this$associateWith$iv = x;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            double d = ((Number)element$iv$iv).doubleValue();
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Double d2 = BlackscholeKt.normalverteilt((double)it, erwartungswert, standardabweichung);
            map2.put(t, d2);
        }
        return destination$iv$iv;
    }

    private static final double pNLDerLegsBeiZukuenftigemKurs$lambda$0(double $aktuellerKursDesUnderlyings, double $zins, Instant $bezugsZeitpunkt, Leg leg) {
        Intrinsics.checkNotNullParameter((Object)leg, (String)"leg");
        double pnl = BlackscholeKt.pNLEinesLegsBeiZukuenftigemKurs($aktuellerKursDesUnderlyings, $zins, $bezugsZeitpunkt, leg);
        System.out.println((Object)("Leg: " + leg.getAnzahl() + " " + leg.getTyp().name() + " " + leg.getExpiry() + ", " + leg.getStrike() + ", Vola " + leg.getVola() + " : bei " + $aktuellerKursDesUnderlyings + " am " + $bezugsZeitpunkt + " = " + pnl));
        return pnl;
    }

    private static final double erwartungswert$lambda$1(double $step, double $S, double $standardabweichung, double $r, Instant $bezugsZeitpunkt, Collection $legs, double x) {
        double p = BlackscholeKt.normalverteilt(x + 0.5 * $step, $S, $standardabweichung) - BlackscholeKt.normalverteilt(x - 0.5 * $step, $S, $standardabweichung);
        double pNL = BlackscholeKt.pNLDerLegsBeiZukuenftigemKurs(x, $r, $bezugsZeitpunkt, $legs);
        return p * pNL;
    }

    private static final Double strikesInnerhalbXSdMitAbstand$lambda$0(double $step, double $max, double it) {
        Double d = it + $step;
        double it2 = ((Number)d).doubleValue();
        boolean bl = false;
        return it2 <= $max ? d : null;
    }

    private static final Instant gleicherAbstand$lambda$0(long $minutesPerPeriod, Ref.LongRef $rest, Instant $max, Instant it) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        long l = $rest.element;
        $rest.element = l + -1L;
        long l2 = 1L;
        l = Math.min(l, l2);
        l2 = 0L;
        Instant it2 = instant = it.plus-LRDsOJo(DurationKt.toDuration((long)$minutesPerPeriod, (DurationUnit)DurationUnit.MINUTES)).plus-LRDsOJo(DurationKt.toDuration((long)Math.max(l, l2), (DurationUnit)DurationUnit.MINUTES));
        boolean bl = false;
        return it2.compareTo($max) <= 0 ? instant : null;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Right.values().length];
            try {
                nArray[Right.PUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Right.CALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

