/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.common.contract;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Contract;
import com.xorrus.trading.common.contract.Execution;
import com.xorrus.trading.common.contract.Position;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001#B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u0010\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0\u0012JH\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0\u00122\b\b\u0002\u0010\u001b\u001a\u00020\rJ\u001a\u0010\u001c\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\r0\u0012R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lcom/xorrus/trading/common/contract/Trade;", "", "executions", "", "Lcom/xorrus/trading/common/contract/Execution;", "<init>", "(Ljava/util/List;)V", "getExecutions", "()Ljava/util/List;", "positions", "Lcom/xorrus/trading/common/contract/Position;", "getPositions", "realizedProfit", "Lcom/xorrus/trading/common/bignum/XBigNum;", "getRealizedProfit", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "getPnL", "priceProvider", "Lkotlin/Function1;", "Lcom/xorrus/trading/common/contract/Contract;", "getPnLInFutureCalculator", "instantNow", "Lkotlin/time/Instant;", "instantInFuture", "zinssatz", "", "priceNowProvider", "volaOffset", "getUnrealizedProfit", "positionsWithRealizedProfit", "Lcom/xorrus/trading/common/contract/Trade$PositionsWithRealizedProfit;", "getPositionsWithRealizedProfit", "()Lcom/xorrus/trading/common/contract/Trade$PositionsWithRealizedProfit;", "positionsWithRealizedProfit$delegate", "Lkotlin/Lazy;", "PositionsWithRealizedProfit", "common-trading-common"})
@SourceDebugExtension(value={"SMAP\nTrade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Trade.kt\ncom/xorrus/trading/common/contract/Trade\n+ 2 xbignum.kt\ncom/xorrus/trading/common/XbignumKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n26#2:109\n1803#3,3:110\n1491#3:113\n1516#3,3:114\n1519#3,3:124\n774#3:137\n865#3,2:138\n1869#3,2:140\n382#4,7:117\n136#5,9:127\n216#5:136\n217#5:143\n145#5:144\n1#6:142\n*S KotlinDebug\n*F\n+ 1 Trade.kt\ncom/xorrus/trading/common/contract/Trade\n*L\n45#1:109\n45#1:110,3\n55#1:113\n55#1:114,3\n55#1:124,3\n68#1:137\n68#1:138,2\n69#1:140,2\n55#1:117,7\n60#1:127,9\n60#1:136\n60#1:143\n60#1:144\n60#1:142\n*E\n"})
public final class Trade {
    @NotNull
    private final List<Execution> executions;
    @NotNull
    private final Lazy positionsWithRealizedProfit$delegate;

    public Trade(@NotNull List<Execution> executions) {
        Intrinsics.checkNotNullParameter(executions, (String)"executions");
        this.executions = executions;
        this.positionsWithRealizedProfit$delegate = LazyKt.lazy(() -> Trade.positionsWithRealizedProfit_delegate$lambda$0(this));
    }

    @NotNull
    public final List<Execution> getExecutions() {
        return this.executions;
    }

    @NotNull
    public final List<Position> getPositions() {
        return this.getPositionsWithRealizedProfit().getPositions();
    }

    @NotNull
    public final XBigNum getRealizedProfit() {
        return this.getPositionsWithRealizedProfit().getRealizedProfit();
    }

    @NotNull
    public final XBigNum getPnL(@NotNull Function1<? super Contract, XBigNum> priceProvider) {
        Intrinsics.checkNotNullParameter(priceProvider, (String)"priceProvider");
        return this.getRealizedProfit().plus(this.getUnrealizedProfit(priceProvider));
    }

    @NotNull
    public final Function1<XBigNum, XBigNum> getPnLInFutureCalculator(@NotNull Instant instantNow, @NotNull Instant instantInFuture, double zinssatz, @NotNull Function1<? super Contract, XBigNum> priceNowProvider, @NotNull XBigNum volaOffset) {
        Intrinsics.checkNotNullParameter((Object)instantNow, (String)"instantNow");
        Intrinsics.checkNotNullParameter((Object)instantInFuture, (String)"instantInFuture");
        Intrinsics.checkNotNullParameter(priceNowProvider, (String)"priceNowProvider");
        Intrinsics.checkNotNullParameter((Object)volaOffset, (String)"volaOffset");
        throw new NotImplementedError(null, 1, null);
    }

    public static /* synthetic */ Function1 getPnLInFutureCalculator$default(Trade trade, Instant instant, Instant instant2, double d, Function1 function1, XBigNum xBigNum, int n, Object object) {
        if ((n & 0x10) != 0) {
            xBigNum = XBigNum.Companion.getZERO();
        }
        return trade.getPnLInFutureCalculator(instant, instant2, d, (Function1<? super Contract, XBigNum>)function1, xBigNum);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final XBigNum getUnrealizedProfit(@NotNull Function1<? super Contract, XBigNum> priceProvider) {
        void $this$fold$iv$iv;
        Intrinsics.checkNotNullParameter(priceProvider, (String)"priceProvider");
        Iterable $this$sumOfXBigNum$iv = this.getPositions();
        boolean $i$f$sumOfXBigNum = false;
        Iterable iterable = $this$sumOfXBigNum$iv;
        XBigNum initial$iv$iv = XBigNum.Companion.getZERO();
        boolean $i$f$fold = false;
        XBigNum accumulator$iv$iv = initial$iv$iv;
        Iterator iterator = $this$fold$iv$iv.iterator();
        while (iterator.hasNext()) {
            void pos;
            void element$iv;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            XBigNum sum$iv = accumulator$iv$iv;
            boolean bl = false;
            Position position = (Position)element$iv;
            XBigNum xBigNum = sum$iv;
            boolean bl2 = false;
            XBigNum marketPrice = (XBigNum)priceProvider.invoke((Object)pos.getContract());
            accumulator$iv$iv = xBigNum.plus(marketPrice.minus(pos.getAveragePrice()).times(pos.getSize()));
        }
        return accumulator$iv$iv;
    }

    private final PositionsWithRealizedProfit getPositionsWithRealizedProfit() {
        Lazy lazy = this.positionsWithRealizedProfit$delegate;
        return (PositionsWithRealizedProfit)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final PositionsWithRealizedProfit positionsWithRealizedProfit_delegate$lambda$0(Trade this$0) {
        void $this$mapNotNullTo$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this$0.executions;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Execution it = (Execution)element$iv$iv;
            boolean bl = false;
            Contract key$iv$iv = it.getContract();
            Map map2 = destination$iv$iv;
            Contract key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groupedExecutions = destination$iv$iv;
        XBigNum realizedProfit = null;
        realizedProfit = XBigNum.Companion.getZERO();
        Map $this$mapNotNull$iv = groupedExecutions;
        boolean $i$f$mapNotNull = false;
        Map $i$f$groupByTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Position position;
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl3 = false;
            Contract contract = (Contract)entry.getKey();
            List executionList = (List)entry.getValue();
            XBigNum realizedProfitPerContract = null;
            realizedProfitPerContract = XBigNum.Companion.getZERO();
            XBigNum netDebit = null;
            netDebit = XBigNum.Companion.getZERO();
            XBigNum openPositionSize = null;
            openPositionSize = XBigNum.Companion.getZERO();
            Iterable iterable2 = executionList;
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                Execution it = (Execution)element$iv$iv2;
                boolean bl4 = false;
                if (!(!Intrinsics.areEqual((Object)it.getSize(), (Object)XBigNum.Companion.getZERO()))) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Execution execution = (Execution)element$iv;
                boolean bl5 = false;
                if (!(!Intrinsics.areEqual((Object)execution.getSize(), (Object)XBigNum.Companion.getZERO()))) {
                    String element$iv$iv2 = "Failed requirement.";
                    throw new IllegalArgumentException(element$iv$iv2.toString());
                }
                boolean isClosingShortPosition = execution.getSize().compareTo(XBigNum.Companion.getZERO()) > 0 && openPositionSize.compareTo(XBigNum.Companion.getZERO()) < 0;
                boolean isClosingLongPosition = execution.getSize().compareTo(XBigNum.Companion.getZERO()) < 0 && openPositionSize.compareTo(XBigNum.Companion.getZERO()) > 0;
                if (isClosingShortPosition) {
                    closingSize = (XBigNum)ComparisonsKt.minOf((Comparable)openPositionSize.abs(), (Comparable)execution.getSize().abs());
                    XBigNum sellingPrice = closingSize.times(netDebit.minus(realizedProfitPerContract)).div(openPositionSize);
                    XBigNum buyingPrice = closingSize.times(execution.getPrice().times(execution.getSize()).plus(execution.getCommission())).div(execution.getSize());
                    realizedProfitPerContract = realizedProfitPerContract.plus(sellingPrice.minus(buyingPrice));
                } else if (isClosingLongPosition) {
                    closingSize = (XBigNum)ComparisonsKt.minOf((Comparable)openPositionSize.abs(), (Comparable)execution.getSize().abs());
                    XBigNum buyingPrice = closingSize.times(netDebit.minus(realizedProfitPerContract)).div(openPositionSize);
                    XBigNum sellingPrice = closingSize.times(execution.getPrice().times(execution.getSize()).plus(execution.getCommission())).div(execution.getSize());
                    realizedProfitPerContract = realizedProfitPerContract.plus(sellingPrice.minus(buyingPrice));
                }
                netDebit = netDebit.plus(execution.getPrice().times(execution.getSize()).plus(execution.getCommission()));
                openPositionSize = openPositionSize.plus(execution.getSize());
            }
            realizedProfit = realizedProfit.plus(realizedProfitPerContract);
            if (Intrinsics.areEqual((Object)openPositionSize, (Object)XBigNum.Companion.getZERO())) {
                position = null;
            } else {
                XBigNum avgPrice = netDebit.plus(realizedProfit).div(openPositionSize);
                position = new Position(contract, openPositionSize, avgPrice);
            }
            if (position == null) continue;
            Position it$iv$iv = position;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List positions = (List)destination$iv$iv2;
        return new PositionsWithRealizedProfit(positions, realizedProfit);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/xorrus/trading/common/contract/Trade$PositionsWithRealizedProfit;", "", "positions", "", "Lcom/xorrus/trading/common/contract/Position;", "realizedProfit", "Lcom/xorrus/trading/common/bignum/XBigNum;", "<init>", "(Ljava/util/List;Lcom/xorrus/trading/common/bignum/XBigNum;)V", "getPositions", "()Ljava/util/List;", "getRealizedProfit", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "common-trading-common"})
    private static final class PositionsWithRealizedProfit {
        @NotNull
        private final List<Position> positions;
        @NotNull
        private final XBigNum realizedProfit;

        public PositionsWithRealizedProfit(@NotNull List<Position> positions, @NotNull XBigNum realizedProfit) {
            Intrinsics.checkNotNullParameter(positions, (String)"positions");
            Intrinsics.checkNotNullParameter((Object)realizedProfit, (String)"realizedProfit");
            this.positions = positions;
            this.realizedProfit = realizedProfit;
        }

        @NotNull
        public final List<Position> getPositions() {
            return this.positions;
        }

        @NotNull
        public final XBigNum getRealizedProfit() {
            return this.realizedProfit;
        }

        @NotNull
        public final List<Position> component1() {
            return this.positions;
        }

        @NotNull
        public final XBigNum component2() {
            return this.realizedProfit;
        }

        @NotNull
        public final PositionsWithRealizedProfit copy(@NotNull List<Position> positions, @NotNull XBigNum realizedProfit) {
            Intrinsics.checkNotNullParameter(positions, (String)"positions");
            Intrinsics.checkNotNullParameter((Object)realizedProfit, (String)"realizedProfit");
            return new PositionsWithRealizedProfit(positions, realizedProfit);
        }

        public static /* synthetic */ PositionsWithRealizedProfit copy$default(PositionsWithRealizedProfit positionsWithRealizedProfit, List list, XBigNum xBigNum, int n, Object object) {
            if ((n & 1) != 0) {
                list = positionsWithRealizedProfit.positions;
            }
            if ((n & 2) != 0) {
                xBigNum = positionsWithRealizedProfit.realizedProfit;
            }
            return positionsWithRealizedProfit.copy(list, xBigNum);
        }

        @NotNull
        public String toString() {
            return "PositionsWithRealizedProfit(positions=" + this.positions + ", realizedProfit=" + this.realizedProfit + ")";
        }

        public int hashCode() {
            int result = ((Object)this.positions).hashCode();
            result = result * 31 + this.realizedProfit.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PositionsWithRealizedProfit)) {
                return false;
            }
            PositionsWithRealizedProfit positionsWithRealizedProfit = (PositionsWithRealizedProfit)other;
            if (!Intrinsics.areEqual(this.positions, positionsWithRealizedProfit.positions)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.realizedProfit, (Object)positionsWithRealizedProfit.realizedProfit);
        }
    }
}

