/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.price;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Option;
import com.xorrus.trading.common.contract.Right;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/xorrus/trading/ib/tws/price/OptionChain;", "", "options", "", "Lcom/xorrus/trading/common/contract/Option;", "<init>", "(Ljava/util/List;)V", "getOptions", "()Ljava/util/List;", "right", "Lcom/xorrus/trading/common/contract/Right;", "getRight", "()Lcom/xorrus/trading/common/contract/Right;", "expiration", "Lkotlinx/datetime/LocalDate;", "getExpiration", "()Lkotlinx/datetime/LocalDate;", "getAbove", "option", "getBelow", "areNeighbors", "", "optionA", "optionB", "toString", "", "nearestStrike", "strike", "Lcom/xorrus/trading/common/bignum/XBigNum;", "tws-api"})
@SourceDebugExtension(value={"SMAP\nOptionChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionChain.kt\ncom/xorrus/trading/ib/tws/price/OptionChain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1056#2:72\n1740#2,3:73\n1740#2,3:77\n1669#2,8:80\n2393#2,14:88\n1#3:76\n*S KotlinDebug\n*F\n+ 1 OptionChain.kt\ncom/xorrus/trading/ib/tws/price/OptionChain\n*L\n10#1:72\n19#1:73,3\n22#1:77,3\n25#1:80,8\n68#1:88,14\n*E\n"})
public final class OptionChain {
    @NotNull
    private final List<Option> options;
    @NotNull
    private final Right right;
    @NotNull
    private final LocalDate expiration;

    public OptionChain(@NotNull List<Option> options) {
        boolean bl;
        block12: {
            Option it;
            boolean bl2;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block11: {
                Intrinsics.checkNotNullParameter(options, (String)"options");
                Iterable $this$sortedBy$iv = options;
                boolean $i$f$sortedBy = false;
                this.options = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Option it = (Option)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)it.getStrike();
                        it = (Option)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getStrike()));
                    }
                });
                Option option = (Option)CollectionsKt.firstOrNull(options);
                Object object = option != null ? option.getRight() : null;
                if (object == null) {
                    OptionChain optionChain = this;
                    boolean $i$a$-requireNotNull-OptionChain$right$22 = false;
                    OptionChain optionChain2 = optionChain;
                    String $i$a$-requireNotNull-OptionChain$right$22 = "Optionskette darf nicht leer sein";
                    throw new IllegalArgumentException($i$a$-requireNotNull-OptionChain$right$22.toString());
                }
                this.right = object;
                this.expiration = ((Option)CollectionsKt.first(options)).getExpiration();
                $this$all$iv = options;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        it = (Option)element$iv;
                        boolean bl3 = false;
                        if (it.getRight() == this.right) continue;
                        bl2 = false;
                        break block11;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                boolean $i$a$-require-OptionChain$32 = false;
                String $i$a$-require-OptionChain$32 = "all options must be of the same right";
                throw new IllegalArgumentException($i$a$-require-OptionChain$32.toString());
            }
            $this$all$iv = options;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (Option)element$iv;
                    boolean bl4 = false;
                    if (Intrinsics.areEqual((Object)it.getExpiration(), (Object)this.expiration)) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean $i$a$-require-OptionChain$52 = false;
            String $i$a$-require-OptionChain$52 = "all options must be of the same expiration";
            throw new IllegalArgumentException($i$a$-require-OptionChain$52.toString());
        }
        Iterable $this$distinctBy$iv = options;
        boolean $i$f$distinctBy = false;
        HashSet<XBigNum> set$iv = new HashSet<XBigNum>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Option it = (Option)e$iv;
            boolean bl5 = false;
            XBigNum key$iv = it.getStrike();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        if (!(((List)list$iv).size() == options.size())) {
            boolean bl6 = false;
            String string = "Optionchain darf keine doppelten Strikes enthalten";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final List<Option> getOptions() {
        return this.options;
    }

    @NotNull
    public final Right getRight() {
        return this.right;
    }

    @NotNull
    public final LocalDate getExpiration() {
        return this.expiration;
    }

    @Nullable
    public final Option getAbove(@NotNull Option option) {
        int index;
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        int n = index = this.options.indexOf(option);
        return n == -1 || n == CollectionsKt.getLastIndex(this.options) ? null : this.options.get(index + 1);
    }

    @Nullable
    public final Option getBelow(@NotNull Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        int index = this.options.indexOf(option);
        return index > 0 ? this.options.get(index - 1) : null;
    }

    public final boolean areNeighbors(@Nullable Option optionA, @Nullable Option optionB) {
        if (optionA == null || optionB == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)optionA, (Object)this.getBelow(optionB)) || Intrinsics.areEqual((Object)optionB, (Object)this.getBelow(optionA));
    }

    @NotNull
    public String toString() {
        return "OptionChain(right=" + this.right + ", expiration=" + this.expiration + ", options=" + this.options.size() + ")";
    }

    @NotNull
    public final Option nearestStrike(@NotNull XBigNum strike) {
        Object t;
        Intrinsics.checkNotNullParameter((Object)strike, (String)"strike");
        Iterable $this$minBy$iv = this.options;
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = minElem$iv;
        } else {
            Option it = (Option)minElem$iv;
            boolean bl = false;
            Comparable minValue$iv = (Comparable)it.getStrike().minus(strike).abs();
            do {
                Object e$iv = iterator$iv.next();
                Option it2 = (Option)e$iv;
                $i$a$-minByOrThrow-OptionChain$nearestStrike$1 = false;
                Comparable v$iv = (Comparable)it2.getStrike().minus(strike).abs();
                if (minValue$iv.compareTo(v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = minElem$iv;
        }
        return (Option)t;
    }
}

