/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.contract.cache;

import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.ib.tws.contract.cache.CacheEntry;
import com.xorrus.trading.ib.tws.contract.cache.CacheRefresher;
import com.xorrus.trading.ib.tws.contract.cache.Ehcache_utilsKt;
import com.xorrus.trading.ib.tws.contract.cache.TwsCache;
import com.xorrus.trading.ib.tws.contract.cache.serializer.CacheEntryEhcacheSerializer;
import com.xorrus.trading.ib.tws.contract.ib.ITwsConnectionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.Instant;
import kotlinx.coroutines.CoroutineScope;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.spi.serialization.Serializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 @*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\u0001@B\u00a1\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\u0017\u001a\u00020\u0015\u0012$\u0010\u0018\u001a \b\u0001\u0012\u0004\u0012\u00028\u0000\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ*\u0010(\u001a\u0002H)\"\u0004\b\u0002\u0010)\"\u0004\b\u0003\u0010**\u000e\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u0002H*0+H\u0086\u0002\u00a2\u0006\u0002\u0010,J*\u0010-\u001a\u0002H*\"\u0004\b\u0002\u0010)\"\u0004\b\u0003\u0010**\u000e\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u0002H*0+H\u0086\u0002\u00a2\u0006\u0002\u0010,J\b\u0010.\u001a\u00020/H\u0002J\u0015\u00100\u001a\u0004\u0018\u00018\u00012\u0006\u00101\u001a\u00028\u0000\u00a2\u0006\u0002\u00102J\u0018\u00103\u001a\u0004\u0018\u00018\u00012\u0006\u00101\u001a\u00028\u0000H\u0096@\u00a2\u0006\u0002\u00104J\u001b\u00105\u001a\u00020/2\u0006\u00101\u001a\u00028\u00002\u0006\u00106\u001a\u00028\u0001\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\u0004\u0018\u00018\u00012\u0006\u00101\u001a\u00028\u0000H\u0082@\u00a2\u0006\u0002\u00104J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0002J\b\u0010<\u001a\u0004\u0018\u00010:J\u000e\u0010=\u001a\u00020/H\u0086@\u00a2\u0006\u0002\u0010>J\u000e\u0010?\u001a\u00020/H\u0086@\u00a2\u0006\u0002\u0010>R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0010\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0010\u0010\u0017\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR.\u0010\u0018\u001a \b\u0001\u0012\u0004\u0012\u00028\u0000\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R \u0010!\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/xorrus/trading/ib/tws/contract/cache/TwsCache;", "KEY", "", "VALUE", "cacheManager", "Lorg/ehcache/CacheManager;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "connectionProvider", "Lcom/xorrus/trading/ib/tws/contract/ib/ITwsConnectionProvider;", "cacheName", "", "heapEntries", "", "diskSizeMB", "ehCacheKeySerializer", "Lorg/ehcache/spi/serialization/Serializer;", "ehCacheValueSerializer", "keyJavaClass", "Ljava/lang/Class;", "refreshAfterMin", "Lkotlin/time/Duration;", "refreshAfterMax", "maxIdle", "loader", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "<init>", "(Lorg/ehcache/CacheManager;Lkotlinx/coroutines/CoroutineScope;Lcom/xorrus/trading/ib/tws/contract/ib/ITwsConnectionProvider;Ljava/lang/String;JLjava/lang/Long;Lorg/ehcache/spi/serialization/Serializer;Lorg/ehcache/spi/serialization/Serializer;Ljava/lang/Class;JJJLkotlin/jvm/functions/Function2;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCacheName", "()Ljava/lang/String;", "J", "Lkotlin/jvm/functions/Function2;", "ehcache", "Lorg/ehcache/Cache;", "Lcom/xorrus/trading/ib/tws/contract/cache/CacheEntry;", "pq", "Ljava/util/PriorityQueue;", "refresher", "Lcom/xorrus/trading/ib/tws/contract/cache/CacheRefresher;", "component1", "K", "V", "Lorg/ehcache/Cache$Entry;", "(Lorg/ehcache/Cache$Entry;)Ljava/lang/Object;", "component2", "rebuildPriorityQueueFromCache", "", "get", "ident", "(Ljava/lang/Object;)Ljava/lang/Object;", "getOrLoad", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "reloadEntry", "calculateNextRefresh", "Lkotlin/time/Instant;", "now", "nextRefreshAt", "refreshOne", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "Companion", "tws-api"})
@SourceDebugExtension(value={"SMAP\nTwsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TwsCache.kt\ncom/xorrus/trading/ib/tws/contract/cache/TwsCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n1#2:284\n774#3:285\n865#3,2:286\n1869#3,2:288\n*S KotlinDebug\n*F\n+ 1 TwsCache.kt\ncom/xorrus/trading/ib/tws/contract/cache/TwsCache\n*L\n99#1:285\n99#1:286,2\n100#1:288,2\n*E\n"})
public class TwsCache<KEY, VALUE> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ITwsConnectionProvider connectionProvider;
    @NotNull
    private final String cacheName;
    private final long refreshAfterMin;
    private final long refreshAfterMax;
    private final long maxIdle;
    @NotNull
    private final Function2<KEY, Continuation<? super VALUE>, Object> loader;
    @NotNull
    private final Cache<KEY, CacheEntry<VALUE>> ehcache;
    @NotNull
    private final PriorityQueue<KEY> pq;
    @NotNull
    private final CacheRefresher refresher;
    @NotNull
    private static final Logger logger;

    private TwsCache(CacheManager cacheManager, CoroutineScope scope, ITwsConnectionProvider connectionProvider, String cacheName, long heapEntries, Long diskSizeMB, Serializer<KEY> ehCacheKeySerializer, Serializer<VALUE> ehCacheValueSerializer, Class<KEY> keyJavaClass, long refreshAfterMin, long refreshAfterMax, long maxIdle, Function2<? super KEY, ? super Continuation<? super VALUE>, ? extends Object> loader) {
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)connectionProvider, (String)"connectionProvider");
        Intrinsics.checkNotNullParameter((Object)cacheName, (String)"cacheName");
        Intrinsics.checkNotNullParameter(ehCacheKeySerializer, (String)"ehCacheKeySerializer");
        Intrinsics.checkNotNullParameter(ehCacheValueSerializer, (String)"ehCacheValueSerializer");
        Intrinsics.checkNotNullParameter(keyJavaClass, (String)"keyJavaClass");
        Intrinsics.checkNotNullParameter(loader, (String)"loader");
        this.scope = scope;
        this.connectionProvider = connectionProvider;
        this.cacheName = cacheName;
        this.refreshAfterMin = refreshAfterMin;
        this.refreshAfterMax = refreshAfterMax;
        this.maxIdle = maxIdle;
        this.loader = loader;
        if (!Duration.isPositive-impl((long)this.refreshAfterMin)) {
            boolean $i$a$-require-TwsCache$32 = false;
            String $i$a$-require-TwsCache$32 = "refreshAfterMin muss positiv sein";
            throw new IllegalArgumentException($i$a$-require-TwsCache$32.toString());
        }
        if (!(Duration.compareTo-LRDsOJo((long)this.refreshAfterMax, (long)this.refreshAfterMin) > 0)) {
            boolean bl = false;
            String string = "refreshAfterMax muss gr\u00f6\u00dfer sein als refreshAfterMin";
            throw new IllegalArgumentException(string.toString());
        }
        this.ehcache = Ehcache_utilsKt.createEhCache(cacheManager, this.cacheName, ehCacheKeySerializer, (Serializer)new CacheEntryEhcacheSerializer<VALUE>(ehCacheValueSerializer), keyJavaClass, CacheEntry.class, heapEntries, diskSizeMB);
        this.pq = new PriorityQueue(new Comparator(this){
            final /* synthetic */ TwsCache this$0;
            {
                this.this$0 = twsCache;
            }

            public final int compare(T a, T b) {
                T it = a;
                boolean bl = false;
                CacheEntry cacheEntry = (CacheEntry)TwsCache.access$getEhcache$p(this.this$0).get(it);
                it = b;
                Comparable comparable = (Comparable)(cacheEntry != null ? cacheEntry.getRefreshAt() : null);
                bl = false;
                CacheEntry cacheEntry2 = (CacheEntry)TwsCache.access$getEhcache$p(this.this$0).get(it);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)(cacheEntry2 != null ? cacheEntry2.getRefreshAt() : null)));
            }
        });
        this.refresher = new CacheRefresher(this, this.scope);
        this.rebuildPriorityQueueFromCache();
        this.refresher.start();
    }

    @NotNull
    public final String getCacheName() {
        return this.cacheName;
    }

    public final <K, V> K component1(@NotNull Cache.Entry<K, V> $this$component1) {
        Intrinsics.checkNotNullParameter($this$component1, (String)"<this>");
        return (K)$this$component1.getKey();
    }

    public final <K, V> V component2(@NotNull Cache.Entry<K, V> $this$component2) {
        Intrinsics.checkNotNullParameter($this$component2, (String)"<this>");
        return (V)$this$component2.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void rebuildPriorityQueueFromCache() {
        void $this$filterTo$iv$iv;
        this.pq.clear();
        Iterable $this$filter$iv = (Iterable)this.ehcache;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Cache.Entry it = (Cache.Entry)element$iv$iv;
            boolean bl = false;
            if (!(it.getValue() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Cache.Entry entry = (Cache.Entry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)entry);
            Object ident = this.component1(entry);
            this.pq.offer(ident);
        }
        logger.debug("Rebuilt PQ with " + this.pq.size() + " entries from persistent Ehcache");
    }

    @Nullable
    public final VALUE get(@NotNull KEY ident) {
        Intrinsics.checkNotNullParameter(ident, (String)"ident");
        CacheEntry cacheEntry = (CacheEntry)this.ehcache.get(ident);
        if (cacheEntry == null) {
            return null;
        }
        CacheEntry entry = cacheEntry;
        Instant now = DateKt.now();
        CacheEntry updated = CacheEntry.copy$default(entry, null, now, null, 5, null);
        Object[] objectArray = new Object[]{ident, entry.getLastAccessAt(), now};
        logger.debug("Cache " + this.cacheName + " hit: {}  lastAccessAt={} \u2192 {}", objectArray);
        this.ehcache.put(ident, (Object)updated);
        return (VALUE)updated.getValue();
    }

    @Nullable
    public Object getOrLoad(@NotNull KEY ident, @NotNull Continuation<? super VALUE> $completion) {
        return TwsCache.getOrLoad$suspendImpl(this, ident, $completion);
    }

    static /* synthetic */ <KEY, VALUE> Object getOrLoad$suspendImpl(TwsCache<KEY, VALUE> $this, KEY ident, Continuation<? super VALUE> $completion) {
        CacheEntry entry = (CacheEntry)$this.ehcache.get(ident);
        if (entry != null) {
            Instant now = DateKt.now();
            CacheEntry updated = CacheEntry.copy$default(entry, null, now, null, 5, null);
            Object[] objectArray = new Object[]{ident, entry.getLastAccessAt(), now};
            logger.debug("Cache " + $this.cacheName + " hit: {}  lastAccessAt={} \u2192 {}", objectArray);
            $this.ehcache.put(ident, (Object)updated);
            return updated.getValue();
        }
        logger.debug("Cache " + $this.cacheName + " miss \u2192 load: {}", ident);
        return super.reloadEntry(ident, $completion);
    }

    public final void put(@NotNull KEY ident, @NotNull VALUE value) {
        Intrinsics.checkNotNullParameter(ident, (String)"ident");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        CacheEntry<VALUE> entry = new CacheEntry<VALUE>(value, DateKt.now(), this.calculateNextRefresh(DateKt.now()));
        this.ehcache.put(ident, entry);
        this.pq.remove(ident);
        this.pq.offer(ident);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object reloadEntry(KEY ident, Continuation<? super VALUE> $completion) {
        if (!($completion instanceof reloadEntry.1)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ TwsCache<KEY, VALUE> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TwsCache.access$reloadEntry(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                now = DateKt.now();
                previous = (CacheEntry)this.ehcache.get(ident /* !! */ );
                v0 = previous;
                if (v0 == null || (v0 = v0.getLastAccessAt()) == null) {
                    v0 = now;
                }
                oldLastAccessAt /* !! */  = v0;
                $continuation.L$0 = ident /* !! */ ;
                $continuation.L$1 = now;
                $continuation.L$2 = previous;
                $continuation.L$3 = oldLastAccessAt /* !! */ ;
                $continuation.label = 1;
                v1 = this.loader.invoke(ident /* !! */ , (Object)$continuation);
                if (v1 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl34
            }
            case 1: {
                oldLastAccessAt /* !! */  = (Instant)$continuation.L$3;
                previous = (CacheEntry)$continuation.L$2;
                now = (Instant)$continuation.L$1;
                ident /* !! */  = $continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl34:
                // 2 sources

                raw = v1;
                newEntry = new CacheEntry<Object>(raw, oldLastAccessAt /* !! */ , this.calculateNextRefresh(now));
                this.ehcache.put(ident /* !! */ , newEntry);
                this.pq.offer(ident /* !! */ );
                return raw;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Instant calculateNextRefresh(Instant now) {
        long minMillis = Duration.getInWholeMilliseconds-impl((long)this.refreshAfterMin);
        long maxMillis = Duration.getInWholeMilliseconds-impl((long)this.refreshAfterMax);
        long delta = maxMillis - minMillis;
        long randomOffset = Random.Default.nextLong(0L, delta + 1L);
        long offsetDuration = DurationKt.toDuration((long)(minMillis + randomOffset), (DurationUnit)DurationUnit.MILLISECONDS);
        return now.plus-LRDsOJo(offsetDuration);
    }

    @Nullable
    public final Instant nextRefreshAt() {
        while (this.pq.peek() != null) {
            KEY ident;
            CacheEntry entry = (CacheEntry)this.ehcache.get(ident);
            if (entry != null) {
                return entry.getRefreshAt();
            }
            this.pq.poll();
        }
        return null;
    }

    @Nullable
    public final Object refreshOne(@NotNull Continuation<? super Unit> $completion) {
        Instant now;
        CacheEntry entry;
        KEY ident;
        while (true) {
            if (this.pq.poll() == null) {
                return Unit.INSTANCE;
            }
            entry = (CacheEntry)this.ehcache.get(ident);
            if (entry == null) {
                logger.info("Cache deleted (not found in Ehcache): {}", ident);
                continue;
            }
            now = DateKt.now();
            if (Duration.compareTo-LRDsOJo((long)now.minus-UwyO8pc(entry.getLastAccessAt()), (long)this.maxIdle) <= 0) break;
            Object[] objectArray = new Object[]{Duration.box-impl((long)this.maxIdle), ident, entry.getLastAccessAt()};
            logger.info("Cache deleted (idle > {}): {}  lastAccessAt={}", objectArray);
            this.ehcache.remove(ident);
        }
        if (now.compareTo(entry.getRefreshAt()) >= 0) {
            logger.debug("Cache reload: {}  refreshAt={}", ident, (Object)entry.getRefreshAt());
            v0 = this.reloadEntry(ident, $completion);
            if (v0 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return v0;
            }
        } else {
            v0 = Boxing.boxBoolean((boolean)this.pq.offer(ident));
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object close(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.refresher.stop($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public /* synthetic */ TwsCache(CacheManager cacheManager, CoroutineScope scope, ITwsConnectionProvider connectionProvider, String cacheName, long heapEntries, Long diskSizeMB, Serializer ehCacheKeySerializer, Serializer ehCacheValueSerializer, Class keyJavaClass, long refreshAfterMin, long refreshAfterMax, long maxIdle, Function2 loader, DefaultConstructorMarker $constructor_marker) {
        this(cacheManager, scope, connectionProvider, cacheName, heapEntries, diskSizeMB, ehCacheKeySerializer, ehCacheValueSerializer, keyJavaClass, refreshAfterMin, refreshAfterMax, maxIdle, loader);
    }

    public static final /* synthetic */ Object access$reloadEntry(TwsCache $this, Object ident, Continuation $completion) {
        return $this.reloadEntry(ident, $completion);
    }

    public static final /* synthetic */ Cache access$getEhcache$p(TwsCache $this) {
        return $this.ehcache;
    }

    static {
        Logger logger = LoggerFactory.getLogger(TwsCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        TwsCache.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/xorrus/trading/ib/tws/contract/cache/TwsCache$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "tws-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

