/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.api.type;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/xorrus/trading/ib/tws/api/type/HistoricalSession;", "", "begin", "Lkotlin/time/Instant;", "end", "refDate", "Lkotlinx/datetime/LocalDate;", "<init>", "(Lkotlin/time/Instant;Lkotlin/time/Instant;Lkotlinx/datetime/LocalDate;)V", "getBegin", "()Lkotlin/time/Instant;", "getEnd", "getRefDate", "()Lkotlinx/datetime/LocalDate;", "getBeginInTimeZone", "Lkotlinx/datetime/LocalTime;", "timeZone", "Lkotlinx/datetime/TimeZone;", "getEndInTimeZone", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "tws-api"})
public final class HistoricalSession {
    @NotNull
    private final Instant begin;
    @NotNull
    private final Instant end;
    @NotNull
    private final LocalDate refDate;

    public HistoricalSession(@NotNull Instant begin, @NotNull Instant end, @NotNull LocalDate refDate) {
        Intrinsics.checkNotNullParameter((Object)begin, (String)"begin");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)refDate, (String)"refDate");
        this.begin = begin;
        this.end = end;
        this.refDate = refDate;
    }

    @NotNull
    public final Instant getBegin() {
        return this.begin;
    }

    @NotNull
    public final Instant getEnd() {
        return this.end;
    }

    @NotNull
    public final LocalDate getRefDate() {
        return this.refDate;
    }

    @NotNull
    public final LocalTime getBeginInTimeZone(@NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        long durationFromMidnight = this.begin.minus-UwyO8pc(TimeZoneKt.atStartOfDayIn$default((LocalDate)this.refDate, (TimeZone)timeZone, null, (int)2, null));
        return LocalTime.Companion.fromSecondOfDay((int)Duration.getInWholeSeconds-impl((long)durationFromMidnight));
    }

    @NotNull
    public final LocalTime getEndInTimeZone(@NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        long durationFromMidnight = this.end.minus-UwyO8pc(TimeZoneKt.atStartOfDayIn$default((LocalDate)this.refDate, (TimeZone)timeZone, null, (int)2, null));
        return LocalTime.Companion.fromSecondOfDay((int)Duration.getInWholeSeconds-impl((long)durationFromMidnight));
    }

    @NotNull
    public final Instant component1() {
        return this.begin;
    }

    @NotNull
    public final Instant component2() {
        return this.end;
    }

    @NotNull
    public final LocalDate component3() {
        return this.refDate;
    }

    @NotNull
    public final HistoricalSession copy(@NotNull Instant begin, @NotNull Instant end, @NotNull LocalDate refDate) {
        Intrinsics.checkNotNullParameter((Object)begin, (String)"begin");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)refDate, (String)"refDate");
        return new HistoricalSession(begin, end, refDate);
    }

    public static /* synthetic */ HistoricalSession copy$default(HistoricalSession historicalSession, Instant instant, Instant instant2, LocalDate localDate, int n, Object object) {
        if ((n & 1) != 0) {
            instant = historicalSession.begin;
        }
        if ((n & 2) != 0) {
            instant2 = historicalSession.end;
        }
        if ((n & 4) != 0) {
            localDate = historicalSession.refDate;
        }
        return historicalSession.copy(instant, instant2, localDate);
    }

    @NotNull
    public String toString() {
        return "HistoricalSession(begin=" + this.begin + ", end=" + this.end + ", refDate=" + this.refDate + ")";
    }

    public int hashCode() {
        int result = this.begin.hashCode();
        result = result * 31 + this.end.hashCode();
        result = result * 31 + this.refDate.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HistoricalSession)) {
            return false;
        }
        HistoricalSession historicalSession = (HistoricalSession)other;
        if (!Intrinsics.areEqual((Object)this.begin, (Object)historicalSession.begin)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.end, (Object)historicalSession.end)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.refDate, (Object)historicalSession.refDate);
    }
}

