/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.price;

import com.xorrus.trading.common.contract.Contract;
import com.xorrus.trading.ib.tws.api.type.TickType;
import com.xorrus.trading.ib.tws.price.IMarketDataFlow;
import com.xorrus.trading.ib.tws.price.IRememberMarketDataFlow;
import com.xorrus.trading.ib.tws.price.RememberPriceFlowAdapter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\nH\u0016J\t\u0010\u001a\u001a\u00020\u0014H\u0096\u0001R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/xorrus/trading/ib/tws/price/RememberPriceFlowAdapter;", "Lcom/xorrus/trading/ib/tws/price/IRememberMarketDataFlow;", "Lcom/xorrus/trading/ib/tws/price/IMarketDataFlow;", "marketDataAboFlow", "<init>", "(Lcom/xorrus/trading/ib/tws/price/IMarketDataFlow;)V", "getMarketDataAboFlow", "()Lcom/xorrus/trading/ib/tws/price/IMarketDataFlow;", "prices", "", "Lcom/xorrus/trading/common/contract/Contract;", "", "Lcom/xorrus/trading/ib/tws/price/IMarketDataFlow$TickData;", "getPrices", "", "contract", "getPrice", "tickType", "Lcom/xorrus/trading/ib/tws/api/type/TickType;", "collect", "", "collector", "Lkotlinx/coroutines/flow/FlowCollector;", "(Lkotlinx/coroutines/flow/FlowCollector;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addAbo", "removeAbo", "close", "abos", "getAbos", "()Ljava/util/List;", "tws-api"})
@SourceDebugExtension(value={"SMAP\nRememberPriceAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RememberPriceAdapter.kt\ncom/xorrus/trading/ib/tws/price/RememberPriceFlowAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n295#2,2:65\n*S KotlinDebug\n*F\n+ 1 RememberPriceAdapter.kt\ncom/xorrus/trading/ib/tws/price/RememberPriceFlowAdapter\n*L\n39#1:65,2\n*E\n"})
final class RememberPriceFlowAdapter
implements IRememberMarketDataFlow,
IMarketDataFlow {
    @NotNull
    private final IMarketDataFlow marketDataAboFlow;
    @NotNull
    private final Map<Contract, List<IMarketDataFlow.TickData>> prices;

    public RememberPriceFlowAdapter(@NotNull IMarketDataFlow marketDataAboFlow) {
        Intrinsics.checkNotNullParameter((Object)marketDataAboFlow, (String)"marketDataAboFlow");
        this.marketDataAboFlow = marketDataAboFlow;
        this.prices = new LinkedHashMap();
    }

    @NotNull
    public final IMarketDataFlow getMarketDataAboFlow() {
        return this.marketDataAboFlow;
    }

    @Override
    @NotNull
    public List<IMarketDataFlow.TickData> getPrices(@NotNull Contract contract) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        List list = this.prices.get(contract);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public IMarketDataFlow.TickData getPrice(@NotNull Contract contract, @NotNull TickType tickType) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
            Intrinsics.checkNotNullParameter((Object)((Object)tickType), (String)"tickType");
            Iterable $this$firstOrNull$iv = this.getPrices(contract);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IMarketDataFlow.TickData it = (IMarketDataFlow.TickData)element$iv;
                boolean bl = false;
                if (!(it.getTickType() == tickType)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public Object collect(@NotNull FlowCollector<? super IMarketDataFlow.TickData> collector2, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.marketDataAboFlow.collect(new FlowCollector(this, collector2){
            final /* synthetic */ RememberPriceFlowAdapter this$0;
            final /* synthetic */ FlowCollector<IMarketDataFlow.TickData> $collector;
            {
                this.this$0 = $receiver;
                this.$collector = $collector;
            }

            /*
             * WARNING - void declaration
             */
            public final Object emit(IMarketDataFlow.TickData tickData, Continuation<? super Unit> $completion) {
                Object object;
                void $this$getOrPut$iv;
                Contract option = tickData.getContract();
                Map map2 = RememberPriceFlowAdapter.access$getPrices$p(this.this$0);
                Contract key$iv = option;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList<E>();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List tickDataList = (List)object;
                tickDataList.removeIf(arg_0 -> collect.2.emit$lambda$2(arg_0 -> collect.2.emit$lambda$1(tickData, arg_0), arg_0));
                tickDataList.add(tickData);
                Object object2 = this.$collector.emit((Object)tickData, $completion);
                if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object2;
                }
                return Unit.INSTANCE;
            }

            private static final boolean emit$lambda$1(IMarketDataFlow.TickData $tickData, IMarketDataFlow.TickData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getTickType() == $tickData.getTickType();
            }

            private static final boolean emit$lambda$2(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void addAbo(@NotNull Contract contract) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        this.prices.put(contract, new ArrayList());
        this.marketDataAboFlow.addAbo(contract);
    }

    @Override
    public void removeAbo(@NotNull Contract contract) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        this.marketDataAboFlow.removeAbo(contract);
        this.prices.remove(contract);
    }

    @Override
    @NotNull
    public List<Contract> getAbos() {
        return this.marketDataAboFlow.getAbos();
    }

    @Override
    public void close() {
        this.marketDataAboFlow.close();
    }

    public static final /* synthetic */ Map access$getPrices$p(RememberPriceFlowAdapter $this) {
        return $this.prices;
    }
}

