/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.contract.cache.serializer;

import com.xorrus.trading.ib.tws.contract.cache.CacheEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.time.Instant;
import org.ehcache.spi.serialization.Serializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u001f\u0010\f\u001a\u00020\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u000b\u001a\u00020\bH\u0096\u0002J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/xorrus/trading/ib/tws/contract/cache/serializer/CacheEntryEhcacheSerializer;", "V", "Lorg/ehcache/spi/serialization/Serializer;", "Lcom/xorrus/trading/ib/tws/contract/cache/CacheEntry;", "valueSerializer", "<init>", "(Lorg/ehcache/spi/serialization/Serializer;)V", "serialize", "Ljava/nio/ByteBuffer;", "cacheEntry", "read", "binary", "equals", "", "other", "", "hashCode", "", "tws-api"})
public final class CacheEntryEhcacheSerializer<V>
implements Serializer<CacheEntry<V>> {
    @NotNull
    private final Serializer<V> valueSerializer;

    public CacheEntryEhcacheSerializer(@NotNull Serializer<V> valueSerializer) {
        Intrinsics.checkNotNullParameter(valueSerializer, (String)"valueSerializer");
        this.valueSerializer = valueSerializer;
    }

    @NotNull
    public ByteBuffer serialize(@NotNull CacheEntry<V> cacheEntry) {
        Intrinsics.checkNotNullParameter(cacheEntry, (String)"cacheEntry");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        out.writeBoolean(cacheEntry.getValue() != null);
        if (cacheEntry.getValue() != null) {
            ByteBuffer valueBuffer = this.valueSerializer.serialize(cacheEntry.getValue());
            byte[] bytes = new byte[valueBuffer.remaining()];
            valueBuffer.duplicate().get(bytes);
            out.writeInt(bytes.length);
            out.write(bytes);
        }
        out.writeLong(cacheEntry.getLastAccessAt().toEpochMilliseconds());
        out.writeLong(cacheEntry.getRefreshAt().toEpochMilliseconds());
        out.flush();
        ByteBuffer byteBuffer = ByteBuffer.wrap(bos.toByteArray());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(...)");
        return byteBuffer;
    }

    @NotNull
    public CacheEntry<V> read(@NotNull ByteBuffer binary) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        byte[] inputBytes = new byte[binary.remaining()];
        binary.duplicate().get(inputBytes);
        ByteArrayInputStream bis = new ByteArrayInputStream(inputBytes);
        DataInputStream inp = new DataInputStream(bis);
        boolean hasValue = inp.readBoolean();
        if (hasValue) {
            int size = inp.readInt();
            byte[] bytes = new byte[size];
            inp.readFully(bytes);
            object = this.valueSerializer.read(ByteBuffer.wrap(bytes));
        } else {
            object = null;
        }
        Object value = object;
        Instant lastAccessAt = Instant.Companion.fromEpochMilliseconds(inp.readLong());
        Instant refreshAt = Instant.Companion.fromEpochMilliseconds(inp.readLong());
        return new CacheEntry<Object>(value, lastAccessAt, refreshAt);
    }

    public boolean equals(@NotNull CacheEntry<V> cacheEntry, @NotNull ByteBuffer binary) {
        boolean bl;
        Intrinsics.checkNotNullParameter(cacheEntry, (String)"cacheEntry");
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        try {
            Object deserialized = this.read(binary);
            bl = Intrinsics.areEqual(cacheEntry, (Object)deserialized);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof CacheEntryEhcacheSerializer;
    }

    public int hashCode() {
        return Reflection.getOrCreateKotlinClass(CacheEntryEhcacheSerializer.class).hashCode();
    }
}

